static char rcsid[] = "$Id: shell_misc.c,v 1.1 1992/12/11 19:04:38 dhb Exp $";

/*
** $Log: shell_misc.c,v $
** Revision 1.1  1992/12/11  19:04:38  dhb
** Initial revision
**
*/

#include "shell_ext.h"
#include <sys/types.h>
#include <sys/stat.h>

/*
** this is needed for qsort which destroys the values of the pointers
** passed to it
*/
int Strcmp(s1,s2)
char	**s1;
char	**s2;
{
    return(strcmp(*s1,*s2));
}

int do_cd(argc,argv)
int	argc;
char	**argv;
{
char string[200];
char *newenv;
char *home;
char *getenv();

    if(argc < 2){
	printf("usage: %s path\n",argv[0]);
	return(0);
    }
    if(argv[1][0] == '~'){
	home = getenv("HOME");
	if(!home){
	    printf("cant find home directory\n");
	    return(0);
	} else {
	    sprintf(string,"%s%s",home,argv[1]+1);
	}
    } else {
	strcpy(string,argv[1]);
    }
    if(chdir(string) == -1){
	printf("could not change to '%s'\n",argv[1]);
	return(0);
    }
    return(1);
}

void do_printargs(argc,argv)
int argc;
char **argv;
{
int		i;

    for(i=1;i<argc;i++){
	printf("argc %d : %s\n",i,argv[i]);
    }
}

void do_echo(argc,argv)
int argc;
char **argv;
{
int	i;
int	nxtarg;
int	cr;
char	*format;
int	userformat;
/* Upi Bhalla hacks to try to get echo to work on the Delta */
#ifdef i860
char	line[200];
char	temp[100];

line[0]='\0';
#endif

    nxtarg = 0;
    cr = 1;
    format = "%s";
    userformat = 0;
    while( argc > ++nxtarg){
	if(strcmp(argv[nxtarg],"-n") == 0){
	    /*
	    ** no cr option
	    */
	    cr = 0;
	    continue;
	}
	if((argc > nxtarg+1) && (strcmp(argv[nxtarg],"-format") == 0)){
	    if(argc <= nxtarg+1){
		Error();
		printf("%s : missing formatting arguments\n",argv[0]);
		return;
	    }
	    /*
	    ** user formatting
	    */
	    format = argv[++nxtarg];
	    userformat = 1;
	    continue;
	}
	break;
    }
#ifdef i860
    for(i=nxtarg;i<argc;i++){
	/*
	** print out each argument
	*/
	sprintf(temp,format,argv[i]);
	strcat(line,temp);
	if(i < argc-1 && !userformat){
	    /*
	    ** place a space after all but the last argument
	    */
		strcat(line," ");
	}
    }
    if(cr){
		printf("%s\n",line);
    } else {
		printf("%s",line);
		fflush(stdout);
    }
#else
    for(i=nxtarg;i<argc;i++){
	/*
	** print out each argument
	*/
	lprintf(format,argv[i]);
	if(i < argc-1 && !userformat){
	    /*
	    ** place a space after all but the last argument
	    */
	    lprintf(" ");
	}
    }
    if(cr){
	lprintf("\n");
    } else {
	fflush(stdout);
    }
#endif
}

void do_exit()
{
    if(Dynamic()){
	system("rm /tmp/tmp.dfl");
    }
    if(!IsBatchMode()){
	restore_tty();
    }
    exit(0);
}

