static char rcsid[] = "$Id: shell_func.c,v 1.1 1992/12/11 19:04:29 dhb Exp $";

/*
** $Log: shell_func.c,v $
** Revision 1.1  1992/12/11  19:04:29  dhb
** Initial revision
**
*/

#include "shell_ext.h"

#ifdef NLIST_BUG
struct  nlist {
    char    *n_name;		/* symbol name */
    unsigned long n_value;	/* symbol address */
};
#else
#include <nlist.h>
#endif

int	DEBUG_GetFuncAddress;

static int 		nfuncs = 0;
static FuncTable 	aux_func_table[1000];
static int		nauxfuncs = 0;
static FuncTable	func_table[1000];


Nlist(progname,nl)
char 	*progname;
struct nlist 	*nl;
{
char 	*target;
FILE		*nfp;
char		com[100];

    target = nl[0].n_name;
    printf("looking up '%s'\n",target);
    /*
    ** To get around a bug in the sun386i OS.
    ** Instead of using the nlist system call 
    ** run nm explicitly and grep for the target
    ** which is much slower but at least it works
    */
    sprintf(com,"nm %s | grep -w %s",progname,target);
/* mds3 changes */
/* cast to (FILE *) */
    nfp = (FILE *)popen(com,"r");
    if(fscanf(nfp,"%x",&(nl[0].n_value)) != 1){
	nl[0].n_value = 0;
    }
    pclose(nfp);
}

void ShowFuncNames()
{
int i;
int col = 0;
char	**namelist;
extern int Strcmp();

    if(nfuncs < 1) return;
    namelist = (char **)malloc(nfuncs*sizeof(char *));
    for(i=0;i<nfuncs;i++){
	namelist[i] = func_table[i].name;
    }
    qsort(namelist,nfuncs,sizeof(char *),Strcmp);
    printf("\nAvailable commands:");
    for(i=0;i<nfuncs;i++){
	if(col %80 == 0) {
	    printf("\n");
	}
	col += 20;
	printf("%-20s",namelist[i]);
    }
    printf("\n\n");
    free(namelist);
}

void AddFunc(name,adr,type)
char 	*name;
int	adr;
char	*type;
{
int	index;

    index = FuncIndex(name);
    func_table[index].name = CopyString(name);
    func_table[index].adr = (PFI)adr;
    func_table[index].type = CopyString(type);
    if(index == nfuncs)
	nfuncs++;
}

int FuncIndex(name)
char *name;
{
int		i;

    for(i=0;i<nfuncs;i++){
	if(strcmp(name,func_table[i].name) ==0){
	    return(i);
	}
    }
    return(nfuncs);
}

PutAuxFunc(name,adr)
char *name;
PFI adr;
{
int index;
    /*
    ** find the index of the function in the aux function table
    */
    index = AuxFuncIndex(name);
    /*
    ** put the new function in the table
    */
    aux_func_table[index].name = CopyString(name);
    aux_func_table[index].adr = adr;
    /*
    ** if it is a new function then increment the function count
    */
    if(index == nauxfuncs)
	    nauxfuncs++;
}

int AuxFuncIndex(name)
char *name;
{
int		i;

    for(i=0;i<nauxfuncs;i++){
	if(strcmp(name,aux_func_table[i].name) ==0){
	    return(i);
	}
    }
    return(nauxfuncs);
}

FuncTable GetCommand(name)
char *name;
{
int		i;
FuncTable	command;
char	*temp;
/* So commands can be executed on remote nodes - Upi Bhalla 1992 */
	for(temp=name;*temp;temp++) {
		if (*temp=='@') {
			name="rcommand";
			break;
		}
	}

    for(i=0;i<nfuncs;i++){
	if(strcmp(name,func_table[i].name) ==0){
	    return(func_table[i]);
	}
    }
    command.adr = NULL;
    return(command);
}

int IsCommand(name)
char *name;
{
int		i;

    for(i=0;i<nfuncs;i++){
	if(strcmp(name,func_table[i].name) ==0){
	    return(1);
	}
    }
    return(0);
}

GetInfo(name,info)
char *name;
Info *info;
{
Info *hash_info;
Info *InfoHashFind();

    if((hash_info = InfoHashFind(name))){
	    bcopy(hash_info,info,sizeof(Info));
	    return(1);
    }
    return(0);
}

/*
** GetFuncAddress takes a function name and returns the address associated
** with it
*/
int GetFuncAddress(name)
char *name;
{
struct nlist 	nl[2];
FuncTable 	*func;
FuncTable 	*FuncNameHashFind();
char 		target[100];
int		i;

    /*
    ** check the auxilliary function table
    */
    for(i=0;i<nauxfuncs;i++){
	if(strcmp(name,aux_func_table[i].name) == 0){
	    return((int)(aux_func_table[i].adr));
	}
    }
    if(func = FuncNameHashFind(name)){
	/*
	** see if it has already been defined
	*/
	return((int)(func->adr));
    } else{
	if(Debug(DEBUG_GetFuncAddress) > 0){
	    printf("looking up %s from nlist\n",name);
	}
	/*
	** try and find it using the nlist
	*/
#if defined(i386) || defined(mips)  || defined(IRIS)
	sprintf(target,"%s",name);
#else
	sprintf(target,"_%s",name);
#endif
	nl[0].n_name = target;
	nl[1].n_name = NULL;
#ifdef NLIST_BUG
	Nlist(progname,nl);
#else
	nlist(progname,nl);
#endif
	if(nl[0].n_value > 0){
	    /*
	    ** add it to the function list
	    */
	    HashFunc(name,nl[0].n_value,"void"); 
	    return(nl[0].n_value);
	} else
	    return(NULL);
    }
}


/*
** GetFuncType takes a function name and returns the type associated
** with its return value
*/
char *GetFuncType(name)
char *name;
{
struct nlist 	nl[2];
FuncTable 	*func;
FuncTable 	*FuncNameHashFind();
char 		target[100];
int		i;

    /*
    ** check the auxilliary function table
    */
    for(i=0;i<nauxfuncs;i++){
	if(strcmp(name,aux_func_table[i].name) == 0){
	    return(aux_func_table[i].type);
	}
    }
    if(func = FuncNameHashFind(name)){
	/*
	** see if it has already been defined
	*/
	return(func->type);
    } else{
	if(Debug(DEBUG_GetFuncAddress) > 0){
	    printf("looking up %s from nlist\n",name);
	}
	/*
	** try and find it using the nlist
	*/
#if defined(i386) || defined(mips) 
	sprintf(target,"%s",name);
#else
	sprintf(target,"_%s",name);
#endif
	nl[0].n_name = target;
	nl[1].n_name = NULL;
#ifdef NLIST_BUG
	Nlist(progname,nl);
#else
	/*
	** here is the call
	*/
	nlist(progname,nl);
#endif
	if(nl[0].n_value > 0){
	    /*
	    ** add it to the function list
	    */
	    HashFunc(name,nl[0].n_value,"void");
	    return("void");
	} else
	    return(NULL);
    }
}

/*
** GetFuncName takes an address and returns the symbol name associated
** with it
*/
char *GetFuncName(adr)
PFI adr;
{
int	i;
FuncTable *func;
FuncTable *FuncAdrHashFind();

    if(adr == NULL) return(NULL);
    /*
    ** check the auxilliary function table
    */
    for(i=0;i<nauxfuncs;i++){
	if(adr == aux_func_table[i].adr){
	    return(aux_func_table[i].name);
	}
    }
    if(func = FuncAdrHashFind(itoa(adr))){
	return(func->name);
    } else
	return("???");
}

void do_add_func(argc,argv)
int		argc;
char	**argv;
{
int	adr;
char 	*type;

    if(argc < 3){
	printf("usage: %s name func [type]\n",argv[0]);
	return;
    }
    if((adr = GetFuncAddress(argv[2])) != NULL){
	if(argc > 3){
	    type = argv[3];
	} else {
	    type = GetFuncType(argv[2]);
	}
	AddFunc(argv[1],adr,type);
    } else {
	printf("could not find function %s\n",argv[2]);
    }
}

void do_execute(argc,argv)
int argc;
char **argv;
{
PFI func;
char **func_argv;
int func_argc;

    if(argc < 2){
	printf("usage: %s func arg1 .. \n",argv[0]);
	return;
    }
    if((func = (PFI)GetFuncAddress(argv[1])) == NULL){
	printf("cant find function '%s'\n",argv[1]);
	return;
    }
    func_argv = argv + 1;
    func_argc = argc - 1;
    func(func_argc,func_argv);
}

