static char rcsid[] = "$Id: shell_exec.c,v 1.1 1992/12/11 19:04:28 dhb Exp $";

/*
** $Log: shell_exec.c,v $
** Revision 1.1  1992/12/11  19:04:28  dhb
** Initial revision
**
*/

#include "shell_ext.h"
#include "result.h"

#ifdef NEW
Result ExecuteCommand(argc,argv)
int 	argc;
char 	**argv;
{
FuncTable 	GetCommand();
FILE 		*SearchForScript();
PFI		func;
PFC		cfunc;
PFF		ffunc;
FILE		*pfile;
int 		code;
FILE		*fp;
FILE		*output;
/* FILE		tmpfile; */
short 		redirect_mode = 0;
int 		start;
int 		i;
char 		*mode;
Result		result;
int		ival;
FuncTable	command;
int		savefd;
int		stdoutfd = fileno(stdout);

    if(argc < 1){
	result.r_type = IntType();
	result.r.r_int = 0;
	return(result);
    }
    /*
    ** is this an simulator shell function?
    */
    command = GetCommand(argv[0]);
    if(func = command.adr){
	/*
	** check through the arg list for stdout
	** redirection
	*/
	for(i=0;i<argc;i++){
	    /*
	    ** check for stdout redirection
	    */
	    if(i+1 < argc && ((strcmp(argv[i],"|") == 0) ||
	   (strcmp(argv[i],">") == 0) ||
	   (strcmp(argv[i],">>") == 0))){
		start = i+1;
		if(strcmp(argv[i],"|") == 0){
		    /*
		    ** pipe
		    */
		    redirect_mode = 1;
		    mode = "w";
		}
		if(strcmp(argv[i],">") == 0){
		    /*
		    ** redirect stdout to a file
		    */
		    redirect_mode = 2;
		    mode = "w";
		}
		if(strcmp(argv[i],">>") == 0){
		    /*
		    ** append stdout to a file
		    */
		    redirect_mode = 2;
		    mode = "a";
		}
		break;
	    }
	}
	if(redirect_mode){
	    normal_tty();
	    /*
	    ** save the stdout FILE structure
	    */
#ifdef OLD
	    fflush(stdout);
	    bcopy(output,&tmpfile,sizeof(FILE));
#endif
	    switch(redirect_mode){
	    case 1:
		/*
		** open up the pipe
		** on DECs popen appears to use a fork rather than
		** a vfork to exec the command which can be
		** exceedingly inefficient
		*/
/* mds3 changes */
/* fp = popen(ArgListToString(argc-start,argv+start),mode); */
		fp = (FILE *)popen(ArgListToString(argc-start,argv+start),mode);
		break;
	    case 2:
		/*
		** open up the file
		*/
		fp = fopen(argv[start],mode);
		break;
	    }
#ifndef OLD
	    /*
	    ** flush the existing data in stdout
	    */
	    fflush(stdout);
	    savefd = dup(stdoutfd);
	    close(stdoutfd);
	    dup(fileno(fp));
#else
	    /*
	    ** redirect stdout by replacing the stdout 
	    ** FILE structure with the new fp
	    */
	    bcopy(fp,output,sizeof(FILE));
#endif
	    /*
	    ** call the function
	    */
	    func(start-1,argv);
	    /*
	    ** flush the output and close it
	    */
	    fflush(stdout);
#ifndef OLD
	    close(stdoutfd);
#endif
	    switch(redirect_mode){
	    case 1:
		pclose(fp);
		break;
	    case 2:
		fclose(fp);
		break;
	    }
	    /*
	    ** restore the stdout file structure
	    */
#ifndef OLD
	    dup(savefd);
	    close(savefd);
#else
	    bcopy(&tmpfile,output,sizeof(FILE));
#endif
	    genesis_tty();
	} else
	/*
	** call the function
	*/
	if(strcmp(command.type,"int") == 0){
	    result.r_type = IntType();
	    result.r.r_int = func(argc,argv);
	} else
	if(strcmp(command.type,"float") == 0){
	    ffunc = (PFF)func;
	    result.r_type = FloatType();
	    result.r.r_float = ffunc(argc,argv);
	} else
	if(strcmp(command.type,"char*") == 0){
	    cfunc = (PFC)func;
	    result.r_type = StrType();
	    result.r.r_str = cfunc(argc,argv);
	} else
	if(strcmp(command.type,"char**") == 0){
	    cfunc = (PFC)func;
	    result.r_type = ArgListType();
	    result.r.r_str = cfunc(argc,argv);
	} else {
	    func(argc,argv);
	    result.r_type = IntType();
	    result.r.r_int = 0;
	}
	return(result);
    } else 
    /*
    ** is it a simulator shell script?
    */
    if(ValidScript(pfile = SearchForScript(argv[0],"r"))){
	AddScript(pfile,argc,argv,FILE_TYPE);
    } else {
	/*
	** if the function is not locally defined then
	** check to see if system functions should be
	** tried
	*/
	if(Autoshell()){
	    normal_tty();
#ifdef OLD
	    if((code = system(ArgListToString(argc,argv))) != 0){
		Error();
		printf("code %d\n",code);
	    };
#endif
	    if((code = ExecFork(argc,argv)) != 0){
		Error();
		printf("code %d\n",code);
	    };
	    genesis_tty();
	    result.r_type = IntType();
	    result.r.r_int = code;
	    return(result);
	} else
	printf("undefined function \"%s\"\n",argv[0]);
    }
    result.r_type = IntType();
    result.r.r_int = 0;
    return(result);
}
#endif
