static char rcsid[] = "$Id: shell_error.c,v 1.1 1992/12/11 19:04:27 dhb Exp $";

/*
** $Log: shell_error.c,v $
** Revision 1.1  1992/12/11  19:04:27  dhb
** Initial revision
**
*/

/* Modified by Upi Bhalla Feb 1992 : Added parallel options to
** silent stuff */

static int warning_cnt = 0;
static int error_cnt = 0;
#ifdef i860
static int silent = 2;
#else
static int silent = 0;
#endif
static int max_warnings = 20;
static int max_errors = 10;

/* Upi Modification Feb 1992
** Level 0,1 : Same effects as before
** Level 2   : Silences the startup stuff, on all nodes.
** Level 3   : (for parallel machines) All but node 0 are silent
*/

SetSilent(x) 
int x; 
{
#ifdef i860
	if (x==3 && do_realmynode(0,0)==0)
		silent=0;
	else
    	silent = x; 
#else
   	silent = x; 
#endif
}


IsSilent() { return((silent==0) ? InControlStructure() : silent); }

int do_silent(argc,argv)
int	argc;
char	**argv;
{
    if(argc > 1){
	silent =atoi(argv[1]);
    }
    return(silent);
}


MaxWarnings(i)
int i;
{
    max_warnings = i;
}

MaxErrors(i)
int i;
{
    max_errors = i;
}

do_set_maxwarnings(argc,argv)
int argc;
char **argv;
{
    if(argc > 1){
	max_warnings = atoi(argv[1]);
    }
    if(!silent)
	printf("max warnings = %d\n",max_warnings);
}

do_set_maxerrors(argc,argv)
int argc;
char **argv;
{
    if(argc > 1){
	max_errors = atoi(argv[1]);
    }
    if(!silent)
	printf("max errors = %d\n",max_errors);
}

ResetErrors()
{
    warning_cnt = 0;
    error_cnt = 0;
}

Warning()
{
    if(!silent){
	TraceScript();
	printf("* Warning - ");
    }
    warning_cnt++;
    if(warning_cnt > max_warnings){
	printf("Exceeded the maximum number of warnings (%d)\n",
	max_warnings);
	warning_cnt = 0;
	restore_context();
    }
}

Error()
{
    TraceScript();
    printf("** Error - ");
    error_cnt++;
    if(error_cnt > max_errors){
	printf("Exceeded the maximum number of errors (%d)\n",
	max_errors);
	error_cnt = 0;
	restore_context();
    }
}

DisplayErrors()
{
    printf("\n");
    printf("%d Warnings\n",warning_cnt);
    printf("%d Errors\n",error_cnt);
    printf("\n");
}

yyerror(s)
char *s;
{
    Error();
    printf("%s\n",s);
    restore_context();
}
