static char rcsid[] = "$Id: shell_convert.c,v 1.1 1992/12/11 19:04:23 dhb Exp $";

/*
** $Log: shell_convert.c,v $
** Revision 1.1  1992/12/11  19:04:23  dhb
** Initial revision
**
*/

#include "shell_ext.h"

float Atof(s)
char *s;
{
float f;
    if(s != NULL && sscanf(s,"%f",&f) >0){
	return(f);
    } else
	return(0.0);
}

double Atod(s)
char *s;
{
double d;
    if(s != NULL && sscanf(s,"%lf",&d) >0){
	return(d);
    } else
	return(0.0);
}

#ifndef mips
char tolower(c) 
char	c;
{
	if((c >= 'A') && (c <= 'Z')) return((c) | 0x20);
	else return(c);
}
#endif

#ifndef i860
char *itoa(val)
int val;
{
char string[80];
char *val_str;

    sprintf(string,"%d",val);
    val_str = CopyString(string);
    return(val_str);
}
#endif

char *ftoa(val)
float val;
{
char string[80];
char *val_str;

    if(fabs(val) < 1e-5){
	sprintf(string,"%e",val);
    } else {
	sprintf(string,"%f",val);
    }
    val_str = (char *)malloc(strlen(string)+1);
    strcpy(val_str,string);
    return(val_str);
}


do_set_float_format(argc,argv)
	int argc;
	char **argv;
{
	char *format;
	char formtype;

	if (argc != 2) {
		printf("usage : %s format\n",argv[0]);
		printf("example : %s %%0.5g\n",argv[0]);
		return;
	}
	format = argv[1];
	formtype = argv[1][strlen(argv[1]) -1];

	if (format[0] != '%') {
		printf("usage : %s format\n",argv[0]);
		printf("example : %s %%0.5g\n",argv[0]);
		return;
	}
	if (formtype != 'f' && formtype != 'd' && formtype != 'g'){
		printf("usage : %s format\n",argv[0]);
		printf("example : %s %%0.5g\n",argv[0]);
		printf("only f, d and g formats are allowed\n");
		return;
	}
	set_float_format(format);
	sim_set_float_format(format);
}
