static char rcsid[] = "$Id: symcompart.c,v 1.1 1992/10/29 18:29:30 dhb Exp $";

/*
** $Log: symcompart.c,v $
 * Revision 1.1  1992/10/29  18:29:30  dhb
 * Initial revision
 *
*/

#include "seg_ext.h"

int	DEBUG_SymCompartment = 0;
static double	savedata[2];

#define	Field(F) (compartment->F)

/* 7/88 Matt Wilson */
/* 11/90 Erik De Schutter: 
** CONNECTSPHERE message (type 4): connects a cylinder to a
**	sphere, is symmetric (i.e. may be used for both directions).
**	Assumes that all the dendrites are distributed perfectly over
**	the soma/sphere.  Using CONNECTHEAD/CONNECTTAIL instead 
**	connects all denrites to one point on the soma/sphere.
** CONNECTCROSS message (type 5), this should be used to cross-
**	connect the first compartments after a	binary or multiple 
**	split, do not use CONNECTHEAD for this because it crashes 
**	the xcell drawing routine. */
/* Added EREST message, E De Schutter 5/91 */

SymCompartment(compartment,action)
register struct symcompartment_type *compartment;
Action		*action;
{
double		A;
double		B;
double		dt;
double		Vm1,Ra1;
double 		Ra_sum,Ra_sum2;
MsgIn		*msg;
MsgOut		*msgout;
short		failed;

    if(Debug(DEBUG_SymCompartment) > 1){
	ActionHeader("SymCompartment",compartment,action);
    }
    SELECT_ACTION(action){
    case INIT:
	compartment->previous_state = compartment->Vm;
	break;

    case PROCESS:
	dt = Clockrate(compartment);
	/* calculate the integration parameters */
	A = Field(Em)/Field(Rm) + Field(inject);
	B = 1.0/Field(Rm);
	compartment->Im = 0;
	/* Read the msgs. These are factors used in the integration
	** across the membrane capacitance
	**
	** A = SUM(Ek*Gk) + I
	** B = SUM(Gk)	 */
	MSGLOOP(compartment,msg){
	    case 0:			/* channel */
		/* 0 = Gk 	1 = Ek */
		A += MSGVALUE(msg,1)*MSGVALUE(msg,0);
		B += MSGVALUE(msg,0);
		break;

	    case 1:			/* resistive axial tail */
		/* 0 = Ra(n-1) 	1 = Vm(n-1) */
		Vm1 = MSGVALUE(msg,1);
		Ra1 = MSGVALUE(msg,0)*compartment->coeff;
		A += Vm1/Ra1;
		B += 1.0/Ra1;
		/* inward positive current convention */
		compartment->Im += (Vm1 - compartment->Vm)/Ra1;
		break;

	    case 2:			/* resistive axial head */
	    case 5:			/* resistive crossing axial head after split */
		/* 0 = Ra(n-1) 	1 = Vm(n-1) */
		Vm1 = MSGVALUE(msg,1);
		Ra1 = MSGVALUE(msg,0)*compartment->coeff2;
		A += Vm1/Ra1;
		B += 1.0/Ra1;
		/* inward positive current convention */
		compartment->Im += (Vm1 - compartment->Vm)/Ra1;
		break;

	    case 4:			/* resistive to/from sphere */
		/* 0 = Ra(n-1) 	1 = Vm(n-1) */
		Vm1 = MSGVALUE(msg,1);
		Ra1 = (compartment->Ra + MSGVALUE(msg,0)) * 0.5000;
		A += Vm1/Ra1;
		B += 1.0/Ra1;
		/* inward positive current convention */
		compartment->Im += (Vm1 - compartment->Vm)/Ra1;
		break;

	    case 3:			/* current injection */
		/* 0 = inject */
		compartment->Im += MSGVALUE(msg,0);
		A += MSGVALUE(msg,0);
		break;

		case 6:        /* change resting membrane potential */
		/* 0 = Em */
		compartment->Em = MSGVALUE(msg,0);
		break;

	}
	/* Integrate the component membrane currents
	** to get the net membrane potential */
	compartment->Vm =
	IntegrateMethod(compartment->object->method,compartment,
	compartment->Vm,A/Field(Cm),B/Field(Cm),dt,"Vm");
	break;

    case RESET:
	compartment->Vm = compartment->Em;
	Ra_sum = Ra_sum2 = 0;
	MSGLOOP(compartment,msg){
	case 1:			/* incoming tail axial resistance */
	    Ra1 = MSGVALUE(msg,0);
	    if(Ra1 <= 0.0){
		ErrorMessage("SymCompartment","Incoming Ra invalid.",
		compartment);
	    }
	    Ra_sum += compartment->Ra/Ra1;
	    break;

	case 2:			/* incoming head axial resistance */
	case 5:			/* incomming crossing head axial head resistance */
	    Ra1 = MSGVALUE(msg,0);
	    if(Ra1 <= 0.0){
		ErrorMessage("SymCompartment","Incoming Ra invalid.",
		compartment);
	    }
	    Ra_sum2 += compartment->Ra/Ra1;
	    break;
	}
	/* divide the axial resistance into 2 */
	compartment->coeff = (1 + Ra_sum)/2.0;
	compartment->coeff2 = (1 + Ra_sum2)/2.0;
	break;

    case CHECK:
	/* membrane leakage resistance */
	if(Field(Rm) <= 0.0)
	    ErrorMessage("SymCompartment", "Invalid Rm.", compartment);

	/* membrane capacitance */
	if(Field(Cm) <= 0.0)
	    ErrorMessage("SymCompartment", "Invalid Cm.", compartment);

	/* axial resistance */
	if(Field(Ra) <= 0.0)
	    ErrorMessage("SymCompartment", "Invalid Ra.", compartment);
	
	/* check messages:
	**  all incoming messages are checked for legal Ra values
	**	2 rules are enforced at the tail of the compartment:
	**		- for every incoming message, there should be an outgoing
	**		- if more than one compartment is connected to the
	**		  tail, they should be crossconnected. */
	MSGLOOP(compartment,msg){
	    case 1:			/* incoming tail axial resistance */
	    case 2:			/* incoming head axial resistance */
	    case 4:			/* incoming sphere axial resistance */
	    case 5:			/* incoming cross axial resistance */
		if(MSGVALUE(msg,0) <= 0.0)
		    ErrorMessage("Compartment","Incoming Ra invalid.", compartment);
		if(Field(Ra) <= 0.0)
	   		ErrorMessage("Compartment", "Invalid Ra.", compartment);
		break;
	}


	for (msgout = compartment->msg_out; msgout; msgout = msgout->next) {
		if (strcmp(msgout->dst->object->type,"symcompartment_type")!=0)
			continue;
		switch (msgout->msg_in->type) {
	    	case 2:			/* outgoing head axial resistance */
				/* find corresponding incoming message */
				failed = 1;
				for (msg=compartment->msg_in; msg; msg=msg->next) {	
					if ((msg->type == 1) && (msg->src == msgout->dst)) {
						failed = 0;
						break;
					}
				}
				if (failed)
	    			ErrorMessage("SymCompartment", 
						"Missing CONNECTTAIL IN msg.", compartment);
				break;
			
	    	case 4:			/* outgoing sphere axial resistance */
				/* find corresponding incoming message */
				failed = 1;
				for (msg=compartment->msg_in; msg; msg=msg->next) {	
					if ((msg->type == 4) && (msg->src == msgout->dst)) {
						failed = 0;
						break;
					}
				}
				if (failed)
	    			ErrorMessage("SymCompartment", 
						"Missing CONNECTSPHERE IN msg.", compartment);
				break;
	    	
			case 5:			/* outgoing cross axial resistance */
				/* find corresponding incoming message */
				failed = 1;
				for (msg=compartment->msg_in; msg; msg=msg->next) {	
					if ((msg->type == 5) && (msg->src == msgout->dst)) {
						failed = 0;
						break;
					}
				}
				if (failed)
	    			ErrorMessage("SymCompartment", 
						"Missing CONNECTCROSS IN msg.", compartment);
				break;
		}
	}
	break;	/* case CHECK */

    case SAVE2:
	savedata[0] = compartment->Vm;
	savedata[1] = compartment->previous_state;
	/* action->data contains the file pointer */
	fwrite(savedata,sizeof(double),2,action->data);
	break;

    case RESTORE2:
	/* action->data contains the file pointer */
	fread(savedata,sizeof(double),2,action->data);
	compartment->Vm = savedata[0];
	compartment->previous_state = savedata[1];
	break;
	}		/* SELECT_ACTION(action) */
}

#undef Field

