//genesis
//
// $Id: seglib.g,v 1.1.1.1 1993/07/22 19:53:56 dhb Exp $
// $Log: seglib.g,v $
// Revision 1.1.1.1  1993/07/22  19:53:56  dhb
// Added fixes for channelC3 object (ACTIVATION message).
//
// Revision 1.1  1992/12/11  19:04:19  dhb
// Initial revision
//

// genesis

newclass concentration

/*
************************************************************************
**                       SEGMENT SHELL COMMANDS                     **
************************************************************************
*/
addfunc		balanceEm		do_balance_Em

/*
*************************************************************************
**                              OBJECT TABLE                           **
*************************************************************************
*/
//==========================================================================
//	name		data            function	class	
//==========================================================================

object	channelA	channelA_type	ChannelA      	segment channel	\
	-author 	"M.Wilson Caltech 6/88" \
	-actions 	INIT PROCESS RESET CHECK \
	-messages 	VOLTAGE 0 	1 Vm \		/* type 0: Vm */
			ACTIVATION 1	1 activation \	/* type 1: activation */
	-fields		"Ek = equilibrium potential" \
	-description	"Direct mapping of activation to conductance." \
			"Calculates Ik = (Ek - Vk)Gk."

object	channelB	channelB_type 	ChannelB      	segment channel \
	-author 	"M.Wilson Caltech 6/88" \
	-actions 	INIT PROCESS RESET CHECK \
	-messages 	VOLTAGE 0 	1 Vm \	
			ACTIVATION 1 	1 activation \
	-fields		tau_ak gain_ak tau_gk gain_gk  \
			"Ek = equilibrium potential"

object	channelC	channelC_type 	ChannelC      	segment channel \
	-author 	"M.Wilson Caltech 6/88" \
	-actions 	INIT PROCESS RESET CHECK RECALC SAVE2 RESTORE2 \
	-messages	ACTIVATION 	0	1 activation \
			RAND_ACTIVATION 1 	2 probability amplitude \
	-fields		"tau1 tau2  = time constants of channel activation" \
			"gmax = peak conductance" 

object	channelC2	channelC2_type 	ChannelC2      	segment channel \
	-author 	"M.Wilson Caltech 6/88" \
	-actions 	INIT PROCESS RESET CHECK RECALC SAVE2 RESTORE2 \
	-messages 	VOLTAGE 	0 	1 Vm \	
			ACTIVATION 	1 	1 activation \
			RAND_ACTIVATION 2 	2 probability amplitude \
	-fields		"tau1 tau2  = time constants of channel activation" \
			"gmax = peak conductance" \
			"Ik = channel current"

object	channelC3	channelC3_type 	ChannelC3      	segment channel \
	-author 	"E. De Schutter 11/91, M.Wilson Caltech 6/88" \
	-actions 	INIT PROCESS RESET CHECK RECALC SAVE2 RESTORE2 \
	-messages 	VOLTAGE 	0 	1 Vm \	
			ACTIVATION      1       1 activation \
	-fields		"tau1 tau2  = time constants of channel activation" \
			"gmax = peak conductance" \
			"Ik = channel current" \
			"frequency = frequency of background firing"

object	manuelconduct	manuelconduct_type ManuelConduct  segment channel \
	-author 	"M.Wilson Caltech 2/89" \
	-actions 	INIT PROCESS RESET CHECK \
	-messages	VOLTAGE 	0	1 Vm \
			ACTIVATION 	1	1 activation \
			RAND_ACTIVATION 2 	2 probability amplitude \
	-fields		"tau_g = opening time" \
			"tau_h = closing time" \
			"tau_d = transmitter decay time" \
			"K_r  = dissociation constant for transmitter binding" \
			"gmax = channel conductance per unit of transmitter"

/* Change by Upi : concen needs to be updated late in the schedule table
** otherwise it will be seeing old values for current */
object	Ca_concen	Ca_concen_type CaConcen  segment concentration \
	-author 	"M.Wilson Caltech 2/89" \
	-actions 	INIT PROCESS RESET CHECK SAVE2 RESTORE2 \
	-messages	I_Ca 0		1 I_Ca \
			fI_Ca 1		2 I_Ca fraction \
			INCREASE 2	1 I_Ca \  //any sign of Ik 
			DECREASE 3	1 I_Ca \  //any sign of Ik
			BASE 4		1 Ca_base \
	-fields		"tau: time constant of decay" \
				"Ca_base: equilibrium concentration" \
				"B: equals 1/(ion_charge * Faraday * volume)" \
	-description	"Single pool model for Ca concentration.  read_cell" \
					"scales by volume of compartment."

object	Ca_shell	Ca_shell_type CaConcen  segment channel concentration \
	-author 	"M.Wilson Caltech 2/89, adaptation by E De Schutter 9/91" \
	-actions 	INIT PROCESS RESET CHECK SAVE2 RESTORE2 \
	-messages	I_Ca 0		1 I_Ca \
			fI_Ca 1		2 I_Ca fraction \
			INCREASE 2	1 I_Ca \  //any sign of Ik 
			DECREASE 3	1 I_Ca \  //any sign of IK
			BASE 4		1 Ca_base \
	-fields		"tau: time constant of decay" \
				"Ca_base: equilibrium concentration" \
				"B: equals 1/(ion_charge * Faraday * volume)" \
				"dia: diameter of shell" \
	-description	"Single shell model for Ca concentration.  read_cell" \
					"scales it as a true shell."

object	Mg_block	Mg_block_type	MgBlock segment channel	\
	-author 	"E. De Schutter Caltech 11/90" \
	-actions 	INIT PROCESS RESET CHECK \
	-messages 	VOLTAGE		0 	1 Vm \		/* type 0: Vm */
				CHANNEL1	1	1 Gk \		/* type 1: unblocked G*/
				CHANNEL2	2	2 Gk Ek \		/* type 1: unblocked G*/
				CHANNEL		2	2 Gk Ek \		/* type 1: unblocked G*/
				CHARGE		3	1 Zk \		/* update "charge value" */
	-fields		"Ik, Gk and Ek are the blocked values fo current k" \
				"Zk "charge", may also be used as {charge / relative" \
				" fraction of I}, e.g. 2/(Ica/Itot) -> msg to difpool" \
				"KMg_A = A-factor K(v)-equat for Mg block reaction" \
				"KMg_B = B-factor K(v)-equat for Mg block reaction" \
				"CMg = [Mg] in mM" \
	-description	"Implementation of voltage and [Mg]-dependent" \
					"blocking of a channel."

object	leakage		leakage_type 	Leakage  	segment channel \
	-author 	"M.Wilson Caltech 6/88" \
	-actions 	INIT PROCESS RESET CHECK \
	-messages 	VOLTAGE 0 	1 Vm \
	-fields		Ek Gk

object	compartment	compartment_type Compartment  	segment membrane \
	-author 	"M.Wilson Caltech 6/88" \
	-actions 	INIT PROCESS RESET CHECK SAVE2 RESTORE2 \
	-messages 	CHANNEL 0 	2 Gk Ek \
			RAXIAL	1	2 Ra Vm \
			AXIAL	2	1 Vm \
			INJECT	3	1 inject \
			EREST   6	1 Em \
	-fields		"Rm = membrane resistance" \
			"Cm = membrane capacitance" \
			"Em = resting potential" \
			"Ra = axial resistance" \
			"inject = injected current" \
			"dia = compartment diameter (not directly used numerically)" \
	-description 	"Axially asymmetric compartment. Ra is located on" \
			"one side of the compartment. This is slightly more" \
			"computationally efficient than the symmetric" \
			"counterpart."

object	symcompartment	symcompartment_type SymCompartment  segment membrane \
	-author 	"M.Wilson Caltech 5/89, E.De Schutter 11/90" \
	-actions 	INIT PROCESS RESET CHECK SAVE2 RESTORE2\
	-messages 	CHANNEL 0 	2 Gk Ek \
			RAXIAL	1	2 Ra Vm \
			RAXIAL2	2	2 Ra Vm \
			AXIAL	2	2 Ra Vm \
			CONNECTTAIL	1	2 Ra Vm \
			CONNECTHEAD	2	2 Ra Vm \
			INJECT	3	1 inject \
			RAXIALS	4	2 Ra Vm \
			CONNECTSPHERE	4	2 Ra Vm \
			RAXIALC	5	2 Ra Vm \
			CONNECTCROSS	5	2 Ra Vm \
			EREST   6	1 Em \
	-fields		"Rm = membrane resistance" \
			"Cm = membrane capacitance" \
			"Em = resting potential" \
			"Ra = total axial resistance" \
			"inject = injected current" \
			"dia = compartment diameter (not directly used numerically)" \
	-description 	"Axially symmetric compartment. Ra is divided into" \
			"two equal components across the compartment."

object	unit		unit_type 	Unit 		segment 	\
	-author 	"M.Wilson Caltech 6/88" \
	-actions	INIT RESET PROCESS CHECK \
	-messages 	INJECT 	0 	1 inject \
	-fields		Em inject

object	RC		RCunit_type 	RC_Unit		segment 	\	
	-author 	"M.Wilson Caltech 6/88" \
	-actions	RESET PROCESS CHECK \
	-messages 	INJECT 	0 	1 inject \
	-fields		V0 R C state inject method

object	site		site_type 	Site 		segment 	\
	-author 	"M.Wilson Caltech 6/88" \
	-actions	INIT RESET PROCESS \
	-messages       ACTIVATION      1       1 activation

