/*
** $Id: seg_struct.h,v 1.1 1992/12/11 19:04:17 dhb Exp $
** $Log: seg_struct.h,v $
** Revision 1.1  1992/12/11  19:04:17  dhb
** Initial revision
**
*/

#include "struct_defs.h"

/*
*******************************
**         SEGMENT           **
*******************************
*/

struct unit_type {
    SEGMENT_TYPE
    double	state;
    float	Rm;
    float	Cm;
    float	Em;
    float	inject;
};

struct RCunit_type {
    SEGMENT_TYPE
    double	state;
    float	R;
    float	C;
    float	V0;
    float	inject;
};

struct site_type {
    SEGMENT_TYPE
    double	Ik;
};

struct leakage_type {
    CHAN_TYPE
	/*
    double	Ik;
    double	Gk;
    float	Ek;
	*/
    float 	inject;
};

struct channelA_type {
    CHAN_TYPE
	/*
    double	Ik;
    double	Gk;
    float	Ek;
	*/
};

struct channelB_type {
    CHAN_TYPE
	/*
    double	Ik;
    double	Gk;
    float	Ek;
	*/
    double	Ak;
    double	Yk;
    float	tau_ak;
    float	tau_gk;
    float	gain_ak;
    float	gain_gk;
};

struct conductanceA_type {
    CHAN_TYPE
	/*
    double	Ik;
    double	Gk;
    float	Ek;
	*/
    double	Ak;
    double	Yk;
    float	tau1;
    float	tau2;
    float	gmax;
};

struct channelC_type {
    SEGMENT_TYPE
    double	Gk;
    float	Ek;
    double	X;
    double	Y;
    float	tau1;
    float	tau2;
    float	gmax;
    double	xconst1;
    double	xconst2;
    double	yconst1;
    double	yconst2;
    float	norm;
};

struct channelC2_type {
    CHAN_TYPE
	/*
    double	Ik;
    double	Gk;
    float	Ek;
	*/
    double	X;
    double	Y;
    float	tau1;
    float	tau2;
    float	gmax;
    double	xconst1;
    double	xconst2;
    double	yconst1;
    double	yconst2;
    float	norm;
};

struct channelC3_type {
    CHAN_TYPE
	/*
    double	Ik;
    double	Gk;
    float	Ek;
	*/
    double	X;
    double	Y;
    float	tau1;
    float	tau2;
    float	gmax;
    double	xconst1;
    double	xconst2;
    double	yconst1;
    double	yconst2;
    float	norm;
	float	frequency;
};

struct manuelconduct_type {
    CHAN_TYPE
	/*
    double	Ik;
    double	Gk;
    float	Ek;
	*/
    double	H;
    double	Z;
    float	tau_g;
    float	tau_h;
    float	tau_d;
    float	gmax;
    float	K_r;
};

#define CA_CONCEN_TYPE \
    SEGMENT_TYPE \
    double	Ca; \
    double	C; \
    double	Ca_base; \
    float	tau; \
    float	B;

struct Ca_concen_type {
    CA_CONCEN_TYPE
};

struct Ca_shell_type {
    CA_CONCEN_TYPE
	float	dia;
};

struct Mg_block_type {
	CHAN_TYPE
	/*
    double	Ik;
    double	Gk;
    float	Ek;
	*/
	double  Zk;
	float	KMg_A;
	float	KMg_B;
	float	CMg;
};

struct membrane_type {
    float	Cm;
    float	Rm;
    float	Em;
    float	pot;
    float	inject;
    short	spikes;
};

#define COMPARTMENT_TYPE \
    SEGMENT_TYPE \
    double	Vm; \
    double	previous_state; \
    float	Im; \
    float	Em; \
    float	Rm; \
    float	Cm; \
    float	Ra; \
    float	inject; \
	float	dia;

struct compartment_type {
	COMPARTMENT_TYPE
};

struct symcompartment_type {
	COMPARTMENT_TYPE
    float	coeff;
    float	coeff2;
};

