static char rcsid[] = "$Id: balance.c,v 1.1 1992/12/11 19:03:58 dhb Exp $";

/*
** $Log: balance.c,v $
** Revision 1.1  1992/12/11  19:03:58  dhb
** Initial revision
**
*/

#include "seg_ext.h"

/* M.Wilson Caltech 4/89 */
do_balance_Em(argc,argv)
int argc;
char **argv;
{
ElementList *list;
struct compartment_type *compartment;
float	A;
float	B;
MsgIn	*msg;
float	voltage;
int 	i;

    if(argc < 3){
	printf("usage: %s path voltage\n",argv[0]);
	return(0);
    }
    list = WildcardGetElement(argv[1],1);
    voltage = Atof(argv[2]);
    for(i=0;i<list->nelements;i++){
	compartment = (struct compartment_type *)list->element[i];
	if(strcmp(compartment->object->type,"compartment_type") != 0){
	    /*
	    ** its not a compartment so skip it
	    */
	    continue;
	}
	/*
	** Adjust Em to give no net membrane current at given voltage
	**
	** A = SUM(Ek*Gk)
	** B = SUM(Gk)
	*/
	A = B = 0;
	MSGLOOP(compartment,msg){
	case 0:			/* channel */
	    /*
	    ** 0 = Gk ; 1 = Ek
	    */
	    A += MSGVALUE(msg,1)*MSGVALUE(msg,0);
	    B += MSGVALUE(msg,0);
	    break;
	}
	compartment->Em = (1+B*compartment->Rm)*voltage - A*compartment->Rm;
    }
    FreeElementList(list);
}

