//genesis
//
// $Id: graphs.g,v 1.1 1992/12/11 19:12:27 dhb Exp $
// $Log: graphs.g,v $
// Revision 1.1  1992/12/11  19:12:27  dhb
// Initial revision
//

//genesis
//*************************************************************************
//Adam Franklin Strassberg
//March 15, 1992
//
//Graphing Functions and Graph Objects
//*************************************************************************


//*************************************************************************
//Graphing Functions - allow the user to change the scaling of the graph

//Sets the scale window to the scale values of the given graph
function set_scale(gpath)
    str gpath
    float xmin, xmax, ymin, ymax, overlay
    xmin = get({gpath},xmin)
    xmax = get({gpath},xmax)
    ymin = get({gpath},ymin)
    ymax = get({gpath},ymax)
    overlay = get({gpath},overlay)

    ce /forms/gscale
    set -env /forms/gscale gpath {gpath}
    set xmin value {xmin}
    set xmax value {xmax}
    set ymin value {ymin}
    set ymax value {ymax}
    set overlay value {overlay}
    xshow .
end

//Sets the given field of a given graph to the value in the scale window
function gset(field, dialog)
    str path
    float val
    path = get(-env,/forms/gscale,gpath)
    val = get({dialog}, value)
    echo Setting {path} {field} {val}
    set {path} {field} {val}
end
//*************************************************************************


//*************************************************************************
//Create Graph Objects

//Initialize Graphics Clock
setclock 1 0.1

//Object to hold all four graphs
create xform /graphs [50,10,1000,550] -title "Patch of Membrane" 
str gpath

//Membrane Potential Graph
gpath = "/graphs/Vm"
create xgraph {gpath} [10, 50, 49%, 49%]  -widgets \
	[NULL, NULL, NULL.right, NULL.bottom] \
	-title "membrane potential" 
create xbutton {gpath}"scale" [10, 50, 50, 15]  -widgets \
	[NULL, NULL, NULL, NULL] \
	-title "scale" -script "set_scale "{gpath}
set {gpath} XUnits "t (msec)" YUnits "voltage (mV)"
set {gpath} xmax 100 ymin -20 ymax 120
useclock {gpath} 1

//Injection Current Graph
gpath = "/graphs/inj"
create xgraph {gpath} [0, 10, 49%, 10]  -widgets \
	[Vm.left, Vm.bottom, NULL.right, NULL.bottom] \
	-title "injection current" 
create xbutton {gpath}"scale" [0, 10, 50, 15]  -widgets \
	[Vm.left, Vm.bottom, NULL, NULL] \
	-title "scale" -script "set_scale "{gpath}
set {gpath} XUnits "t (msec)" YUnits "current (pA)"
set {gpath} xmax 100 ymin -0.5 ymax 0.5 
useclock {gpath} 1
    
//Channel Conductance Graph
gpath = "/graphs/Gk"
create xgraph {gpath} [10, 50, 10, 49%] -widgets \
	[Vm.right, NULL, NULL.right, NULL.bottom] \
	-title "channel conductance" 
create xbutton {gpath}"scale" [10, 50, 50, 15] -widgets \
	[Vm.right, NULL, NULL, NULL] \
	-title "scale" -script "set_scale "{gpath}
set {gpath} XUnits "t (msec)" YUnits "conductance (pS)"
set {gpath} xmax 100 ymin 0.0 ymax 500.0 
useclock {gpath} 1

//Channel Currents Graph
gpath = "/graphs/Ik"
create xgraph {gpath} [0, 10, 10, 10] -widgets \ 
	[Gk.left, Gk.bottom, NULL.right, NULL.bottom] \
	-title "channel current" 
create xbutton {gpath}"scale" [0, 10, 50, 15] -widgets \ 
	[Gk.left, Gk.bottom, NULL, NULL] \
	-title "scale" -script "set_scale "{gpath}
set {gpath} XUnits "t (msec)" YUnits "current (pA)"
set {gpath} xmax 100 ymin -10000.0 ymax 10000.0 
useclock {gpath} 1

xshow /graphs
//*************************************************************************


//*************************************************************************
//Create Scale Object

create xform /forms/gscale [300,100,220,220] \
	-title "Graph Scale"
ce /forms/gscale
create xdialog xmin [10,  45, 200, 25] -value "???" \
	-script "gset xmin "<widget>
create xdialog xmax [10,  80, 200, 25] -value "???" \
	-script "gset xmax "<widget>
create xdialog ymin [10, 115, 200, 25] -value "???" \
	-script "gset ymin "<widget>
create xdialog ymax [10, 150, 200, 25] -value "???" \
	-script "gset ymax "<widget>
create xdialog overlay [10,185, 200, 25] -value "???" \
	-script "gset overlay "<widget>
create xbutton DONE [10, 10, 50, 15] \
	-script "xhide /forms/gscale"
 set -env /forms/gscale gpath "???"
//*************************************************************************
