//genesis
//
// $Id: ConVclamp.g,v 1.1 1992/12/11 19:12:25 dhb Exp $
// $Log: ConVclamp.g,v $
// Revision 1.1  1992/12/11  19:12:25  dhb
// Initial revision
//

//genesis
//*************************************************************************
//Adam Franklin Strassberg
//March 15, 1992
//*************************************************************************


//*************************************************************************
//Voltage Clamp simulation of a Patch of Membrane
//using standard Hodgkin-Huxleycontinuous dynamics
//
//time		msec
//area		um^2
//voltage	mV
//conductance	pS
//
//(Basic simulation runs for 20ms in 0.01ms steps)
//*************************************************************************


//*************************************************************************
//Reset Function - intializes the simulation 
function reset_sim

float area
float numNa
float numK
float KGmax
float NaGmax

area = get(/data/Area, value)
numK = get(/data/Kdense, value)*area
numNa = get(/data/Nadense, value)*area
KGmax = get(/data/KGopen, value)
NaGmax = get(/data/NaGopen, value)

//Initialize the kinetic channels 
set /K gbar {KGmax*numK} 
set /Na gbar {NaGmax*numNa} 

//Initialize Gk's to Vrest=0mV values of 0
set /K Gk 0 
set /Na Gk 0 

//Initialize the voltage pulse generator
set /pulse x  {get(/data/Vmi, value)}

//Reset the simulation system
reset

end
//*************************************************************************


//*************************************************************************
//Run Function - runs the simulation 

function run_sim

//Initialize the Simulation
reset_sim

//Run the Simulation
step 500
set /pulse x  {get(/data/Vmf, value)}
step 1500 

end
//*************************************************************************


//*************************************************************************
//Dummy Function - needed to satisfy certain script fields 
function void
end
//*************************************************************************


//*************************************************************************
//Graphing Functions - allow the user to change the scaling of the graph

function set_scale(gpath)
    str gpath
    float xmin, xmax, ymin, ymax, overlay
    xmin = get({gpath},xmin)
    xmax = get({gpath},xmax)
    ymin = get({gpath},ymin)
    ymax = get({gpath},ymax)
    overlay = get({gpath},overlay)

    set /gscale/xmin value {xmin}
    set /gscale/xmax value {xmax}
    set /gscale/ymin value {ymin}
    set /gscale/ymax value {ymax}
    set /gscale/overlay value {overlay}
    xshow /gscale 
end

function set_graph(field)
    str field
    str path
    path = "/gscale/" + {field}	
    set /data/outgraph {field} {get({path},value)}
end
//*************************************************************************


//*************************************************************************
//Create Simulation Objects

setclock 0 0.01

create	vdep_channel	/Na

create	vdep_gate 	/Na/m
	set		^		alpha_A		  2.5	\
		            		alpha_B		 -0.1	\
					alpha_C		 -1.0	\
					alpha_D		-25.0	\
					alpha_F		-10.0	\
		            		beta_A		  4.0	\
		            		beta_B		  0.0	\
					beta_C		  0.0	\
					beta_D		  0.0	\
					beta_F		 18.0	\
					instantaneous	0

create	vdep_gate	/Na/h
	set		^		alpha_A		  0.07	\
		            		alpha_B		  0.0	\
					alpha_C		  0.0	\
					alpha_D		  0.0	\
					alpha_F		 20.0	\
		            		beta_A		  1.0	\
            				beta_B		  0.0	\
					beta_C		  1.0	\
					beta_D		-30.0	\
					beta_F		-10.0	\
					instantaneous	0

sendmsg /Na/m	/Na			MULTGATE	m 3
sendmsg /Na/h	/Na			MULTGATE	m 1



create	vdep_channel	/K

create	vdep_gate 	/K/n
	set		^		alpha_A		  0.1	\
		            		alpha_B		 -0.01	\
					alpha_C		 -1.0	\
					alpha_D		-10.0	\
					alpha_F		-10.0	\
		            		beta_A		  0.125	\
		            		beta_B		  0.0	\
					beta_C		  0.0	\
					beta_D		  0.0	\
					beta_F		 80.0	\
					instantaneous	0

sendmsg /K/n 	/K			MULTGATE	m 4

//Voltage Pulse Generator
create neutral /pulse
//*************************************************************************


//*************************************************************************
//Create Display Object for Simulation Interface 
create xform   /data -title "K+ and Na+ (N) Channels" [0,0,400,570]
create xdialog /data/Vmf -script void -value 50.0 -title "Vmf(mV)"
create xdialog /data/Vmi -script void -value 0.0 -title "Vmi(mV)"
create xdialog /data/Area -script void -value 1.0 -title "Area(um2)"
create xdialog /data/KGopen -script void -value 20.0 -title "KGopen(pS)"
create xdialog /data/Kdense -script void -value 18.0 -title "Density of K Channels(/um2)"
create xdialog /data/NaGopen -script void -value 20.0 -title "NaGopen(pS)"
create xdialog /data/Nadense -script void -value 60.0 -title "Density of Na Channels(/um2)"
create xgraph  /data/outgraph -title "Conductance Gk(t)"
set /data/outgraph xmin 0 xmax 20 ymin 0 ymax 1000
set /data/outgraph XUnits ms YUnits pS 
create xbutton /data/outgraph/scale [0, 10, 50, 15]  -widgets \
	[outgraph.left, outgraph.bottom , NULL, NULL] \
	-title "scale" -script "set_scale /data/outgraph" 
create xbutton /data/RESET -script reset_sim 
create xbutton /data/RUN -script run_sim 
create xbutton /data/STOP -script stop 
create xbutton /data/QUIT -script quit 
//*************************************************************************


//*************************************************************************
//Create Display for Graph Scaling
create xform /gscale [300,100,220,220] -title "Graph Scale"
create xdialog /gscale/xmin [10,45,200,25] \
	 -value "???" \
	 -script "set_graph xmin"
create xdialog /gscale/xmax [10,80,200,25] \
	 -value "???" \
	 -script "set_graph xmax"
create xdialog /gscale/ymin [10,115,200,25]  \
	 -value "???" \
	 -script "set_graph ymin"
create xdialog /gscale/ymax [10,150,200,25] \
	 -value "???" \
	 -script "set_graph ymax"
create xdialog /gscale/overlay [10,185,200,25] \
	 -value "???" \
	 -script "set_graph overlay"
create xbutton /gscale/DONE [10,10,50,15] -script "xhide /gscale"
//*************************************************************************


//*************************************************************************
//Link Interface Elements
sendmsg /pulse /K/n VOLTAGE x
sendmsg /pulse /Na/m VOLTAGE x
sendmsg /pulse /Na/h VOLTAGE x
sendmsg /K  /data/outgraph PLOT  Gk *GK    *red 
sendmsg /Na  /data/outgraph PLOT Gk *GNa   *blue 

setclock 1 0.1
create asc_file /Kout
useclock /Kout 1
set /Kout filename Kout
sendmsg /K /Kout SAVE Gk

create asc_file /Naout
useclock /Naout 1
set /Naout filename Naout
sendmsg /Na /Naout SAVE Gk
//*************************************************************************


//*************************************************************************
//Dump Simulation Interface Window to the Screen
xshow /data
//*************************************************************************
