static char rcsid[] = "$Id: randfield.c,v 1.1 1992/12/11 19:03:40 dhb Exp $";

/*
** $Log: randfield.c,v $
** Revision 1.1  1992/12/11  19:03:40  dhb
** Initial revision
**
*/

#include "per_ext.h"

/* 1/89 Matt Wilson */
void do_random_field(argc,argv)
int 	argc;
char 	**argv;
{
char 		val[80];
float 		lower;
float 		upper;
float 		mean;
float 		sd;
float 		var;
char 		*field;
char		*path;
ElementList	*list;
int		i;
int		mode;

    if(argc < 6){
	printf("usage: %s path field [-uniform low high][-gaussian mean sd][-exp low high]\n",
	argv[0]);
	return;
    }
    path = argv[1];
    field = argv[2];
    /*
    ** check the distribution options
    */
    if(strcmp(argv[3],"-uniform") == 0){
	mode = 0;
	lower = Atof(argv[4]);
	upper = Atof(argv[5]);
    } else
    if(strcmp(argv[3],"-gaussian") == 0){
	mode = 1;
	mean = Atof(argv[4]);
	sd = Atof(argv[5]);
	var = sd*sd;
    } else 
    if(strcmp(argv[3],"-exp") == 0){
	mode = 2;
	lower = Atof(argv[4]);
	upper = Atof(argv[5]);
    } else {
	Error();
	printf("%s : invalid option '%s'\n",argv[0],argv[3]);
	return;
    }
    /*
    ** make the element list
    */
    if((list = WildcardGetElement(path,1)) == NULL){
	InvalidPath(argv[0],path);
	return;
    }
    /*
    ** set the fields
    */
    switch(mode){
    case 0:			/* uniform */
	for(i=0;i<list->nelements;i++){
	    sprintf(val,"%e",frandom(lower,upper));
	    SetElement(list->element[i],field,val);
	}
	break;
    case 1:			/* gaussian */
	for(i=0;i<list->nelements;i++){
	    sprintf(val,"%e",rangauss(mean,var));
	    SetElement(list->element[i],field,val);
	}
	break;
    case 2:			/* exponential */
	for(i=0;i<list->nelements;i++){
	    sprintf(val,"%e",-log(frandom(lower,upper)));
	    SetElement(list->element[i],field,val);
	}
	break;
    }
    FreeElementList(list);
    OK();
}

