static char rcsid[] = "$Id: out_file.c,v 1.1 1992/10/29 17:52:11 dhb Exp $";

/*
** $Log: out_file.c,v $
 * Revision 1.1  1992/10/29  17:52:11  dhb
 * Initial revision
 *
*/

#include "out_ext.h"

/*
** try to open the file associated with the output
** return the state of the file
*/
OpenOutputFile(output,mode)
struct file_type *output;
char	*mode;
{
char *filename;

    if(output->filename){
	filename = output->filename;
    } else {
	filename = output->name;
    }
    if(!output->is_open && (output->fp = fopen(filename,mode)) == NULL){
	Error();
	printf ("unable to open file %s with mode %s\n", 
	filename,mode);
	output->is_open = FALSE;
	return(0);
    } else {
	output->is_open = TRUE;
    }
    return(output->is_open);
}

ConditionalCloseOutputFile(output)
struct file_type *output;
{
    if(output->is_open && !output->leave_open){
	fclose(output->fp);
	output->fp = NULL;
	output->is_open = FALSE;
    }
}

CloseOutputFile(output)
struct file_type *output;
{
    if(output->is_open){
	fclose(output->fp);
	output->fp = NULL;
	output->is_open = FALSE;
    }
}

SetupFile(output)
struct file_type *output;
{
char	label[100];
float	fval;
int	i;
int 	ndata;
int 	datatype;
MsgIn	*msg;
float	coord;

    /*
    ** try to close up the file if it has been left open
    */
    CloseOutputFile(output);
    /*
    ** try to open the file
    */
    if(OpenOutputFile(output,"w")){
	/*
	** go to the beginning of the file
	*/
	fseek(output->fp, 0L, 0);
	/*
	** count the data points
	*/
	ndata = 0;
	for(msg=output->msg_in;msg;msg=msg->next){
	    switch(msg->type){
	    /*
	    ** SAVE 
	    */
	    case 0:
		ndata++;
		break;
	    }
	}
	/*
	** write out the file header
	*/
	strcpy(label,"FMT1");
	fwrite (label, sizeof (char),80, output->fp);
	/*
	** starting time
	*/
	fval = SimulationTime();
	fwrite (&fval, sizeof (float),1, output->fp);
	/*
	** time step
	*/
	fval = Clockrate(output);
	fwrite (&fval, sizeof (float),1,output->fp);
	/*
	** number of data points
	*/
	fwrite (&ndata, sizeof (int),1, output->fp);
	/*
	** data type
	*/
	/*
	datatype = output->datatype;
	*/
	datatype = FLOAT;
	fwrite (&datatype, sizeof (int),1, output->fp);
	/*
	** write out xyz coords of the data
	*/
	for(msg=output->msg_in;msg;msg=msg->next){
	    switch(msg->type){
	    /*
	    ** SAVE 
	    */
	    case 0:
		coord = msg->src->x;
		fwrite(&coord,sizeof(float), 1, output->fp);
		coord = msg->src->y;
		fwrite(&coord,sizeof(float), 1, output->fp);
		coord = msg->src->z;
		fwrite(&coord,sizeof(float), 1, output->fp);
		break;
	    }
	}
	ConditionalCloseOutputFile(output);
	/*
	** indicate that the file has been initialized
	*/
	output->initialize = FALSE;
    }
}


FileOutput(output,action)
struct file_type *output;
Action		*action;
{
    switch(action->type){
    case RESET:
	/*
	** set the initialization flag
	*/
	if(!output->append){
	    output->initialize = TRUE;
	}
	break;
    case PROCESS:
	/*
	** has the file been initialized?
	*/
	if(output->initialize){
	    SetupFile(output);
	}
	/*
	** open the file and append data to it
	*/
	if(OpenOutputFile(output,"a")){
	    WriteOutput(output);
	    ConditionalCloseOutputFile(output);
	}
	break;
    case DELETE:
    case SAVE:
	CloseOutputFile(output);
	break;
    default:
	InvalidAction("FileOutput",output,action);
	break;
    }
}

WriteOutput(output)
struct file_type *output;
{
FILE *fp;
int 	datasize;
MsgIn	*msg;
PFI 	func;
float	fval;

    fp = output->fp;
    /*
    datasize = output->datatype;
    */
    datasize = sizeof(float);
    MSGLOOP(output,msg){
	case 0:
	    fval = MsgValue(msg,float,0);
	    fwrite(&fval,datasize,1,fp);
	    break;
    }
    /*
    ** force it to disk if actioned
    */
    if(output->flush)
	fflush(fp);
}

void do_read_header(argc,argv)
int	argc;
char	**argv;
{
float	fval;
int		i;
int ndata;
int datatype;
FILE	*fp;

    if(argc < 2){
	printf("usage: %s filename\n",argv[0]);
	return;
    }
    if((fp = fopen(argv[1],"r")) == NULL){
	Error();
	printf("unable to find file '%s'\n",argv[1]);
	return;
    }
    /*
    ** go to the beginning of the file
    */
    fseek(fp, 0L, 0);
    /*
    ** read in the file header
    */
    /*
    ** starting time
    */
    fread (&fval, sizeof (float),1,fp);
    printf("%-20s = %e\n","start time",fval);
    /*
    ** time step
    */
    fread (&fval, sizeof (float),1,fp);
    printf("%-20s = %e\n","time step",fval);
    /*
    ** number of data points
    */
    fread (&ndata, sizeof (int),1,fp);
    printf("%-20s = %d\n","ndata points",ndata);
    /*
    ** data type
    */
    fread (&datatype, sizeof (int),1,fp);
    printf("%-20s = %d\n","data type",datatype);
    fclose(fp);
}
