static char rcsid[] = "$Id: out_ascii.c,v 1.1 1992/12/11 19:03:20 dhb Exp $";

/*
** $Log: out_ascii.c,v $
** Revision 1.1  1992/12/11  19:03:20  dhb
** Initial revision
**
*/

#include "sim_ext.h"

#define NOSELECTION	0
#define CELL		1
#define TIME		2
#define HEADER		3

void do_ascii_convert(argc, argv)
int     argc;
char   *argv[];
{
char    label[100];
char    fname[100];
int	cellnum;
FILE	*fp;
int 	header_size;
int	cell;
int	i;
int	nxtarg;
int	xmax, ymax;
int	datatype;
int	j;
float	dt;
float	start_time = 0;
float	time;
float	val;
double 	dval;
int 	ival;
short 	sval;
float 	fval;
float	gain;
char	*data;
short	skip;
int	count;
int	datasize;
short	new_format = 1;
short 	dnum;
short	xy;
int	mode;
float	selecttime;

    if (argc < 3) {
	fprintf (stderr,"usage: %s [-t time][-c cell][-g gain][-old][-xy][-skip #][-header] file\n",
	argv[0]);
	return;
    }
    gain = 1;
    skip = 0;
    fp = NULL;
    xy = 0;
    mode = NOSELECTION;

    nxtarg = 0;
    while( argc > ++nxtarg){
	if (strcmp (argv[nxtarg], "-c") == 0){
	    cell = atoi(argv[++nxtarg]);
	    mode = CELL;
	} else
	if (strcmp (argv[nxtarg], "-t") == 0){
	    selecttime = Atof(argv[++nxtarg]);
	    mode = TIME;
	} else
	if (strcmp (argv[nxtarg], "-g") == 0){
	    gain = Atof(argv[++nxtarg]);
	} else
	if (strcmp (argv[nxtarg], "-skip") == 0){
	    skip = atoi(argv[++nxtarg]);
	} else
	if (strcmp (argv[nxtarg], "-xy") == 0){
	    xy = 1;
	} else
	if (strcmp (argv[nxtarg], "-header") == 0){
	    mode = HEADER;
	} else
	if (strcmp (argv[nxtarg], "-old") == 0){
	    new_format = 0;
	} else
	if(argv[nxtarg][0] != '-'){
	    if((fp = fopen (argv[nxtarg],"r")) != NULL){
		strcpy(fname,argv[nxtarg]);
	    } else {
		Error();
		fprintf(stderr,"file not found : %s\n",argv[nxtarg]);
		return;
	    }
	} else{
	    Error();
	    fprintf(stderr,"unrecognized option '%s'\n",argv[nxtarg]);
	    return;
	}
    }
    if(fp == NULL){
	Error();
	fprintf(stderr,"a data file must be specified\n");
	return;
    }
    if(mode == NOSELECTION){
	Error();
	fprintf(stderr,"either -c or -t option must be specified\n");
	return;
    }

    if(new_format){
	fread(label,sizeof(char),80,fp);
	fread(&start_time,sizeof(float),1,fp);
	fread(&dt,sizeof(float),1,fp);
	fread(&cellnum,sizeof(int),1,fp);
	fread(&datatype,sizeof(int),1,fp);
	header_size = 2*sizeof(int) + 2*sizeof (float) + 80*sizeof(char) +
	3*cellnum*sizeof(float);
    } else {
	fread(&xmax,sizeof(int),1,fp);
	fread(&ymax,sizeof(int),1,fp);
	cellnum= (xmax+1)*(ymax+1);
	fread(&dt,sizeof(float),1,fp);
	fread(&datatype,sizeof(int),1,fp);
	header_size = 3*sizeof(int) + sizeof (float);
    }
    datasize = DataSize(datatype);
    if(mode == HEADER){
	if(new_format){
	    printf("%s\n",label);
	    printf("%-20s = %e\n","start time",start_time);
	    printf("%-20s = %e\n","time step",dt);
	    printf("%-20s = %d\n","cellnum",cellnum);
	    printf("%-20s = %d\n","data type",datatype);
	    printf("%-20s = %d\n","data size",datasize);
	    printf("\n");
	} else {
	    printf("%-20s = %d\n","xmax",xmax);
	    printf("%-20s = %d\n","ymax",ymax);
	    printf("%-20s = %e\n","time step",dt);
	    printf("%-20s = %d\n","data type",datatype);
	    printf("%-20s = %d\n","data size",datasize);
	    printf("\n");
	}
	return;
    }
    if(cellnum <= 0) {
	fprintf(stderr,"file is empty\n");
	fclose(fp);
	return;
    }
    if(mode == CELL){
	count=0;
	fseek (fp, (long) ((cell * datasize) + header_size),0); 
	time = start_time;
	while (!feof(fp)){
	    switch(datatype){
	    case FLOAT :
		dnum = fread (&fval, datasize,1,fp);
		val = fval;
		break;
	    case DOUBLE :
		dnum = fread (&dval, datasize,1,fp);
		val = dval;
		break;
	    case INT :
		dnum = fread (&ival, datasize,1,fp);
		val = ival;
		break;
	    case SHORT :
		dnum = fread (&sval, datasize,1,fp);
		val = sval;
		break;
	    }
	    if(dnum <=0) break;
	    if (feof(fp)) break;
	    /*
	    ** print the value
	    */
	    if((skip==0) || (count%skip == 0)) {
		if(xy){
		    printf("%e\t%e\n",time,val);
		} else {
		    printf("%e\n",val);
		}
	    }
	    time += dt;
	    count++;
	    fseek (fp, (long)( (cellnum-1)*datasize), 1);
	}
    } else
    if(mode == TIME){
	data = (char *)malloc(cellnum*datasize);
	fseek (fp, (long) ((cellnum*datasize*(selecttime-start_time)/dt) + header_size),0); 
	dnum = fread (data, datasize,cellnum,fp);
	if(dnum != cellnum){
	    fprintf(stderr,"unable to read data at time %g. read %d of %d\n",
	    selecttime,dnum,cellnum);
	    return;
	}
	for(i=0;i<cellnum;i++){
	    if(xy){
		printf("%d\t",i);
	    }
	    switch(datatype){
	    case FLOAT :
		printf("%g\n",((float *)(data))[i]);
		break;
	    case DOUBLE :
		printf("%g\n",((double *)(data))[i]);
		break;
	    case INT :
		printf("%d\n",((int *)(data))[i]);
		break;
	    case SHORT :
		printf("%d\n",((short *)(data))[i]);
		break;
	    case CHAR :
		printf("%d\n",((char *)(data))[i]);
		break;
	    }
	}
    }
    fclose(fp);
}
