static char rcsid[] = "$Id: table.c,v 1.1 1992/11/14 00:37:23 dhb Exp $";

/*
** $Log: table.c,v $
 * Revision 1.1  1992/11/14  00:37:23  dhb
 * Initial revision
 *
*/

#include "olf_ext.h"

/*
** Does a table lookup with interpolation. Also permits one to modify
** the table with sum and product messages, so as to extend the
** dimensionality of the table.
*/

TableFunc(table,action)
register struct table_type *table;
Action		*action;
{
MsgIn	*msg;
double	sy,py;
int		xdivs;
float	xmin,xmax;
Interpol *create_interpol();
short	fill_mode;
double	temp;

    if(debug > 1){
	ActionHeader("VDepGate",table,action);
    }

    SELECT_ACTION(action){
    case PROCESS:
		switch(table->step_mode){
			case TAB_IO :
        		/*
        		** check all of the messages to the table
        		*/
				sy = 0;
				py = 1;
        		MSGLOOP(table,msg) {
            		case 0:				/* index */
        			table->input = MSGVALUE(msg,0);
        			break;
					case 1:				/* summed y */
						sy += MSGVALUE(msg,0);
					break;
					case 2:				/* product y */
						py *= MSGVALUE(msg,0);
					break;
        		}
				if (table->alloced)
        			table->output =
						TabInterp(table->table,table->input) * py + sy;
				else
					table->output = py + sy;
        	break;
			case TAB_LOOP :
				/* ignore inputs, just step through table values */
				temp = table->input + table->stepsize;
				if (temp > table->table->xmax)
					temp = table->table->xmin;
				if (table->alloced)
        			table->output =
						TabInterp(table->table,temp);
				else
					table->output = temp;
				table->input = temp;
			break;
			case TAB_ONCE :
				table->input += table->stepsize;
				if (table->alloced)
        			table->output =
						TabInterp(table->table,table->input);
				else
					table->output = table->input;
			break;
		}
		break;
    case RESET:
        table->output = 0;
        break;
    case SET :
        if (action->argc != 2)
            return(0); /* do the normal set */
        if (strncmp(action->argv[0],"table",5) == 0)
            scale_table(table->table,action->argv[0] + 7,action->argv[1]);
        return(0); /* do the normal set */
		break;


    case TABCREATE:
		if (action->argc < 3) {
			printf("usage : %s xdivs xmin xmax\n","tabcreate");
			return(0);
		}
		xdivs = atoi(action->argv[0]);
		xmin = Atof(action->argv[1]);
		xmax = Atof(action->argv[2]);
		table->table = create_interpol(xdivs,xmin,xmax);
		table->alloced = 1;
        break;

    case TABFILL:
		if (action->argc < 2) {
			printf("usage : %s xdivs fill_mode\n","tabfill");
			return(0);
		}
		xdivs = atoi(action->argv[0]);
		fill_mode = atoi(action->argv[1]);
		fill_table(table->table,xdivs,fill_mode);
        break;
    }
}
