static char rcsid[] = "$Id: tabchannel.c,v 1.1 1992/11/14 00:37:22 dhb Exp $";

/*
** $Log: tabchannel.c,v $
 * Revision 1.1  1992/11/14  00:37:22  dhb
 * Initial revision
 *
*/

#include "olf_ext.h"

static double       savedata[3];

/* E. De Schutter Caltech 1/91, modified Z 4/91 */
/* Tabulated hh-like channel.  The standard voltage dependent 
**	activation (X) and inactivation (Y) factors are present. For
**	concentration dependent processes a third factor (Z) has
**	added.  Z can do a lot of things, most important is that 
**	it gets another message (type1: c) than X and Y (type 0: v). 
**	Standard use for Z is inactivation, just use a Zpower>0.  
**	Alternative is to use it for codependent activation, use
**	Zpower<0, z will equal c times v-dependent table-value.
** For computation efficiency the forward rate factor alpha (A) and 
**	1/tau (B) are tabulated. 
*/
/* debugged, TABFILL added, CALC_MINF, CALC_ALPHA, CALC_BETA added
** by U.S. Bhalla Caltech 2/91 */
/*
** Generalized integration scheme implemented July 1991 by Upi Bhalla 
*/

TabChannel(channel,action)
register struct tab_channel_type *channel;
Action		*action;
{
double 	c,v;
double	A,B;
double	dy;
double	g;
double	dt;
int     int_method;
char    *field;
int     xdivs;
float   xmin,xmax;
Interpol *create_interpol();
short	fill_mode;
MsgIn	*msg;

    if(debug > 1){
	ActionHeader("tab_channel",channel,action);
    }

    SELECT_ACTION(action){
    case INIT:
	channel->activation = 0;
	break;

    case PROCESS:
	dt = Clockrate(channel);
	MSGLOOP(channel,msg) {
	case 0:		/* membrane VOLTAGE */
	    /* 0 = membrane potential */
	    v = MSGVALUE(msg,0);
	    break;
	case 1:		/* ionic CONCENTRATION */
	    /* 0 = concentration */
	    c = MSGVALUE(msg,0);
	    break;
	case 4:		/* reversal potential EK */
	    /* 0 = EK */
		channel->Ek = MSGVALUE(msg,0);
		break;
	}

	/* calculate the active state variables x, y and z and
	**  and calculate the conductance */
	int_method = (int)(channel->object->method);
	g = channel->Gbar;
	if(channel->Xpower != 0){
	    A = TabInterp(channel->X_A,v);
	    B = TabInterp(channel->X_B,v);
	    channel->X = IntegrateMethod(int_method,channel,
			channel->X,A,B,dt,"X");
	    g *= pow(channel->X,channel->Xpower);
	}
	if(channel->Ypower != 0){
	    A = TabInterp(channel->Y_A,v);
	    B = TabInterp(channel->Y_B,v);
	    channel->Y = IntegrateMethod(int_method,channel,
			channel->Y,A,B,dt,"Y");
	    g *= pow(channel->Y,channel->Ypower);
	}
	if(channel->Zpower > 0){
	    A = TabInterp(channel->Z_A,c);
	    B = TabInterp(channel->Z_B,c);
	    channel->Z = IntegrateMethod(int_method,channel,
			channel->Z,A,B,dt,"Z");
	    g *= pow(channel->Z,channel->Zpower);
	} else if(channel->Zpower < 0){
	    A = c * TabInterp(channel->Z_A,v);
	    B = TabInterp(channel->Z_B,v);
	    channel->Z = IntegrateMethod(int_method,channel,
			channel->Z,A,B,dt,"Z");
	    g *= pow(channel->Z,-channel->Zpower);
	}

	/* calculate the transmembrane current */
	channel->Gk = g;
	channel->Ik = (channel->Ek - v) * g;
	break;

    case RESET:
	channel->activation = 0;
	v = get_script_float("EREST_ACT");
	c = 0;
	/* calculate the conductance at Erest */
	MSGLOOP(channel,msg) {
	    case 0:		/* Vm */
		v = MSGVALUE(msg,0);
		break;
	    case 1:		/* Co */
		c = MSGVALUE(msg,0);
		break;
	}
	/* calculate the active state variables x, y and z at steady 
	**  state and and calculate the conductance */
	g = channel->Gbar;
	if(channel->Xpower != 0){
	    A = TabInterp(channel->X_A,v);
	    B = TabInterp(channel->X_B,v);
	    channel->X = A / B;
	    g = g * pow(channel->X,channel->Xpower);
	}
	if(channel->Ypower != 0){
	    A = TabInterp(channel->Y_A,v);
	    B = TabInterp(channel->Y_B,v);
	    channel->Y = A / B;
	    g = g * pow(channel->Y,channel->Ypower);
	}
	if(channel->Zpower > 0){
	    A = TabInterp(channel->Z_A,c);
	    B = TabInterp(channel->Z_B,c);
	    channel->Z = A / B;
	    g *= pow(channel->Z,channel->Zpower);
	} else if(channel->Zpower < 0){
	    A = c * TabInterp(channel->Z_A,v);
	    B = TabInterp(channel->Z_B,v);
	    channel->Z = A / B;
	    g *= pow(channel->Z,-channel->Zpower);
	}
	channel->Gk = g;
	channel->Ik = (channel->Ek - v) * g;
	break;

    case CHECK:
	v = 0;
	c = 0;
	MSGLOOP(channel,msg) {
	    case 0:		/* Vm */
		v = 1;
		break;
	    case 1:		/* Co */
		c = 1;
		break;
	}
	if(v == 0){
	    ErrorMessage("tab_channel","Missing VOLTAGE msg.",channel);
	}
	if((channel->Zpower != 0) && (c == 0)){
	    ErrorMessage("tab_channel","Missing CONCEN msg.",channel);
	}
	if ((channel->Xpower != 0 && !channel->X_alloced) || 
	    (channel->Ypower != 0 && !channel->Y_alloced) ||
	    (channel->Zpower != 0 && !channel->Z_alloced)) { 
            ErrorMessage("TabChannel", "Factor tables not allocated.",channel);
	}
	break;
    case SET :
		/*
		printf("ac=%d,av[0]=%s,av[1]=%s\n",action->argc,action->argv[0],action->argv[1]);
		*/
        if (action->argc != 2)
            return(0); /* do the normal set */
        if (strncmp(action->argv[0],"X_A",3) == 0)
            scale_table(channel->X_A,action->argv[0] + 5,action->argv[1]);
        else if (strncmp(action->argv[0],"X_B",3) == 0)
            scale_table(channel->X_B,action->argv[0] + 5,action->argv[1]);
        else if (strncmp(action->argv[0],"Y_A",3) == 0)
            scale_table(channel->Y_A,action->argv[0] + 5,action->argv[1]);
        else if (strncmp(action->argv[0],"Y_B",3) == 0)
            scale_table(channel->Y_B,action->argv[0] + 5,action->argv[1]);
            return(0); /* do the normal set */
		break;
    case SAVE2:
	savedata[0] = channel->X;
	savedata[1] = channel->Y;
	savedata[2] = channel->Z;
	/* action->data contains the file pointer */
/* mds3 changes */
	fwrite(savedata,sizeof(double),3,(FILE*)action->data);
	break;

    case RESTORE2:
	/* action->data contains the file pointer */
/* mds3 changes */
	fread(savedata,sizeof(double),3,(FILE*)action->data);
	channel->X = savedata[0];
	channel->Y = savedata[1];
	channel->Z = savedata[2];
	break;
    case TABCREATE:
	if (action->argc < 4) {
		printf("usage : %s field xdivs xmin xmax\n","tabcreate");
		return(0);
	}
	field = action->argv[0];
	xdivs = atoi(action->argv[1]);
/* mds3 changes */
	xmin = Atof(action->argv[2]);
	xmax = Atof(action->argv[3]);
	if (strcmp(field,"X") == 0) {
		channel->X_A = create_interpol(xdivs,xmin,xmax);
		channel->X_B = create_interpol(xdivs,xmin,xmax);
		channel->X_alloced = 1;
	} else if (strcmp(field,"Y") == 0) {
		channel->Y_A = create_interpol(xdivs,xmin,xmax);
		channel->Y_B = create_interpol(xdivs,xmin,xmax);
		channel->Y_alloced = 1;
	} else if (strcmp(field,"Z") == 0) {
		channel->Z_A = create_interpol(xdivs,xmin,xmax);
		channel->Z_B = create_interpol(xdivs,xmin,xmax);
		channel->Z_alloced = 1;
	} else {
		printf("field '%s' not known\n",field);
		return(0);
	}
	break;
    case TABFILL:
        if (action->argc < 3) {
            printf("usage : %s field xdivs fill_mode\n","tabfill");
            return(0);
        }
        field = action->argv[0];
        xdivs = atoi(action->argv[1]);
        fill_mode = atoi(action->argv[2]);
        if (strcmp(field,"X") == 0) {
            fill_table(channel->X_A,xdivs,fill_mode);
            fill_table(channel->X_B,xdivs,fill_mode);
        } else if (strcmp(field,"Y") == 0) {
            fill_table(channel->Y_A,xdivs,fill_mode);
            fill_table(channel->Y_B,xdivs,fill_mode);
        } else if (strcmp(field,"Z") == 0) {
            fill_table(channel->Z_A,xdivs,fill_mode);
            fill_table(channel->Z_B,xdivs,fill_mode);
        } else {
            printf("field '%s' not known\n",field);
            return(0);
        }
        break;
    }
}

TabChannel_CALC_MINF(channel,action)
register struct tab_channel_type *channel;
Action      *action;
{
double	alpha,beta;
char	*gate;
Interpol	*ipa,*ipb;
double	m;

    if(action->argc == 2){
	gate = action->argv[0];
		if (strcmp(gate,"X") == 0) {
			ipa = channel->X_A;
			ipb = channel->X_B; 
		} else if (strcmp(gate,"Y") == 0) {
			ipa = channel->Y_A;
			ipb = channel->Y_B;
		} else if (strcmp(gate,"Z") == 0) {
			ipa = channel->Z_A;
			ipb = channel->Z_B;
		}
    	channel->activation = Atof(action->argv[1]);
    } else {
    Error();
    printf("usage : CALC_MINF gate voltage\n");
    }
    /*
    ** calculate the steady state value of the state variable
    */
	alpha = TabInterp(ipa,channel->activation);
	/* remember that in tabchannels beta is 1/tau */
	beta = TabInterp(ipb,channel->activation);
    m = alpha/beta;
    action->passback = ftoa(m);
}


TabChannel_CALC_ALPHA(channel,action)
register struct tab_channel_type *channel;
Action		*action;
{
double	alpha;
char	*gate;
Interpol	*ip;

    if(action->argc == 2){
	gate = action->argv[0];
		if (strcmp(gate,"X") == 0) {
			ip = channel->X_A;
		} else if (strcmp(gate,"Y") == 0) {
			ip = channel->Y_A;
		} else if (strcmp(gate,"Z") == 0) {
			ip = channel->Z_A;
		}
    	channel->activation = Atof(action->argv[1]);
    } else {
    Error();
    printf("usage : CALC_ALPHA gate voltage\n");
    }
    /*
    ** calculate the steady state value of the state variable
    */
	alpha = TabInterp(ip,channel->activation);
    action->passback = ftoa(alpha);
}

TabChannel_CALC_BETA(channel,action)
register struct tab_channel_type *channel;
Action		*action;
{
double	alpha,beta;
char	*gate;
Interpol	*ipa,*ipb;

    if(action->argc == 2){
	gate = action->argv[0];
		if (strcmp(gate,"X") == 0) {
			ipa = channel->X_A;
			ipb = channel->X_B; 
		} else if (strcmp(gate,"Y") == 0) {
			ipa = channel->Y_A;
			ipb = channel->Y_B;
		} else if (strcmp(gate,"Z") == 0) {
			ipa = channel->Z_A;
			ipb = channel->Z_B;
		}
    	channel->activation = Atof(action->argv[1]);
    } else {
    Error();
    printf("usage : CALC_MINF gate voltage\n");
    }
    /*
    ** calculate the steady state value of the state variable
    */
	alpha = TabInterp(ipa,channel->activation);
	/* remember that in tabchannels beta is 1/tau */
	beta = TabInterp(ipb,channel->activation);
    beta -= alpha;
    action->passback = ftoa(beta);
}
