// genesis

/*
** $Id: olflib.g,v 1.1 1992/11/14 00:38:47 dhb Exp $
**
** $Log: olflib.g,v $
 * Revision 1.1  1992/11/14  00:38:47  dhb
 * Initial revision
 *
*/

/*
************************************************************************
**                       OLF SHELL COMMANDS                           **
************************************************************************
*/

// Functions for filling tabchannels and gates with HH-curves
addfunc setup_alpha SetupAlpha
addfunc setup_tau SetupTau
addfunc       setup_gate SetupGate
addfunc       tweak_alpha TweakAlpha
addfunc       tweak_tau TweakTau
addfunc       scale_tabchan ScaleTabchan
addfunc       duplicate_table DuplicateTable

addaction TABCREATE 200
addaction TABFILL 201

// Values for the fill modes for the tables
int	B_SPLINE_FILL = 0
int	C_SPLINE_FILL = 1
int	LINEAR_FILL = 2

/*
*************************************************************************
**                              OBJECT TABLE                           **
*************************************************************************
*/
//==========================================================================
//	name		data            function	class	
//==========================================================================

object	receptor	olf_receptor_type OlfReceptor 	segment \
	-author 	"U.S.Bhalla Caltech Jan/90" \
	-actions 	INIT PROCESS RESET CHECK RECALC SAVE2 RESTORE2 \
	-messages 	ODOR 0 	1 strength \		/* type 0: strength */
			GAIN 1	1 sensitivity \	/* type 1: sensitivity */
	-fields		"response[10]	:	weights for each odor" \
			"Vmin,Vmax	:	Range of membrane potentials" \
			"min_rate,max_rate :	range of firing rates" \
	-description	"Does weighted sum of odors to get activity." \
			"Generates both a memb voltage and a spike"

object	receptor2	olf_receptor2_type OlfReceptor2	segment channel \
	-author 	"U.S.Bhalla Caltech Jan/90" \
	-actions 	INIT PROCESS RESET SET CHECK RECALC SAVE2 RESTORE2 \
	-messages 	VOLTAGE		0 	1 Vm \
			ODOR 		1	2 activation odor_no \	
			MODULATION	2	1 modulation \
	-fields		"response[nodors] :	weights for each odor" \
			"nodors		:	Number of odors" \
			"tau1 tau2	:	Time constants of channel" \
			"gmax		:	peak conductance" \
			"Ik		:	channel current" \
			"modulation	:	gain control on responses" \
	-description	"Does weighted sum of odors to get activation" \
			"of a channel with usual conductance properties"

object	disk_in		disk_in_type	DiskIn	 	segment \
	-author 	"U.S.Bhalla Caltech Jan/90" \
	-actions 	INIT PROCESS RESET SET CHECK RECALC \
	-fields		"filename	:	name of data file" \
			"leave_open	:	leave file open between steps" \
			"nx,ny		:	dimensions of input array" \
			"loop		:	return to start of file on EOF"\
			"val		:	input array" \
	-description	"Reads in a 2-d array of data from an ascii file."

/* 
** Modified Jul 1991 by Upi Bhalla to remove integ-method message
*/
object	tabgate		tab_gate_type TabGate	segment gate \
	-author 	"U.S.Bhalla Caltech Feb/90" \
	-actions 	RESET \
			PROCESS \
			TABCREATE \
			TABFILL \
			SET \
			SAVE2 \
			RESTORE2 \
			*CALC_MINF TabGate_CALC_MINF \
			 *CALC_ALPHA TabGate_CALC_ALPHA \
			 *CALC_BETA TabGate_CALC_BETA \
	-messages 	VOLTAGE		0 	1 voltage \
			SUM_ALPHA	2	1 "sum onto alpha func" \
			PRD_ALPHA	3	1 "multiply onto alpha func" \
			SUM_BETA	4	1 "sum onto beta func" \
			PRD_BETA	5	1 "multiply onto beta func" \
			EREST		6	1 "resting potl for resets" \
	-fields		"m		:	state of gate" \
			"alpha		:	interpol struct for alpha" \
			"beta		:	interpol struct for beta" \
			"instantaneous	:	flag for looking at inst resp" \
	-description	"A gate with tabulated dependencies on any field for" \
			"opening and closing. Voltage and ion conc most" \
			"common fields for dependencies." \
			"The table for the object is created using tabcreate."

object	table		table_type TableFunc	segment \
	-author 	"U.S.Bhalla Caltech Feb/90" \
	-actions 	RESET \
			PROCESS \
			TABCREATE \
			TABFILL \
			SET \
	-messages 	INPUT		0 	1 input \
			SUM		1	1 "sum onto table" \
			PRD		2	1 "multiply onto table" \
	-fields		"input		:	input to table" \
			"output		:	output of table" \
			"table		:	interpol struct for table" \
	-description	"A table with a couple of message slots for adding" \
			"dependencies on other fields." \
			"The table for the object is created using tabcreate."


object	tabchannel		tab_channel_type TabChannel	segment channel \
	-author 	"E. De Schutter Caltech Jan 91" \
	-actions 	INIT RESET PROCESS CHECK \
				TABCREATE TABFILL \
				SET \
				SAVE2 RESTORE2 \
				*CALC_MINF TabChannel_CALC_MINF \
			 	*CALC_ALPHA TabChannel_CALC_ALPHA \
			 	*CALC_BETA TabChannel_CALC_BETA \
	-messages 	VOLTAGE		0 	1 voltage \
				CONCEN		1	1 "concentration for Z-factor" \
				EK          4   1 Ek \
	-fields		"Gk, Ik, Ek, Gbar" \
				"X,Y,Z:	3 gates, X=m, Y=h and Z are optional," \
				" Z is concentration dependent" \
				"X_A,X_B,...:	interpol structures" \
				"instantaneous	:	flag for looking at inst resp" \
	-description "channel with tabulated equations" \
			"The table for the object is created using tabcreate," \
			"A-table contains alpha, B-table contains 1/tau," \
			"to minimize calculation time."


object	ddsyn		dd_syn_type DDSyn	segment channel \
	-author 	"Upinder S. Bhalla, Caltech May 91" \
	-actions 	INIT RESET PROCESS CHECK SET \
				TABCREATE TABFILL \
				SAVE2 RESTORE2 \
	-messages 	VOLTAGE		0 	1 voltage \
				ACTIVATION	1	1 "activation" \
				V_PRESYN	2	1 "presyn voltage" \
				RAND_ACTIVATION	3	2 probability amplitude \
	-fields		"Gk, Ik, Ek, gmax" \
				"tau1 tau2 : time consts of channel activation" \
				"transf:	transform from Vm to activation" \
	-description "dendrodendritic synapse with tabulated transform" \
			"from presyn potential to postsyn activation." \
			"The table for the transform is created using tabcreate" \
			"and is shared with all copies of the element"
