/*
** $Id: olf_struct.h,v 1.1 1992/11/14 00:37:21 dhb Exp $
**
** $Log: olf_struct.h,v $
 * Revision 1.1  1992/11/14  00:37:21  dhb
 * Initial revision
 *
*/

#include "struct_defs.h"
#define NODORS 10
#define TABCREATE 200
#define TABFILL 201

struct olf_receptor_type {
	SEGMENT_TYPE
	float	response[NODORS];
	float	Vm;
	float	Vmin;
	float	Vmax;
	float	max_rate;
	float	min_rate;
	float	state;
	float	gain;
	int		transfer_form;
};

struct olf_receptor2_type {
	CHAN_TYPE
	float	*response;
	float	modulation;
	int		nodors;
	short	allocated;
	/*
	double	Ik;  Repositioned
	double	Gk;
	float	Ek;
	*/
	double	X,Y;	/* State variables for time response */
	float	tau1;
	float	tau2;
	float	gmax;
	double	xconst1;
	double	xconst2;
	double	yconst1;
	double	yconst2;
	float	norm;
};
#define NO_INTERP 0
#define LIN_INTERP 1
#define FIXED 2

#define B_SPLINE_FILL 0
#define C_SPLINE_FILL 1
#define LINEAR_FILL 2

struct interpol_struct {
    double  xmin;
    double  xmax;
    int     xdivs;
    double  dx;
    double  invdx;
    double  *table;
	double	sx,sy;
	double	ox,oy;
    short   calc_mode;	/* This can be one of : NO_INTERP, LIN_INTERP,
						** FIXED */
    short   allocated;
};

typedef struct interpol_struct Interpol;

struct tab_gate_type {
    SEGMENT_TYPE
    double	m;
	struct interpol_struct *alpha;
	short	alpha_alloced;
	struct interpol_struct *beta;
	short	beta_alloced;
    short	instantaneous;
};

#define TAB_IO 0
#define TAB_LOOP 1
#define TAB_ONCE 2

struct table_type {
	ELEMENT_TYPE
	double	input;
	double	output;
	struct	interpol_struct *table;
	short	alloced;
	short	step_mode;
	double	stepsize;
};

struct tab_channel_type {
    CHAN_TYPE
	/*
    double  Gk;
    float   Ik;
    float   Ek;
	*/
    float   Gbar;
    double  X;
    double  Y;
    double  Z;
	struct interpol_struct *X_A;
	struct interpol_struct *X_B;
	short	X_alloced;
	struct interpol_struct *Y_A;
	struct interpol_struct *Y_B;
	short	Y_alloced;
	struct interpol_struct *Z_A;
	struct interpol_struct *Z_B;
	short	Z_alloced;
    float   Xpower;
    float   Ypower;
    float   Zpower;
};

struct disk_in_type {
	SEGMENT_TYPE
	FILE	*fp;
	char	*filename;
	short	fileformat;	/* 0 is default is ASCII, 1 is FMT1 */
	char	*tempdata;	/* data array used for FMT1 reading */
	float	start_time;	/* Fields used for FMT1 handling */
	float	dt;
	int		datatype;
	int		header_size;
	float	time_offset;/* offset from sim time for FMT1 files */
	short	is_open;	/* is the file open yet ? */
	short	leave_open; /* leave the file open between cycles */
	long	lastpos;	/* Field for ASCII handling */
	short	loop;		/* Loop back to start when eof */
	int		nx,ny;		/* dimensions of array */
	short	allocated;	/* is the array allocated yet ? */
	float	**val;		/* array */
};


struct dd_syn_type {
	CHAN_TYPE
	struct	interpol_struct *transf;
	short	transf_alloced;
	float	gmax;
	double	X,Y;	/* State variables for time response */
	float	tau1;
	float	tau2;
	double	xconst1;
	double	xconst2;
	double	yconst1;
	double	yconst2;
	float	norm;
};
