/*
** $Id: hines_struct.h,v 1.1 1992/12/11 19:03:14 dhb Exp $
** $Log: hines_struct.h,v $
** Revision 1.1  1992/12/11  19:03:14  dhb
** Initial revision
**
*/

/* Version 14i, EDS 4/91 */
#include "struct_defs.h"
#define HPUT 203
#define HGET 204
#define HRESTORE 205
#define HSAVE 206
/* This is the memory-efficient option, which may be slower for some
** simulations. It is therefore commented out here. The penalty is
** 4 bytes * XDIVS sample points * 4 gates/channel * N channels
** which is about 300 K for a typical cell model. Not usually a 
** problem.
#define TAB_FLOAT 
*/

typedef struct chaninfo_type {
	Element	*chan;			/* pointer to channel object */
	double	flux_scale;		/* scaling for current flow to Ca_concen,
							** zero if not the src of a I_Ca message */
    int 	nernst;			/* boolean, EK msg present or not */
	struct chaninfo_type *next;
} Cinfo;

typedef struct comp_type {
	double	tbiCm;
	double	tbiRm;
	double	iRa;
	double	sumgchan;
} Compinfo;

typedef struct outinfo_type {
	int		op;
	Element *elm;
	int		comptno;
	int		nchip;
	struct outinfo_type *next;
} Oinfo;

typedef struct ininfo_type {
	int		type;
	MsgIn	*msgin;
	int		nop;
	int		nchip;
	struct ininfo_type *next;
} Iinfo;

struct hsolve_type {
	ELEMENT_TYPE
	/* DO NOT CHANGE THIS FIELDS AFTER THE SETUP CALL ! */
	char	*path;		/* the wildcard list of elms to be integrated */
	int		symcomparts;	/* boolean, defaults to compartment */
	int		useconcen;	/* chooses option for Ca_concen or Ca_shell elements 
						**   (only 1 per compartment): 
						**
						**   0 == default, no Ca_concen or Ca_shell elements
						**	 1 == Ca_concen of Ca_shell objects present.
						*/
	int		usenernst;	/* chooses option for nernst elements (only 1 per
						**   compartment): 
						**
						**   0 == default, no nernst elements
						**   1 == nernst elements present, both CIN and
						**        COUT msgs supported (will use more 
						**        memory if chanmode != 2)
						**   2 == nernst elements present, only CIN msgs
						**   3 == nernst elements present, only COUT msgs
						*/
	int		comptmode;	/* chooses option for compartment calculations.
						**
						**    0 == default uses least memory, and is
						** slightly slower. However, the amount of 
						** time spent in this part is usually less than
						** 10% of the total, so this should not matter.
						**
						**    1 uses a lot of memory and is twice as
						** fast for the actual Hines matrix calculation.
						** This may be only a 5% difference, so do not
						** use unless really necessary. Uses if-
						** statements in inner loop
						**
						**    2 uses a lot of memory and is twice as
						** fast for the actual Hines matrix calculation.
						** This may be only a 5% difference, so do not
						** use unless really necessary. Uses case-
						** statements in inner loop.
						*/
	int		chanmode;	/* chooses option for channel calculations.
						**
						**    0 == default is the most general, uses
						** least memory and is slowest.
						**
						**    1 assumes that all powers are integers. It
						** is faster and uses the same amount of memory
						**
                        **    2 assumes integer powers. It is fastest
                        ** but uses the large 'chip' array.  Assumes that
                        ** all tabchannel Z-gates get their concentration
                        ** from a single Ca_concen or Ca_shell object in
                        ** the compartment.  All compartments Vm fields
						** are updated; tabchannel, channelC2/3, Ca_concen,
						** Ca_shell and nernst fields are NOT updated.
						**
                        **   3 idem, but all elements that had outgoing
						** msg to non-hines objects during the SETUP call
						** are updated at a rate determined by outclock.
						*/
	int		no_elminfo;	/* boolean, if false (default) the HPUT and HSET 
						** commands can be used to get element field
						** values in/out of the hsolve chip array.  This
						** field is relevant for chanmode>=2 only.
						*/
	int		outclock;	/* number [0-99] of the clock used for all
						** outgoing msg (only used if chanmode == 3)
						*/
	int		Vm_reset;	/* When set to 1, this tells the hsolver to
						** retain the previous compartment values for Vm
						** which is useful if the equilibrium potential
						** for a compartment is not equal to the
						** reversal potential.
						*/
    /* all the following fields are initialized by SETUP and should not
	** be changed by user */
	int	ncompts;		/* number of compartments in path */
	Element	**compts;	/* Array of element pointers IN ORDER of EL */
	/* This order is important : the following arrays depend on it ! */
	int		*parents;	/* array of indices for parent elms */
	int		*nkids;		/* array for number of child elms */
	int		**kids;		/* array of indices for child elms */
	int		*hnum;		/* array of indices for hines elmnumeration */
	int		*elmnum;	/* inverse of above */

	int		nvalues;	/* size of coeff array */
	double	*values;	/* array of coeffs */
	int		*ri;		/* Row index corresponding to values */
	int		*cip;		/* column index */
	int		*diag;		/* indices for the diagonal elements */

	Element	**concens;	/* Array of element pointers IN ELMNUM ORDER */
	Element	**nernsts;	/* Array of element pointers IN ELMNUM ORDER */
	int  	*nernstmsg;	/* Array of msg types for nernst elms (CIN or COUT) */

	double	*results;	/* array of previous and new state vars */
	double  *vm;		/* array of Vm values */
	double  *flux;		/* array of flux values for chanmode < 2 */

	int		nfuncs;	
	int		*funcs;		/* Giant array for all ops for the actual hines
						** method part (solving compartment voltages)
						*/
	Cinfo	**hh;		/* Array of tabchannel info link lists, which contain
						** ptr to chan and flux and nernst fields,
						** used if chanmode < 2 */
	Cinfo	**chan;		/* idem for non tabchannels */
	Compinfo *comps;	/* Array of compartment data */
	Iinfo	*ininfo;	/* input msg info list.  Used by chanmode>=2 to 
						** update the appropriate elements */
	Oinfo	*outinfo;	/* output msg info list.  Used by chanmode==3 to 
						** update the appropriate elements */
	double	*chip;		/* array for channel and concen element fields,
						** used if chanmode>=2
						*/
	int		nchips;     /* number of entries in chip array */
	int		*ops;       /* array for channel and concen instructions, 
						** used if chanmode>=2
						*/
	int		nops;       /* number of entries in ops array */
	int		*chip_index;/* indexes compartment entries in chip array,
						** made when no_elminfo==0 && chanmode>=2
						*/
	int		*ops_index; /* indexes compartment entries in ops array,
						** made when no_elminfo==0 && chanmode>=2
						*/
	int     *comp_elms;/* indexes compartment to chan_index,
						** made when no_elminfo==0 && chanmode>=2
						*/
	int     nelms;     /* number of entries in chan_index */
	int     nelm_names;/* number of entries in chan_names */
	char    **elm_names;/* stores chan names,
						** made when no_elminfo==0 && chanmode>=2
						*/
	int     *elm_index;/* indexes chan entries in chip array, ops array
						** and chan_names array,
						** made when no_elminfo==0 && chanmode>=2
						*/
	double	invdx;		
	double	xmin;
	int		xdivs;
	int		ntab;
#ifdef TAB_FLOAT
	float	*tablist;	
#else
	double	*tablist;	
#endif
						/* The composite table. All voltage indexed lookup 
						** tables are stored here so that values for the same
						** voltage will be represented in adjacent
						** memory locations */
	double	cinvdx;		
	double	cxmin;
	int		cxdivs;
	int		cntab;
#ifdef TAB_FLOAT
	float	*ctablist;
#else
	double	*ctablist;
#endif
						/* The composite table. All concentration indexed  
						** lookup tables are stored here so that values for the 
						** same concentration will be represented in adjacent
						** memory locations */
	
	int		sntab;
	double	*stablist;	/* Table of constants for synaptic channels, 6
						** entries for each channel type */
	double  dt;
};

typedef struct hsolve_type Hsolve;

#define ERR -1

/* array sizes */
#define MAXTAB 40	/* max number of conductance rate factor tables */
#define SYNSIZE 4
#define MAXSYN 60	/* max number of synaptic equation tables */
#define MAXNAMES 10000 /* max number of different elm names */

/* msg numbers */
#define CHANNEL 0
#define RAXIAL 1
#define AXIAL 2
#define INJECT 3
#define DUPLICATE 202
#define VOLTAGE 0
#define CONCEN 1
#define EK 4
#define I_Ca 0
#define fI_Ca 1
#define BASE 4
#define CIN 0
#define COUT 1
#define TEMP 2
#define ACTIVATION 1

#define TINY 1.0e-5
#define VTINY 1.0e-10
#define MTINY 1.0e-12
#define FORWARD_ELIM 0
#define BACKWARD_ELIM 1
#define SCALE 2
#define CALC_RESULTS 3
#define SET_DIAG 4
#define FINISH 5

/* op codes */
#define COMPT_OP 100
#define FCOMPT_OP 101
#define CONC_VAL_OP 1000
#define CONC_OP 1001
#define NERNST_IN_OP 2001
#define NERNST_OUT_OP 2002
#define CHAN_OP 3000
#define GCHAN_OP 3100
#define ADD_EK_CURR_OP 3200
#define ADD_NERNST_CURR_OP 3201
#define POS_FLUX_OP 3300
#define NEG_FLUX_OP 3301
#define STORE_CURR_OP 3400
#define XGATE_OP 4000
#define ZGATE_OP 4100
#define SYN2_OP 5000
#define SYN3_OP 5100

#define INJECT_OP 1
#define BASE_OP 2

#define GAMMA

/* Upinder S. Bhalla Caltech May-December 1991
** Erik De Schutter December 1991-Februari 1992
**
** We would like to acknowlege the advice of Dr. Michael Mascagni
** during the development of this element.
*/

