static char rcsid[] = "$Id: hh_update.c,v 1.1 1992/12/11 19:03:10 dhb Exp $";

/*
** $Log: hh_update.c,v $
** Revision 1.1  1992/12/11  19:03:10  dhb
** Initial revision
**
*/

#include "hines_ext.h"
#include "seg_struct.h"
#include "olf_struct.h"
#include "dev_struct.h"

/* This file contains the routines for updating the coeffs of the 
** hh channels. These routines are non-object-oriented. These routines
** typically use the most cpu time.
*/ 

/* this is the plain vanilla, default version */

do_hh_update(hsolve)
	Hsolve	*hsolve;
{
	int	ncompts = hsolve->ncompts;
	int		*elmnum;
	struct compartment_type	**compts;
	Cinfo	**hh;
	Cinfo	*hentry;
	struct Ca_shell_type **concen;
	struct nernst_type **nernst;
	register int		i;
	double	dt;
	double	tby2;
	double	c,g,temp;
	double	TabInterp();
	struct tab_channel_type *h;
	register double v;
	double upi_pow();
	double X,Y,Z;
	float Xpow,Ypow,Zpow;

	elmnum = hsolve->elmnum;
	compts = (struct compartment_type **)hsolve->compts;
	hh=hsolve->hh;
	concen = (struct Ca_shell_type **)hsolve->concens;
	nernst = (struct nernst_type **)hsolve->nernsts;

	dt = Clockrate(hsolve);
	tby2 = dt/2.0;
	
	for(i=0;i<ncompts;i++) {
		if (!(hentry=hh[i]))
			continue;
		v = compts[elmnum[i]]->Vm;
		/* looping over all hh chans on this compt */
		for(;hentry;hentry=hentry->next) {
			h=(struct tab_channel_type *)(hentry->chan);
			g=h->Gbar;
			if ((Xpow = h->Xpower) > TINY) {
				/* Trapezoid method of integration */
				temp=1.0+tby2*TabInterp(h->X_B,v);
				X=h->X=(h->X*(2.0-temp)+dt*TabInterp(h->X_A,v))/temp;
				g*=upi_pow(X,Xpow);
				h->X=X;
			}
			if ((Ypow = h->Ypower) > TINY) {
				if (h->Y_B) {
					temp=1.0+tby2*TabInterp(h->Y_B,v);
					Y=h->Y=(h->Y*(2.0-temp)+dt*TabInterp(h->Y_A,v))/temp;
				} else {
					Y=h->Y=(h->Y+dt*TabInterp(h->Y_A,v));
				}
				g*=upi_pow(Y,Ypow);
				h->Y=Y;
			}
			if ((Zpow = h->Zpower) != 0.0){
				c = (concen[i])->Ca;
				if (Zpow > TINY) {
					temp=1.0+tby2*TabInterp(h->Z_B,c);
					Z=(h->Z*(2.0-temp)+dt*TabInterp(h->Z_A,c))/temp;
					g*=upi_pow(Z,Zpow);
					h->Z=Z;
				} else { /* Zpow is negative */
					temp=1.0+tby2*TabInterp(h->Z_B,v);
					Z=(h->Z*(2.0-temp)+dt*(c*TabInterp(h->Z_A,v)))/
						temp;
					g*=upi_pow(Z,-Zpow);
					h->Z=Z;
				}
			}
            if(hentry->nernst) {
                h->Ek = (nernst[i])->E;
            }
			if (g==0.0) {
				h->Gk=0.0;
				h->Ik=0.0;
			} else {
				h->Gk=g;
				h->Ik=g*(h->Ek - v);
			}
		}
	}
}

/*
** A utility function for the above routine
*/

double upi_pow(x,y)
	double x;
	float  y;
{
	double x1;

	if (y==2.0)
		return(x*x);
	if (y==1.0)
		return(x);
	if (y==3.0)
		return(x*x*x);
	if (y==4.0) {
		x*=x;
		return(x*x);
	}
	if (y==5.0) {
		x1=x;
		x*=x;
		x*=x*x1;
		return(x);
	}
	if (fabs(y)<VTINY) return(1.0);

	return(pow(x,y));
}


/*
** This is a slightly more efficient but also restricted version,
** We assume here that X,Y,Z vary between 0.0 and 1.0, if either of
** them could be >>> 1.0 then one should not use this routine!
*/

do_unrolled_hh_update(hsolve)
	Hsolve	*hsolve;
{
	int	ncompts = hsolve->ncompts;
	int		*elmnum;
	struct compartment_type	**compts;
	Cinfo	**hh;
	Cinfo	*hentry;
	struct Ca_shell_type **concen;
	struct nernst_type **nernst;
	int		i;
	double	dt;
	double	tby2;
	double	c,temp;
	double	TabInterp();
	register double g;
	register struct tab_channel_type *h;
	double	v;
	register double	X,Y,Z;
	register int Xpow,Ypow,Zpow;
	register int	ilo;
	register Interpol *ip;

	elmnum = hsolve->elmnum;
	compts = (struct compartment_type **)hsolve->compts;
	hh=hsolve->hh;
	concen = (struct Ca_shell_type **)hsolve->concens;
	nernst = (struct nernst_type **)hsolve->nernsts;

	dt = Clockrate(hsolve);
	tby2 = dt/2.0;
	
	for(i=0;i<ncompts;i++) {
		if (!(hentry=hh[i]))
			continue;
		v = compts[elmnum[i]]->Vm;
		/* looping over all hh chans on this compt */
		for(;hentry;hentry=hentry->next) {
			h=(struct tab_channel_type *)(hentry->chan);
			g=h->Gbar;
			if ((Xpow = h->Xpower) > TINY) {
				/* Trapezoid method of integration */
				if (ip=h->X_B) {
					ilo=(v-ip->xmin)*ip->invdx;
					if (ilo<0)
						temp=1.0+tby2*ip->table[0];
					else if(ilo>ip->xdivs)
						temp=1.0+tby2*ip->table[ip->xdivs];
					else
						temp=1.0+tby2*ip->table[ilo];
				} else {
					temp=1.0;
				}
				if (ip=h->X_A) {
					X=h->X;
					ilo=(v-ip->xmin)*ip->invdx;
					if (ilo<0)
						X=(X*(2.0-temp)+dt*ip->table[0])/temp;
					else if(ilo>ip->xdivs)
						X=(X*(2.0-temp)+dt*ip->table[ip->xdivs])/temp;
					else
						X=(X*(2.0-temp)+dt*ip->table[ilo])/temp;
				} else {
					X*=2.0/temp - 1.0;
				}
				h->X=X;
			
        		if (Xpow==1.0) {
                		g*=X;
        		} else if (X>VTINY) {
					if (Xpow==2.0) {
                			g*=(X*X);
        			} else if (Xpow==3.0) {
                			g*=X*X*X;
        			} else if (Xpow==4.0) {
                			X*=X;
                			g*=X*X;
        			} else if (Xpow==5.0) {
                			g*=X;
                			X*=X;
                			X*=X;
                			g*=X;
        			} else {
							g*=pow(X,Xpow);
					}
				} else {
					g=0.0;
				}
			}
			if ((Ypow = h->Ypower) > TINY) {
				if (ip=h->Y_B) {
					ilo=(v-ip->xmin)*ip->invdx;
					if (ilo<0)
						temp=1.0+tby2*ip->table[0];
					else if(ilo>ip->xdivs)
						temp=1.0+tby2*ip->table[ip->xdivs];
					else
						temp=1.0+tby2*ip->table[ilo];
				} else {
					temp=1.0;
				}
				if (ip=h->Y_A) {
					Y=h->Y;
					ilo=(v-ip->xmin)*ip->invdx;
					if (ilo<0)
						/*
						Y*=2.0-temp;
						Y+=dt*ip->table[0];
						Y/=temp;
						*/
						Y=(Y*(2.0-temp)+dt*ip->table[0])/temp;
					else if(ilo>ip->xdivs)
						Y=(Y*(2.0-temp)+dt*ip->table[ip->xdivs])/temp;
					else
						Y=(Y*(2.0-temp)+dt*ip->table[ilo])/temp;
				} else {
					Y*=2.0/temp - 1.0;
				}
				h->Y=Y;

				if (Ypow==1.0) {
						g*=Y;
				} else if (Y>VTINY) {
					if (Ypow==2.0) {
							g*=(Y*Y);
					} else if (Ypow==1.0) {
							g*=Y;
					} else if (Ypow==3.0) {
							g*=Y*Y*Y;
					} else if (Ypow==4.0) {
							Y*=Y;
							g*=Y*Y;
					} else if (Ypow==5.0) {
							g*=Y;
							Y*=Y;
							Y*=Y;
							g*=Y;
					} else {
							g*=pow(Y,Ypow);
					}
				} else {
					g=0.0;
				}

			}
			if ((Zpow = h->Zpower) != 0.0){
				c = (concen[i])->Ca;
				if (ip=h->Z_B) {
					if (Zpow > TINY) {
						ilo=(c-ip->xmin)*ip->invdx;
					} else {
						ilo=(v-ip->xmin)*ip->invdx;
					}
					if (ilo<0)
						temp=1.0+tby2*ip->table[0];
					else if(ilo>ip->xdivs)
						temp=1.0+tby2*ip->table[ip->xdivs];
					else
						temp=1.0+tby2*ip->table[ilo];
				} else {
					temp=1.0;
				}
				if (ip=h->Z_A) {
					Z=h->Z;
					if (Zpow > TINY) {
						ilo=(c-ip->xmin)*ip->invdx;
						if (ilo<0)
							Z=(Z*(2.0-temp)+dt*ip->table[0])/temp;
						else if(ilo>ip->xdivs)
							Z=(Z*(2.0-temp)+dt*ip->table[ip->xdivs])/temp;
						else
							Z=(Z*(2.0-temp)+dt*ip->table[ilo])/temp;
					} else {
						ilo=(v-ip->xmin)*ip->invdx;
						if (ilo<0)
							Z=(Z*(2.0-temp)+dt*(c*ip->table[0]))/temp;
						else if(ilo>ip->xdivs)
							Z=(Z*(2.0-temp)+dt*(c*ip->table[ip->xdivs]))/temp;
						else
							Z=(Z*(2.0-temp)+dt*(c*ip->table[ilo]))/temp;
						Zpow = -Zpow;
					}
				} else {
					Z*=2.0/temp - 1.0;
					Zpow = fabs(Zpow);
				}
				h->Z=Z;
        		if (Zpow==1.0) {
                		g*=Z;
        		} else if (Z>VTINY) {
					if (Zpow==2.0) {
                			g*=(Z*Z);
        			} else if (Zpow==3.0) {
                			g*=Z*Z*Z;
        			} else if (Zpow==4.0) {
                			Z*=Z;
                			g*=Z*Z;
        			} else if (Zpow==5.0) {
                			g*=Z;
                			Z*=Z;
                			Z*=Z;
                			g*=Z;
        			} else {
							g*=pow(Z,Zpow);
					}
				} else {
					g=0.0;
				}
			}
            if(hentry->nernst) {
                h->Ek = (nernst[i])->E;
            }
			if (g==0.0) {
				h->Gk=0.0;
				h->Ik=0.0;
			} else {
				h->Gk=g;
				h->Ik=g*(h->Ek - v);
			}
		}
	}
}


/* This is the fastest version, but uses a lot of memory and 
** makes several assumptions :
** All powers are integers
** All tables have the same upper and lower limits and the same size */
/* One can speed up things even more by commenting out the cases that
** are not used in the type of simulations you run (the size of this loop
** determines whether it fits into the progam cache memory */
do_chip_hh_update(hsolve)
	Hsolve	*hsolve;
{
    register int  i,k,n=0;
    double	*vm;
	double	*results;
	double  dt,tbyc;
	double	v;
	double	c;
	register double	*chip;
	register int	*ops;
    Compinfo    *comps,*comp;
	register double	sumgchan,ichan,flux;
	register double	g;
	register double X;
	double  C;
	double	nernst_Ek;
	int		op,concindex;
	int		nchips,nops;
	register int comptno=0;
	register int ilo;
	int		xdivs,ntab;
	double	invdx,xmin;
	register int cilo;
	int		cxdivs,cntab;
	double	cinvdx,cxmin;
#ifdef TAB_FLOAT
	float	*ctablist;
	float	*tablist;
#else
	double	*ctablist;
	double	*tablist;
#endif
	double	*stablist;

    vm=hsolve->vm;
	tablist=hsolve->tablist;
	stablist=hsolve->stablist;

	nchips=hsolve->nchips;
	chip=hsolve->chip;
	nops=hsolve->nops;
	ops=hsolve->ops;
	comps=hsolve->comps;
	results=hsolve->results;
	ntab=hsolve->ntab;
	invdx=hsolve->invdx;
	xdivs=hsolve->xdivs;
	xmin=hsolve->xmin;

	if (hsolve->useconcen) {
		cntab=hsolve->cntab;
		cinvdx=hsolve->cinvdx;
		cxdivs=hsolve->cxdivs;
		cxmin=hsolve->cxmin;
		ctablist=hsolve->ctablist;
	}

	for(i=0;i<nops;) {
		switch (op=ops[i++]) {
			case COMPT_OP:
			/* store results prev comp */
				comp=&(comps[comptno]);
				comp->sumgchan=sumgchan;
				results[comptno]=v+ichan*comp->tbiCm;
				comptno++;
				/* no break ! */
			case FCOMPT_OP:
			/* start new comp */
				v=vm[comptno];
				sumgchan=0.0;
				ichan=chip[n]+chip[n+1]; /* chip[n]==Em/Rm,chip[n+1]==inject */
				n+=2;
				ilo=(v-xmin)*invdx;
				if (ilo<0)
					ilo=0;
				else if(ilo>xdivs)
					ilo=xdivs;
				ilo=ilo*ntab;
				break;

			case CONC_VAL_OP:
			/* start new concen */
				c=chip[(concindex=n)]+chip[n+1]; /* chip[n]==Ca, chip[n+1]==Ca_base */
				n+=2;
				flux=0.0;
				cilo=(c-cxmin)*cinvdx;
				if (cilo<0)
					cilo=0;
				else if(cilo>cxdivs)
					cilo=cxdivs;
				cilo=cilo*cntab;
				break;

			case NERNST_IN_OP:
			/* compute nernst with changing [in] */
				nernst_Ek=chip[n+1]*log(chip[n]/c);	/* chip[n]==Cout, chip[n+1]==constant */
				n+=2;
				break;

			case NERNST_OUT_OP:
			/* compute nernst with changing [out] */
				nernst_Ek=chip[n+1]*log(chip[n]*c); /* chip[n]==Cin, chip[n+1]==constant */
				n+=2;
				break;

			case CHAN_OP: 
			/* initialize channel */
				g=chip[n++];
				break;

			case XGATE_OP:
			/* compute a voltage dependent gate */
			case ZGATE_OP:
			/* compute a concentration dependent gate */
				if (op==XGATE_OP) {
					k=ilo+ops[i++];
					X=tablist[k];
					X=chip[n]=(chip[n]*(2.0-X)+tablist[k+1])/X;
				} else {
					k=cilo+ops[i++];
					X=ctablist[k];
					X=chip[n]=(chip[n]*(2.0-X)+ctablist[k+1])/X;
				}
				n++;
				/* raising X to the appropriate power */
				switch (ops[i++]) {
					case 1:
						g*=X;
						break;
					case 2:
						g*=X*X;
						break;
					case 3:
						g*=X*X*X;
						break;
					case 4:
						X*=X;
						g*=X*X;
						break;
					case 5:
						g*=X;
						X*=X;
						X*=X;
						g*=X;
						break;
					default:	/* case 6 */
						X*=X;
						g*=X;
						X*=X;
						g*=X;
						break;
				}
				break;

			case ADD_EK_CURR_OP: 
			/* compute current with constant Ek */
				sumgchan+=g;
				ichan+=X=chip[n++]*g;		/* chip[n] == Ek */
				break;

			case ADD_NERNST_CURR_OP: 
			/* compute current with variable Ek */
				sumgchan+=g;
				ichan+=X=nernst_Ek*g;
				break;

			case POS_FLUX_OP:
			/* add current to flux */
				flux+=X - g*v;			/* X == Ek*g */
				break;

			case NEG_FLUX_OP:
			/* add current to flux */
				flux-=X - g*v;			/* X == Ek*g */
				break;

			case CONC_OP:
			/* compute new concen */
				X=chip[n++];
				chip[concindex]=(chip[concindex]*(2.0-X)+chip[n++]*flux)/X;
				break;

			case SYN3_OP:
			/* channelC3: determine whether it fires */
				if (urandom() <= chip[n++])		/* chip[n]==dt*frequency */
					chip[n]+=stablist[ops[i]]; 
				/* no break! */
			case SYN2_OP:
			/* channelC2: compute the conductance */
				k=ops[i++]+1;		/* op[i] == pointer to table */
				X=chip[n]=chip[n]*stablist[k];
				X=chip[n+1]=X*stablist[k+1] + chip[n+1]*stablist[k+2];
				g*=X;
				n+=2;
				break;

			case GCHAN_OP: 
			/* get g from non-tabchannel */
				g=((struct channelA_type *)ops[i++])->Gk;
				break;
			
			case STORE_CURR_OP:
			/* store Gk and Ik of tabchannel or channelC2/C3 */
				chip[n++]=g;	
				chip[n++]=X - g*v;			/* X == Ek*g */
				break;
		}
	}
	/* store results last comp */
	comp=&(comps[comptno]);
	comp->sumgchan=sumgchan;
	results[comptno]=v+ichan*comp->tbiCm;
}


