static char rcsid[] = "$Id: h_msgs.c,v 1.1 1992/10/29 17:44:43 dhb Exp $";

/*
** $Log: h_msgs.c,v $
 * Revision 1.1  1992/10/29  17:44:43  dhb
 * Initial revision
 *
*/

#include "hines_ext.h"
#include "seg_struct.h"
#include "olf_struct.h"

/* Contains the routines that take care of incoming messages from objects
** not handled by hsolver and outgoing messages not handled by hsolver 
** E De Schutter, Caltech 12/91 */

h_check_msgs(hsolve,elm,op,comptno,nop,nchip)
/* checks all incoming msgs and sets up the necessary Iinfo structures */

	Hsolve	*hsolve;
	Element *elm;
	int		op,comptno,nop,nchip;
{
    MsgIn   *msgin;
	Iinfo	*iinfo;
	int		type;

	for (msgin=elm->msg_in;msgin;msgin=msgin->next) {
		type=msgin->type;
		switch (op) {
			case COMPT_OP:
				switch (type) {
					case CHANNEL:
					case RAXIAL:
					case AXIAL:
					/* all handled by the hsolve code */
						break;
					case INJECT:
						h_add_iinfo(hsolve,msgin,INJECT_OP,nop,nchip+1);
						break;
					default:
						h_msg_alert(type,elm);
				}
				break;
			case CONC_OP:
				switch (type) {
					case I_Ca:
					case fI_Ca:
					/* all handled by the hsolve code */
						break;
					case BASE:
						h_add_iinfo(hsolve,msgin,BASE_OP,nop,nchip+1);
						break;
					default:
						h_msg_alert(type,elm);
				}
				break;
			case NERNST_IN_OP:
				switch (type) {
					case CIN:
					case COUT:
					/* all handled by the hsolve code */
						break;
					default:
						h_msg_alert(type,elm);
				}
				break;
			case CHAN_OP:
				switch (type) {
					case VOLTAGE:
					case CONCEN:
					case EK:
					/* all handled by the hsolve code */
						break;
					default:
						h_msg_alert(type,elm);
				}
				break;
			case SYN2_OP:
				switch (type) {
					/* all handled by the hsolve code */
					case VOLTAGE:
						break;
					case ACTIVATION:
						h_add_iinfo(hsolve,msgin,SYN2_OP,hsolve->ops[nop],nchip);
						break;
					default:
						h_msg_alert(type,elm);
				}
		}

	}
}

int h_has_output(elm)
	Element *elm;
{
    MsgOut  *msgout;
	char	*name;

	for (msgout=elm->msg_out;msgout;msgout=msgout->next) {
		name=msgout->dst->object->name;
		if ((strcmp(name,"compartment")!=0) && (strcmp(name,"tabchannel")!=0) &&
			(strcmp(name,"Ca_shell")!=0) && (strcmp(name,"Ca_concen")!=0) &&
			(strcmp(name,"channelC2")!=0) && (strcmp(name,"channelC3")!=0) &&
		    (strcmp(name,"nernst")!=0) && (strcmp(name,"symcompartment")!=0)) {
			/* msg to an element that is not executed by hsolve */
				return(1);
		}
	}
	return (0);
}

int h_store(hsolve,elm,op,comptno,nchip)
	Hsolve	*hsolve;
	Element *elm;
	int		op,comptno,nchip;
{
	Oinfo	*oinfo;

	oinfo = (Oinfo *)calloc(1,sizeof(Oinfo));
	oinfo->next = hsolve->outinfo;
	hsolve->outinfo = oinfo;
	oinfo->elm = elm;
	oinfo->op = op;
	oinfo->comptno = comptno;
	oinfo->nchip = nchip;
}

h_msg_alert(type,elm)
	int		type;
	Element *elm;
{
	fprintf(stderr,"Warning: message of type %d to %s not supported by hsolver\n",type,elm->name);
}

h_add_iinfo(hsolve,msgin,op,nop,nchip)
	Hsolve	*hsolve;
    MsgIn   *msgin;
	int		op,nop,nchip;
{
	Iinfo	*iinfo;

	iinfo = (Iinfo *)calloc(1,sizeof(Iinfo));
	iinfo->next = hsolve->ininfo;
	hsolve->ininfo = iinfo;
	iinfo->type = op;
	iinfo->msgin = msgin;
	iinfo->nop = nop;
	iinfo->nchip = nchip;
}

h_in_msgs(hsolve)
	Hsolve	*hsolve;
{
    register Iinfo   *iinfo;
    register double *chip;
	register double X;

    chip=hsolve->chip;

    for (iinfo=hsolve->ininfo;iinfo;iinfo=iinfo->next){
      switch(iinfo->type) {
        case INJECT_OP:
            chip[iinfo->nchip]=MSGVALUE(iinfo->msgin,0);
            break;
        case BASE_OP:
            chip[iinfo->nchip]=MSGVALUE(iinfo->msgin,0);
            break;
        case SYN2_OP:
            X=MSGVALUE(iinfo->msgin,0);
            if (X > VTINY) {
                chip[iinfo->nchip]+=X*hsolve->stablist[iinfo->nop];
            }
            break;
      }
    }
}

h_out_msgs(hsolve)
	Hsolve	*hsolve;
{
    register Oinfo   *oinfo;
    extern   short   clock_active[NCLOCKS];

	if (clock_active[hsolve->outclock]) {
	  for (oinfo=hsolve->outinfo;oinfo;oinfo=oinfo->next){
		switch(oinfo->op) {
			case COMPT_OP:
			  chip_get_compt(hsolve,oinfo->elm,oinfo->comptno);
			  break;
			case CONC_OP:
			  chip_get_concen(hsolve,oinfo->elm,oinfo->nchip);
			  break;
			case NERNST_IN_OP:
			  chip_get_nernst(hsolve,oinfo->elm,oinfo->nchip,NERNST_IN_OP);
			  break;
			case NERNST_OUT_OP:
			  chip_get_nernst(hsolve,oinfo->elm,oinfo->nchip,NERNST_OUT_OP);
			  break;
			case CHAN_OP:
			  chip_get_tabchannel(hsolve,oinfo->elm,oinfo->comptno,oinfo->nchip);
			  break;
			case SYN2_OP:
			  chip_get_channelc3(hsolve,oinfo->elm,oinfo->comptno,oinfo->nchip);
			  break;
		}
	  }
	}
}

