static char rcsid[] = "$Id: h_init.c,v 1.1 1992/10/29 16:39:02 dhb Exp $";

/*
** $Log: h_init.c,v $
 * Revision 1.1  1992/10/29  16:39:02  dhb
 * Initial revision
 *
*/

#include "hines_ext.h"
#include "seg_struct.h"
#include "olf_struct.h"

int h_init(hsolve)
	Hsolve	*hsolve;
{
	ElementList *list;
	int 	ncompts;
	Element	**compts;
	Element	*compt,*kid;
	int 	i,j,k;
	MsgIn	*msgin;
	int		hnumcount;
	int		*parents,**kids,*nkids,*elmnum,*hnum;
	int		temp,parentno,valueno,nvalues;
	int		*diag,*cip,*ri;
	double	*values;	
	int		symflag;

	if (!(hsolve->path)) {
		fprintf(stderr,"Error: no path defined for hsolve : Setup failed\n");
		return(ERR);
	}

	list = WildcardGetElement(hsolve->path,0);
	hsolve->ncompts = ncompts = list->nelements;
	hsolve->compts = compts =  list->element;
	hsolve->parents = parents = (int *)calloc(ncompts, sizeof(int));
	hsolve->nkids = nkids = (int *)calloc(ncompts, sizeof(int));
	hsolve->kids = kids = (int **)calloc(ncompts, sizeof(int *));
	hsolve->hnum = hnum = (int *)calloc(ncompts,sizeof(int));
	hsolve->elmnum = elmnum = (int *)calloc(ncompts,sizeof(int));
	hsolve->outinfo = NULL;

	symflag = hsolve->symcomparts;
	if ((!symflag && (strcmp(compts[0]->object->name,"compartment") != 0)) || 
		(symflag && (strcmp(compts[0]->object->name,"symcompartment") != 0))) {
		fprintf(stderr,"Error: type '%s' not supported as hsolve path\n",
			compts[0]->object->name);
		return(ERR);
	}

	/* AXIALs go from parent to kid compts */
	for (i=0;i<ncompts;i++){
		compt = compts[i];
		/* disable element to prevent it from doing anything. */
		HsolveBlock(compt);
		parents[i] = -1;
		for(msgin=compt->msg_in;msgin;msgin=msgin->next) {
			/* look for parent compts */
			if (strcmp(msgin->src->object->type,"compartment_type")==0
				&& msgin->type == AXIAL) {
				for (j=0;j<ncompts;j++) {
					if (msgin->src == compts[j]) {
					/* the jth elment is a parent of the ith element */
						if (parents[i] != -1) {
							fprintf(stderr,"Error: multiple parents for compartment '%s[%d]'\n",compt->name,compt->index);
							return(ERR);
						}
						parents[i] = j;
						nkids[j] += 1;
						break;
					}
				}
			} else if ((hsolve->chanmode<2) && (msgin->type > AXIAL)) {
				fprintf(stderr,"Error: INJECT and EREST messages are not supported\n");
				return(ERR);
			}
		}
	}
	/* Fill in indices for kids */
	for (i=0;i<ncompts;i++){
		k=0;
		if (nkids[i] == 0) {
			kids[i] = NULL; /* a terminal branch */
		} else {
			kids[i]=(int *)calloc(nkids[i],sizeof(int));
			for (j=0;j<ncompts;j++) {
				if (parents[j] == i) {
					kids[i][k] = j;
					k++;
				}
			}
		}
	}

	/* find the soma */
	for (i=0;i<ncompts;i++){
		if (parents[i] == -1) {
		/* This is the trunk element. Usually it will be the soma */
			hnumcount = ncompts-1;
			/* Do Hines numbering */
			do_hnum(hsolve,i,&hnumcount,elmnum);
			break;
		}
	}

	/* count the coeffs */
	nvalues=1; /* since we start at the root elm */
	for (i=0;i<ncompts;i++){
		/* Count all the kids */
		nvalues += nkids[i];
		/* Checking if this is the soma */
		if (parents[i] != -1) {
			if (symflag)
			/* Count all the siblings, including self */
				nvalues += nkids[parents[i]];
			else
			/* only count self */
				nvalues++;
			/* count the parent */
			nvalues++;
		}
	}
	/* allocate the matrices handling the coeffs */
	hsolve->nvalues=nvalues;
	hsolve->results = (double *) calloc(ncompts,sizeof(double));
	hsolve->values = (double *)calloc(nvalues,sizeof(double));
	hsolve->ri = ri = (int *)calloc(nvalues+1,sizeof(int));
	hsolve->cip = cip = (int *)calloc(ncompts + 1,sizeof(int));
	hsolve->diag = diag = (int *)calloc(ncompts+1,sizeof(int));
	/* figure out the indices for the coeffs */
	valueno = 0;
	/* Set up matrices indexing the values matrix */
	for (i=0;i<ncompts;i++){
		cip[i] = valueno;
		j = elmnum[i]; /* j is the index, i is the hnum of the elm */
		/* scanning thru kids. Remember, the Hines numbering was
		** in decreasing order */
		for (k=nkids[j]-1;k>=0;k--) {
			ri[valueno++]=hnum[kids[j][k]];
		}
		if((parentno = parents[j]) != -1) {
			/* scanning thru siblings */
			for (k=nkids[parentno]-1;k>=0;k--) {
				temp=hnum[kids[parentno][k]];
				if (temp == i) { /* diagonal element */
					diag[i] = valueno;
					ri[valueno++]=temp;
				/* include siblings if it is a symmetric compt */
				} else if (symflag) {
					ri[valueno++]=temp;
				}
			}
			/* a coeff for the parent */
			ri[valueno++]=hnum[parentno];
		} else {
			/* a coeff for the root element */
			ri[valueno++]=i;
		}
		/* A little sort routine, which will be needed only for a few
		** rows, to ensure that the order of the coeffs is correct */
		bubble_sort(&ri[cip[i]],valueno - cip[i]);
	}
	if (valueno != nvalues) {
		fprintf("Error assigning coeffs : valueno=%d,nvalues=%d\n",
			valueno,nvalues);
		return(ERR);
	}
	diag[ncompts-1]=nvalues-1;
	diag[ncompts]=nvalues;
	cip[ncompts] = nvalues;
	ri[nvalues] = ncompts;
	return(0);
}

int h2_init(hsolve)
	Hsolve	*hsolve;
{
	int ncompts;

	ncompts=hsolve->ncompts;
	hsolve->vm = (double *) calloc(ncompts,sizeof(double));
	hsolve->comps = (Compinfo *) calloc(ncompts,sizeof(Compinfo));
	return(0);
}

bubble_sort(array,nterms)
	int	*array;
	int nterms;
{
	int temp;
	int i;
	int	flag=1;

	while(flag) {
		flag=0;
		for(i=1;i<nterms;i++) {
			if (array[i-1]>array[i]) {
				/*
				fprintf(stderr,"bubbling %d\n",i);
				*/
				temp = array[i-1];
				array[i-1] = array[i];
				array[i] = temp;
				flag=1;
			}
		}
	}
}

/* Doing hines numbering */
do_hnum(hsolve,comptno,hnum,elmnum)
	Hsolve	*hsolve;
	int		comptno;
	int		*hnum;
	int		*elmnum;
{
	int i;
	int kidno;

	hsolve->hnum[comptno]= *hnum;
	elmnum[*hnum]=comptno;
	*hnum -= 1;
	for(i=0;i<hsolve->nkids[comptno];i++) {
		/* Numbering kids of this elm which have no kids of their own */
		kidno = hsolve->kids[comptno][i];
		if (hsolve->nkids[kidno]==0) {
			hsolve->hnum[kidno] = *hnum;
			elmnum[*hnum]=kidno;
			*hnum -= 1;
		}
	}
	for(i=0;i<hsolve->nkids[comptno];i++) {
		/* Numbering kids of this elm which do have kids of their own */
		kidno = hsolve->kids[comptno][i];
		if (hsolve->nkids[kidno]>0) {
			do_hnum(hsolve,kidno,hnum,elmnum);
		}
	}
}



/*
** This routine sets up the func array for fast solution of the 
** sparse matrix. It does this in two passes : first, it finds
** the number of functions, second it fills them up.
*/
int do_fast_hsetup(hsolve)
	Hsolve	*hsolve;
{
	int i,j,k;
	int	row;
	int	ind1,ind2,ind3;
	int	ncompts;
	int	*ri,*cip,*diag;
	double resultvalue,diavalue,temp;
	int get_index();
	int	nextcip,di,cipnextrow;
	int	cipi,drow;
	int	justcount;
	int	nfuncs=0;
	int	*funcs;

	ncompts=hsolve->ncompts;
	ri=hsolve->ri;
	cip=hsolve->cip;
	diag=hsolve->diag;

	if (hsolve->nfuncs > 0) {
		justcount = 0;
		hsolve->funcs=funcs=(int *)calloc(hsolve->nfuncs,sizeof(int));
	} else {
		justcount = 1;
	}


	/* looping over all rows, doing forward substitution */
	for(i=0;i<ncompts;i++) {
		di=diag[i];
/*		diavalue = values[di];		*/
/*		resultvalue=results[i];		*/
		if(justcount){
			nfuncs+=2;
		} else {
			funcs[nfuncs++]=SET_DIAG;
			funcs[nfuncs++]=i;
		}
		di++;
		nextcip=cip[i+1];
		/* Looping over all coupled rows */
		for(j=di;j<nextcip;j++) {
			row=ri[j]; /* since the matrix is symmetrical, the ri also
					  ** gives the correct row index */
			cipnextrow=cip[row+1];
			for(ind1=cip[row];ind1<cipnextrow;ind1++)
				if(ri[ind1]==i) {
				/* calculate scaling factor */
/*				temp = values[ind1]/diavalue;			*/
/*				results[row] -= resultvalue*temp;		*/
				if(justcount){
					nfuncs+=3;
				} else {
					funcs[nfuncs++]=SCALE;
					funcs[nfuncs++]=ind1;
					funcs[nfuncs++]=row;
				}
				/* looping over all nonzero columns for _ith_ row */
				for(ind2=di,ind3=ind1+1;ind2<nextcip;ind2++){
					for (;ri[ind3]!=ri[ind2];ind3++) {
						if(ind3>=cipnextrow) {
							/* a major screw-up */
							fprintf(stderr,"Error in forward elim:(%d,%d) missing,i=%d,j=%d,ind1=%d,ind2=%d,ind3=%d\n",row,ri[ind2],i,j,ind1,ind2,ind3);
							return(ERR);
						}
					}
					/* Otherwise, proceed with elimination */
/*					values[ind3] -= values[ind2]*temp;		*/
					if(justcount){
						nfuncs+=3;
					} else {
						funcs[nfuncs++]=FORWARD_ELIM;
						funcs[nfuncs++]=ind3;
						funcs[nfuncs++]=ind2;
					}
				}
			}
		}
	}
	/* looping over all rows, doing backwards elimination */
	for(i=ncompts-1;i>=0;i--) {
		di=diag[i];
		cipi=cip[i];
/*		results[i] = temp = results[i]/values[di];		*/
		if(justcount){
			nfuncs+=2;
		} else {
			funcs[nfuncs++]=CALC_RESULTS;
			funcs[nfuncs++]=i;
		}
		for(j=di-1;j>=cipi;j--) {
			/* since the matrix is symmetrical, the ri also
					  ** gives the correct row index */
			drow=diag[row=ri[j]];
			for(ind1=cip[row+1]-1;ind1>drow;ind1--) {
				if(ri[ind1]==i) {
/*					results[row] -= values[ind1]*temp;	*/
					if(justcount){
						nfuncs+=3;
					} else {
						funcs[nfuncs++]=BACKWARD_ELIM;
						funcs[nfuncs++]=row;
						funcs[nfuncs++]=ind1;
					}
				}
			}
		}
	}
	if(justcount){
		nfuncs++;
		hsolve->nfuncs=nfuncs;
	} else {
		funcs[nfuncs++]=FINISH;
	}
	return(0);
}


#ifdef OLD
/*
** Hideous function which figures out which numbers to do what on, but
** instead of performing the functions, saves each operation in a
** table which later operates directly in a single non-looping pass
** on the value array. Since only O(M) operations are needed, this
** approach does not chew up absurd amounts of memory, (about M * 200
** bytes) and it bypasses all index searches and conditionals. A
** gloriously grotesque hack for speed !
*/

int do_hsetup(hsolve)
	Hsolve	*hsolve;
{
	int i,j,k;
	int	ind1,ind2,ind3;
	int nfuncs=0;
	int	*funcs;
	int	*ri,*cip;
	double resultvalue,diavalue,temp;
	int	ncompts;
	int get_index();
	int nfunc_est;

	nfunc_est = (float)(3 * hsolve->nvalues * hsolve->nvalues)/
		(float)(2*hsolve->ncompts) + 10;


	hsolve->funcs = funcs = (int *) calloc(nfunc_est,sizeof(int));
	ri=hsolve->ri;
	cip=hsolve->cip;
	ncompts = hsolve->ncompts;
	
	/*
	for(i=0;i<ncompts;i++) {
		for(j=0;j<ncompts;j++) {
			if (get_index(i,j,ri,cip) >=0)
				fprintf(stderr,"X");
			else
				fprintf(stderr,".");
		}
		fprintf(stderr,"\n");
	}
	*/

	/* looping over all rows, doing forward substitution */
	for(i=0;i<ncompts;i++) {
		/*
		diavalue = values[diag[i]];
		resultvalue = results[i];
		*/
		funcs[nfuncs++]=SET_DIAG;
		funcs[nfuncs++]=i;

		/* looping over all rows below to find coupled ones */
		for(j=i+1;j<ncompts;j++) {
			if((ind1=get_index(j,i,ri,cip)) >= 0) {
			/* Found a coupled row ! */

				/* calculate scaling factor */
				/*
				temp = values[ind1]/diavalue;
				results[j] -= resultvalue*temp;
				*/
				funcs[nfuncs++]=SCALE;
				funcs[nfuncs++]=ind1;
				funcs[nfuncs++]=j;

				/* looping over all nonzero columns for _ith_ row */
				for(k=i+1;k<ncompts;k++){
					if((ind2=get_index(i,k,ri,cip)) >= 0) {
						if((ind3=get_index(j,k,ri,cip)) < 0) {
							/* a major screw-up */
							printf("Error in forward elim:(%d,%d) missing\n",j,k);
							printf("hsetup failed\n");
							return(ERR);
						}
						/* Otherwise, proceed with elimination */
						/*
						values[ind3] -= values[ind2]*temp;
						*/
						funcs[nfuncs++]=FORWARD_ELIM;
						funcs[nfuncs++]=ind3;
						funcs[nfuncs++]=ind2;
					}
				}
			}
		}
	}

	/* looping over all rows, doing backwards elimination */
	for(i=ncompts-1;i>=0;i--) {
		/*
		results[i] = temp = results[i]/values[diag[i]];
		*/
		funcs[nfuncs++]=CALC_RESULTS;
		funcs[nfuncs++]=i;
		for(j=i-1;j>=0;j--) {
			/* looking for a coupled row */
			if((ind1=get_index(j,i,ri,cip)) >= 0) {
				/*
				results[j] -= values[ind1]*temp;
				*/
				funcs[nfuncs++]=BACKWARD_ELIM;
				funcs[nfuncs++]=j;
				funcs[nfuncs++]=ind1;
			}
		}
	}
	funcs[nfuncs++] = FINISH;
	hsolve->nfuncs = nfuncs;
	return(0);
}
#endif

