static char rcsid[] = "$Id: h_data.c,v 1.1 1992/12/11 19:03:08 dhb Exp $";

/*
** $Log: h_data.c,v $
** Revision 1.1  1992/12/11  19:03:08  dhb
** Initial revision
**
*/

#include "hines_ext.h"
#include "seg_struct.h"
#include "olf_struct.h"
#include "dev_struct.h"

/* E. De Schutter, Caltech 12/91 */
/* Performs the HGET and HPUT functions for the different object types:
** a HPUT: element fields -> chip_array
** a HGET: chip_array -> element fields */

chip_put_compt(hsolve,elm,nchip,comptno,Vm_flag)
	Hsolve	*hsolve;
	Element	*elm;
	int		nchip,comptno;
	int		Vm_flag;
{
	struct compartment_type *compt;
	Compinfo	*comp;
	double	*chip;
	double	dt;

    if (hsolve->object->method == CRANK_INT)
        dt = hsolve->dt/2.0;
    else /* BEULER by default */
        dt = hsolve->dt;

    chip=hsolve->chip;
	compt=(struct compartment_type *)elm;
    comp=&(hsolve->comps[comptno]);
	chip[nchip]=compt->Em/compt->Rm;
	chip[nchip+1]=compt->inject;
	/*
	** if (compt->Vm == 0.0)
	** This hack was put in by Erik to enable compartment Vms to be
	** preset, and to then do a reset without changing them.
	** This process is now accomplished by setting the Vm_reset
	** flag in the hsolve structure to 1.
	*/
	if (Vm_flag == 0) {
		hsolve->vm[comptno]=compt->Vm=compt->Em;
	} else {
		hsolve->vm[comptno]=compt->Vm;
	}
	comp->tbiCm=dt/compt->Cm;
	comp->tbiRm=1.0 + comp->tbiCm/compt->Rm;
	comp->iRa=1.0/compt->Ra;
}

chip_put_concen1(hsolve,elm,nchip)
	Hsolve	*hsolve;
	Element	*elm;
	int		nchip;
{
	struct Ca_shell_type *concen;
	double	*chip;

    chip=hsolve->chip;
	concen=(struct Ca_shell_type *)elm;
	chip[nchip]=concen->C;
	chip[nchip+1]=concen->Ca_base;
}

chip_put_concen2(hsolve,elm,nchip)
	Hsolve	*hsolve;
	Element	*elm;
	int		nchip;
{
	struct Ca_shell_type *concen;
	double	*chip;

    chip=hsolve->chip;
	concen=(struct Ca_shell_type *)elm;
	chip[nchip]=1.0+hsolve->dt/(2*concen->tau);
	chip[nchip+1]=hsolve->dt*concen->B;
}

chip_put_nernst(hsolve,elm,nchip,op)
	Hsolve	*hsolve;
	Element	*elm;
	int		nchip;
	int	op;
{
	struct nernst_type *nernst;
	double	*chip;

    chip=hsolve->chip;
	nernst=(struct nernst_type *)elm;
	if(op==NERNST_IN_OP){
	   chip[nchip]=nernst->Cout;
	} else {
	   chip[nchip]=1.0/nernst->Cin;
	}
    nernst->constant=nernst->scale*8.6171458e-5*(nernst->T+273.15)/nernst->valency;
	chip[nchip+1]=nernst->constant;
}

chip_put_tabchannel(hsolve,elm,nchip,hasEk)
	Hsolve	*hsolve;
	Element	*elm;
	int		nchip,hasEk;
{
	struct tab_channel_type *chan;
	double	*chip;

    chip=hsolve->chip;
	chan=(struct tab_channel_type *)elm;
	chip[nchip]=chan->Gbar;
	nchip++;
	if (chan->X_A || chan->X_B) {
		chip[nchip]=chan->X;
		nchip++;
	}
	if (chan->Y_A || chan->Y_B) {
		chip[nchip]=chan->Y;
		nchip++;
	}
	if (chan->Z_A || chan->Z_B) {
		chip[nchip]=chan->Z;
		nchip++;
	}
	if (hasEk) {
		chip[nchip]=chan->Ek;
	}
}

chip_put_channelc3(hsolve,elm,nchip,hasEk)
	Hsolve	*hsolve;
	Element	*elm;
	int		nchip,hasEk;
{
	struct channelC3_type *chan;
	double	*chip;
	double  *tablist;

    chip=hsolve->chip;
	tablist=hsolve->stablist;
	chan=(struct channelC3_type *)elm;
	chip[nchip]=chan->norm;
	nchip++;
	if (strcmp(elm->object->name,"channelC3")==0) {
		chip[nchip]=chan->frequency * hsolve->dt;
		nchip++;
	}
	chip[nchip]=chan->X;
	chip[nchip+1]=chan->Y;
	if (hasEk) {
		chip[nchip+2]=chan->Ek;
	}
}

chip_get_compt(hsolve,elm,comptno)
	Hsolve	*hsolve;
	Element	*elm;
	int		comptno;
{
	struct compartment_type *compt;

	compt=(struct compartment_type *)elm;
	compt->Vm=hsolve->vm[comptno];
}

chip_get_concen(hsolve,elm,nchip)
	Hsolve	*hsolve;
	Element	*elm;
	int		nchip;
{
	double	*chip;
	struct Ca_shell_type *concen;

    chip=hsolve->chip;
	concen=(struct Ca_shell_type *)elm;
	concen->Ca=chip[nchip]+chip[nchip+1];
	concen->C=chip[nchip];
}

chip_get_nernst(hsolve,elm,nchip,op)
	Hsolve	*hsolve;
	Element	*elm;
{
	struct nernst_type *nernst;
	double	*chip;
	double	c;

    chip=hsolve->chip;
	nernst=(struct nernst_type *)elm;
	c=chip[nchip-2]+chip[nchip-1];
	if (op ==  NERNST_IN_OP) {
		nernst->E=chip[nchip+1]*log(chip[nchip]/c);
		nernst->Cin=c;
	} else {
		nernst->E=chip[nchip+1]*log(chip[nchip]*c);
		nernst->Cout=c;
	}
}

chip_get_tabchannel(hsolve,elm,nchip1,nchip2)
/* WARNING: field Ek is not updated! */

	Hsolve	*hsolve;
	Element	*elm;
	int		nchip1,nchip2;
{
	struct tab_channel_type *chan;
	double	*chip;
	double  upi_pow();

    chip=hsolve->chip;
	chan=(struct tab_channel_type *)elm;
	if (chan->X_A || chan->X_B) {
		chan->X=chip[nchip1];
		nchip1++;
	}
	if (chan->Y_A || chan->Y_B) {
		chan->Y=chip[nchip1];
		nchip1++;
                    }
	if (chan->Z_A || chan->Z_B) {
		chan->Z=chip[nchip1];
	}
	if (nchip2) { /* data were stored in chip array */
		chan->Gk=chip[nchip2];
		chan->Ik=chip[nchip2+1];
	} else {     /* no data were stored */
		chan->Gk=chan->Gbar*upi_pow(chan->X,chan->Xpower)
		                   *upi_pow(chan->Y,chan->Ypower)
		                   *upi_pow(chan->Z,chan->Zpower);
		chan->Ik=0.0;	/* not available */
	}
}

chip_get_channelc3(hsolve,elm,nchip1,nchip2)
/* WARNING: field Ek is not updated! */
	Hsolve	*hsolve;
	Element	*elm;
	int		nchip1,nchip2;
{
	struct channelC3_type *chan;
	double	*chip;

    chip=hsolve->chip;
	chan=(struct channelC3_type *)elm;
	if (strcmp(elm->object->name,"channelC3")==0) {
		nchip1++;
	}
	chan->X=chip[nchip1];
	chan->Y=chip[nchip1+1];
	if (nchip2) { /* data were stored in chip array */
		chan->Gk=chip[nchip2];
		chan->Ik=chip[nchip2+1];
	} else {     /* no data were stored */
		chan->Gk=chan->Y*chan->norm;
		chan->Ik=0.0;	/* not available */
	}
}

int hfind_elm(hsolve,elm,comptno,nop,nchip)
	Hsolve  *hsolve;
	Element *elm;
	int		*comptno,*nop,*nchip;
{
	Element **compts,*celm;
	int     *elmnum;
	int		ncompts;
	int     i,n;
	int		failed=1;
	char    **names;
	int     *elms,*celms;
	int Strindex();

	ncompts = hsolve->ncompts;
	compts = hsolve->compts;
	elmnum = hsolve->elmnum;
	names = hsolve->elm_names;
	celms = hsolve->comp_elms;
	elms = hsolve->elm_index;

	if (elm) {
		for (celm=elm; Strindex(celm->object->name,"compartment")<0 ; celm=celm->parent);
		for (*comptno=0;*comptno<ncompts;(*comptno)++) {
			if (compts[elmnum[*comptno]]==celm) {
				break;
			}
		}
		if (*comptno<ncompts) {
			if (Strindex(elm->object->name,"compartment") >= 0) {
				*nop=hsolve->ops_index[*comptno];
				*nchip=hsolve->chip_index[*comptno];
				return(0);
			} else {
				for (i=0;i<hsolve->nelm_names;i++) {
					for (n=celms[*comptno];n<celms[*comptno+1];n+=3) {
						if (strcmp(elm->name,names[elms[n]])==0) {
							*nop=elms[n+1];
							*nchip=elms[n+2];
							return(0);
						}
					}
				}
			}
		} 
	}
	return(1);
}

hput_elm(hsolve,elm,comptno,nop,nchip)
	Hsolve  *hsolve;
	Element *elm;
	int		comptno,nop,nchip;
{
	int     *ops;
	int     i,hasEk;
	int	 	Strindex();

	ops = hsolve->ops;

	if (Strindex(elm->object->name,"compartment") >= 0) {
		chip_put_compt(hsolve,elm,nchip,comptno,1);
	} else if ((strcmp(elm->object->name,"Ca_concen") == 0) ||
			   (strcmp(elm->object->name,"Ca_shell") == 0)) {
		chip_put_concen1(hsolve,elm,nop);
		chip_put_concen2(hsolve,elm,nchip);
	} else if (strcmp(elm->object->name,"nernst") == 0) {
		chip_put_nernst(hsolve,elm,nchip,ops[nop]);
	} else if ((strcmp(elm->object->name,"channelC2") == 0) ||
			   (strcmp(elm->object->name,"channelC3") == 0) ||
               (strcmp(elm->object->name,"tabchannel") == 0)) {
		for(i=++nop;(ops[i]!=ADD_EK_CURR_OP)&&(ops[i]!=ADD_NERNST_CURR_OP);i++);
		hasEk=ops[i]==ADD_EK_CURR_OP;
		if (strcmp(elm->object->name,"tabchannel") == 0) {
			chip_put_tabchannel(hsolve,elm,nchip,hasEk);
		} else {
			chip_put_channelc3(hsolve,elm,nchip,hasEk);
		}
	}
}

hget_elm(hsolve,elm,comptno,nop,nchip)
	Hsolve  *hsolve;
	Element *elm;
	int		comptno,nop,nchip;
{
	int     *ops;
	int     i,j;
	int Strindex();

	ops = hsolve->ops;

	if (Strindex(elm->object->name,"compartment") >= 0) {
		chip_get_compt(hsolve,elm,comptno);
	} else if ((strcmp(elm->object->name,"Ca_concen") == 0) ||
			   (strcmp(elm->object->name,"Ca_shell") == 0)) {
		chip_get_concen(hsolve,elm,nop);
	} else if (strcmp(elm->object->name,"nernst") == 0) {
		chip_get_nernst(hsolve,elm,nchip,ops[nop]);
	} else if ((strcmp(elm->object->name,"channelC2") == 0) ||
			   (strcmp(elm->object->name,"channelC3") == 0) ||
               (strcmp(elm->object->name,"tabchannel") == 0)) {
		for(i=++nop,j=++nchip;(ops[i]!=ADD_EK_CURR_OP)&&
								(ops[i]!=ADD_NERNST_CURR_OP);i++,j++);
		if (ops[i]==ADD_EK_CURR_OP) j++;
		for(i=++nop;(ops[i]==POS_FLUX_OP)||(ops[i]==NEG_FLUX_OP);i++);
		if (ops[i]!=STORE_CURR_OP) j=0;
		if (strcmp(elm->object->name,"tabchannel") == 0) {
			chip_get_tabchannel(hsolve,elm,nchip,j);
		} else {
			chip_get_channelc3(hsolve,elm,nchip,j);
		}
	}
}

/* straight out of Kernighan and Ritchie, p. 67 */
int Strindex(s,t)
	char	s[],t[];
{
	int 	i,j,k;

	for (i=0; s[i]!='\0'; i++) {
		for (j=i,k=0; t[k]!='\0' && s[j]==t[k]; j++,k++);
		if (t[k]=='\0') return(i);
	}	
	return(-1);
}
