static char rcsid[] = "$Id: h_calc.c,v 1.1 1992/12/11 19:03:08 dhb Exp $";

/*
** $Log: h_calc.c,v $
** Revision 1.1  1992/12/11  19:03:08  dhb
** Initial revision
**
*/

#include "hines_ext.h"
#include "seg_struct.h"
#include "olf_struct.h"

/* This routine uses a large chunk of CPU time, calculating coeffs 
** This version disobeys all rules of object orientedness, taking
** over all the calculations that should be done by the compartments */

do_hcalc(hsolve)
	Hsolve	*hsolve;
{
	int	nvalues = hsolve->nvalues;
	int	ncompts = hsolve->ncompts;
	double *values;
	int		*cip,*ri,*diag,*elmnum,*parents;
	struct compartment_type	*compt,*link,**compts;
	struct tab_channel_type *h;
	Cinfo **hh,*hentry,**chan,*centry;
	struct channelA_type *ch; /* basic channel */
	register int		i,j;
	double	*flux;
	int		k;
	int		comptindex,linkindex;
	int		nextcip;
	double	*results;
	double	dt,sumgchan,ichan,diagterm,tbyc;
	float Rm,Ra,Em;
	double Vm;

	values = hsolve->values;
	results = hsolve->results;
	cip = hsolve->cip;
	ri = hsolve->ri;
	diag = hsolve->diag;
	elmnum = hsolve->elmnum;
	parents = hsolve->parents;
	compts = (struct compartment_type **)hsolve->compts;
	hh = hsolve->hh;
    chan = hsolve->chan;
	flux = hsolve->flux;

	if (hsolve->object->method == CRANK_INT)
		dt = Clockrate(hsolve)/2.0;
	else /* BEULER by default */
		dt = Clockrate(hsolve);
	
	for(i=0;i<ncompts;i++) {
		comptindex=elmnum[i];
		compt = compts[comptindex];
		Vm = compt->Vm; /* perhaps */
		Em = compt->Em; /* perhaps */
		Rm = compt->Rm; /* definitely */
		Ra = compt->Ra; /* definitely */
		tbyc=dt/compt->Cm;

        /* Calculating contribution due to tabchannels */
        ichan=sumgchan=0.0;
        for(hentry=hh[i];hentry;hentry=hentry->next){
            h=(struct tab_channel_type *)(hentry->chan);
            sumgchan+=h->Gk;
            ichan+=h->Ek*h->Gk;
			if(hentry->flux_scale != 0.0) {
				flux[i] += h->Ik * hentry->flux_scale;
			}
        }
        /* Calculating contribution due to other channels */
        for(centry=chan[i];centry;centry=centry->next){
            ch=(struct channelA_type *)(centry->chan);
            sumgchan+=ch->Gk;
            ichan+=ch->Ek*ch->Gk;
			if(centry->flux_scale != 0.0) {
				flux[i] += ch->Ik * centry->flux_scale;
			}
        }

		results[i]=Vm+tbyc*(compt->inject+Em/Rm+ichan);
		diagterm = tbyc*sumgchan;

		nextcip=cip[i+1];
		for(j=cip[i];j<nextcip;j++){
			/* finding the column number */
			k=ri[j];
			/* Diagonal element */
			if (i==k) {
				diagterm += 1.0 + tbyc/Rm;
			} else {
				linkindex=elmnum[k];
				link=compts[linkindex];
				/* Child elements */
				if (parents[linkindex]==comptindex) {
					diagterm -= (values[j]= -tbyc/link->Ra);
				/* parent element */
				} else if (parents[comptindex] == linkindex) {
					diagterm -= (values[j]= -tbyc/Ra);
				/* Siblings */
				} else {
					fprintf(stderr,"Warning : Sibling coeffs only occur for symcompartments\n");
				}
			}
		}
		values[diag[i]]=diagterm;
	}
}

do_chip_hcalc(hsolve)
	Hsolve	*hsolve;
{
	int	nvalues = hsolve->nvalues;
	int	ncompts = hsolve->ncompts;
	register double *vm,*values;
	int	 *cip,*ri,*diag,*elmnum,*parents;
    Compinfo *comps,*comp;
	struct channelA_type *ch; /* basic channel */
	register int i,j,k;
	register int comptindex;
	register double	dt,diagterm,tbyc;

	values = hsolve->values;
	cip = hsolve->cip;
	ri = hsolve->ri;
	diag = hsolve->diag;
	elmnum = hsolve->elmnum;
	parents = hsolve->parents;
    comps=hsolve->comps;
	vm = hsolve->vm;

	if (hsolve->object->method == CRANK_INT)
		dt = hsolve->dt/2.0;
	else /* BEULER by default */
		dt = hsolve->dt;
	
	for(i=0;i<ncompts;i++) {
		comptindex=elmnum[i];
        comp=comps + i;
		tbyc=comp->tbiCm;

		diagterm = tbyc*comp->sumgchan;

		for(j=cip[i];j<cip[i+1];j++){
			/* finding the column number */
			k=ri[j];
			/* Diagonal element */
			if (i==k) {
				diagterm += comp->tbiRm;
			} else {
				/* Child elements */
				if (parents[elmnum[k]]==comptindex) {
					diagterm -= (values[j]= -tbyc*(comps[k]).iRa);
				/* parent element */
				} else {
					diagterm -= (values[j]= -tbyc*comp->iRa);
				}
			}
		}
		values[diag[i]]=diagterm;
	}
}

