static char rcsid[] = "$Id: conc_update.c,v 1.1 1992/12/11 19:03:07 dhb Exp $";

/*
** $Log: conc_update.c,v $
** Revision 1.1  1992/12/11  19:03:07  dhb
** Initial revision
**
*/

#include "hines_ext.h"
#include "seg_struct.h"
#include "olf_struct.h"
#include "dev_struct.h"

/* This file contains the routines for updating the coeffs of the 
** Ca_concen, Ca_shell and nernst objects if chanmode < 2. 
** These routines are non-object-oriented. 
*/ 

do_conc_update(hsolve)
	Hsolve	*hsolve;
{
	int		*elmnum;
	struct Ca_shell_type **concen;
	struct Ca_shell_type *c;
	double	*flux;
	struct nernst_type **nernst;
	struct nernst_type *n;
    int     ncompts;
	int		nmsg;
	int		*nmsgs;
	int		i;
	double  dt;
	double  tby2;
	double	C;
	double  temp;

/* compute Ca_concen and Ca_shell elements */
    ncompts = hsolve->ncompts;
	concen = (struct Ca_shell_type **)hsolve->concens;
	flux = hsolve->flux;
	dt = Clockrate(hsolve);
	tby2 = dt/2.0;
	
	for(i=0;i<ncompts;i++) {
		if (!(c=concen[i]))
			continue;
		/* At present trapezoidal integration for concens */
		temp=1.0+tby2/c->tau;
		C=c->C=(c->C*(2.0-temp)+dt*(c->B*flux[i]))/temp;
		c->Ca=c->Ca_base+C;
		flux[i]=0.0;		/* clear for next step */
	}

/* compute nernst elements */
	if(!(nmsg=hsolve->usenernst))
		return;
	nernst = (struct nernst_type **)hsolve->nernsts;
	nmsgs = hsolve->nernstmsg;
	for(i=0;i<ncompts;i++) {
		if (!(n=nernst[i]))
			continue;
		if ((nmsg == 3) || ((nmsg == 1) && nmsgs[i])) {
			/* concen is the src of a COUT msg */
			C=n->Cout=concen[i]->Ca;
			n->E=n->constant*log(C/n->Cin);
		} else {
			/* concen is the src of a CIN msg */
			C=n->Cin=concen[i]->Ca;
			n->E=n->constant*log(n->Cout/C);
		}
	}
}


