static char rcsid[] = "$Id: compt_update.c,v 1.1 1992/12/11 19:03:06 dhb Exp $";

/*
** $Log: compt_update.c,v $
** Revision 1.1  1992/12/11  19:03:06  dhb
** Initial revision
**
*/

#include "hines_ext.h"
#include "seg_struct.h"
#include "olf_struct.h"


/* Simple function for putting data values back into elements */
do_compt_update(hsolve)
	Hsolve	*hsolve;
{
	int i;
	struct compartment_type **compts;
	int ncompts = hsolve->ncompts;
	int	*elmnum;
	double *results;
	double *v;

	compts = (struct compartment_type **)(hsolve->compts);
	elmnum = hsolve->elmnum;
	results = hsolve->results;

	if (hsolve->object->method == CRANK_INT) {
		for(i=0;i<ncompts;i++) {
			v = &(compts[elmnum[i]]->Vm);
			*v = 2.0*results[i]-(*v);
		}
	} else { /* BEULER by default */
		for(i=0;i<ncompts;i++) {
			compts[elmnum[i]]->Vm = results[i];
		}
	}
}


/* Simple function for putting data values back into elements,
** when the chip array is being used */
do_chip_update(hsolve)
	Hsolve	*hsolve;
{
	int i;
	struct compartment_type **compts,*compt;
	struct Ca_shell_type **concens;
	int ncompts = hsolve->ncompts;
	int	*elmnum;
	double	*results;
	double	*vm,*co;

	elmnum = hsolve->elmnum;
	results = hsolve->results;
	vm = hsolve->vm;

	if (hsolve->chanmode==2) {
	/* update all comp values */
		compts = (struct compartment_type **)(hsolve->compts);
		if (hsolve->object->method == CRANK_INT) {
			for(i=0;i<ncompts;i++) {
				compts[elmnum[i]]->Vm = vm[i] = 2.0*results[i]-vm[i];
			}
		} else { /* BEULER by default */
			for(i=0;i<ncompts;i++) {
				compts[elmnum[i]]->Vm = vm[i] = results[i];
			}
		}
	} else {
	/* chanmode == 3 */
		if (hsolve->object->method == CRANK_INT) {
			for(i=0;i<ncompts;i++) {
				vm[i] = 2.0*results[i]-vm[i];
			}
		} else { /* BEULER by default */
			for(i=0;i<ncompts;i++) {
				vm[i] = results[i];
			}
		}
	}
}
