static char rcsid[] = "$Id: nernst.c,v 1.1 1992/12/11 19:02:51 dhb Exp $";

/*
** $Log: nernst.c,v $
** Revision 1.1  1992/12/11  19:02:51  dhb
** Initial revision
**
*/

#include "dev_ext.h"
#define GAS_CONSTANT	1.9872			/* cal/mol deg */
#define FARADAY		23061			/* cal/volt mol */
#define ZERO_CELSIUS	273.15			/* deg */
#define R_OVER_F	8.6171458e-5		/* volt/deg */

/*
** calculates ionic equilibrium potential based on the concentration of
** a single type of ion
** E is calculated in Volts
** scale is in units of voltage conversion
** T has units of degrees Celsius
*/
/* 3/89 Matt Wilson */
Nernst(nernst,action)
register struct nernst_type *nernst;
Action		*action;
{
MsgIn 	*msg;

    if(debug > 1){
	ActionHeader("Nernst",nernst,action);
    }
    SELECT_ACTION(action){
    case PROCESS:
	MSGLOOP(nernst,msg){
	    case 0:		/* intracellular ionic concentration */
		nernst->Cin = MSGVALUE(msg,0);
		break;
	    case 1:		/* extracellular ionic concentration */
		nernst->Cout = MSGVALUE(msg,0);
		break;
	    case 2:		/* temperature in degrees Celsius */
		nernst->T = MSGVALUE(msg,0);
		/* recalculate the constant */
		nernst->constant = nernst->scale*R_OVER_F*
		(nernst->T + ZERO_CELSIUS)/nernst->valency;
		break;
	}
	/*
	** E = constant*ln([out]/[in])
	** constant = RT/zF
	*/
	nernst->E = nernst->constant*log(nernst->Cout/nernst->Cin);
	break;
    case RESET:
	MSGLOOP(nernst,msg){
	    case 0:		/* intracellular ionic concentration */
		nernst->Cin = MSGVALUE(msg,0);
		break;
	    case 1:		/* extracellular ionic concentration */
		nernst->Cout = MSGVALUE(msg,0);
		break;
	    case 2:		/* temperature in degrees Celsius */
		nernst->T = MSGVALUE(msg,0);
		break;
	}
	nernst->constant = nernst->scale*R_OVER_F*
	(nernst->T + ZERO_CELSIUS)/nernst->valency;
	nernst->E = nernst->constant*log(nernst->Cout/nernst->Cin);
	break;
    case CHECK:
	MSGLOOP(nernst,msg){
	    case 0:		/* intracellular ionic concentration */
		nernst->Cin = MSGVALUE(msg,0);
		break;
	    case 1:		/* extracellular ionic concentration */
		nernst->Cout = MSGVALUE(msg,0);
		break;
	}
	if(nernst->valency == 0){
	    ErrorMessage("Nernst", "Invalid ionic valency z.", nernst);
	}
	if(nernst->Cin == 0){
	    ErrorMessage("Nernst", "Invalid intracellular ionic concentration.",
	    nernst);
	}
	if(nernst->Cout == 0){
	    ErrorMessage("Nernst", "Invalid extracellular ionic concentration.",
	    nernst);
	}
	if(nernst->scale <= 0){
	    ErrorMessage("Nernst", "Invalid scale parameter.", nernst);
	}
	break;
    }
}
