//genesis
//
// $Id: devlib.g,v 1.1 1992/12/11 19:02:56 dhb Exp $
// $Log: devlib.g,v $
// Revision 1.1  1992/12/11  19:02:56  dhb
// Initial revision
//

//genesis
newclass	device
newclass	channel
/*
******************************************************************************
**                           Device OBJECT TABLE                            **
******************************************************************************
*/
//============================================================================
//	name		data		function	class		
//============================================================================

object	diffamp		diffamp_type	DifferenceAmp	device	\
	-author 	"M.Wilson Caltech 2/89" \
	-actions	RESET PROCESS \
	-messages	PLUS 0		1 +input \
			MINUS 1		1 -input \
			GAIN 2		1 gain \
	-fields		gain saturation plus minus output \
	-description	"difference amplifier takes two inputs and" \
			"produces an output proportional to their difference"

object	efield		efield_type ExtracellularRecordingElectrode device \
	-author 	"M.Wilson Caltech 2/89" \
	-actions	RESET PROCESS RECALC \
	-messages	CURRENT 0	2 current 0.0 \
	-fields		scale field \
	-description	"sums current sources according to their" \
			"inverse distance from the recording electrode" \
			"to produce an estimate of the field potential" \
			"at that point."

object	expthresh	expthresh_type ExpThresh device \
	-author 	"M.Wilson Caltech 8/89" \
	-actions	RESET PROCESS CHECK \
	-messages	BUFFER 0	1 name \
	-fields		theta_s theta_0 tau_theta 

object	freq_monitor	freq_mon_type	FrequencyMonitor	device	\
	-author 	"M.Wilson Caltech 2/89" \
	-actions	RESET PROCESS *CREATE BufferCreate \
	-messages	NONZERO_TRIG 	0	1 input \
			ZERO_TRIG 	1	1 input \
			POSITIVE_TRIG 	2	1 input \
			NEGATIVE_TRIG 	3	1 input \
			WINDOW 		4	1 time \
			CONTINUOUS 	5	1 input \
	-fields		exponent tmin \
	-description	"Calculates running event (spike) frequency" \
			"over a given time window using exponential weighting."

object	nernst		nernst_type Nernst  device channel \
	-author 	"M.Wilson Caltech 3/89" \
	-actions 	PROCESS RESET CHECK \
	-messages	CIN 0		1 Cin \
			COUT 1		1 Cout \
			TEMP 2		1 T \
	-fields		"E = equilibrium potential" \
			"T = temperature in degrees celsius"  \
			"valency = ionic valency z"  \
			"scale = voltage scale factor"  \
	-description	"Calculates the Nernst potential for the given" \
			"ionic concentrations and temperature." \
			"E = scale*(RT/zF)*ln(Cout/Cin)" \
			"A scale factor of 1 gives E in volts." \
			"A scale factor of 1e3 gives E in millivolts."

object	funcgen		funcgen_type	FunctionGenerator	device	\
	-author 	"M.Wilson Caltech 4/89" \
	-actions	RESET PROCESS CHECK \
	-messages	AMPLITUDE 	0		1 amplitude \
			DC_OFFSET 	1		1 dc_offset \
			PHASE 		2		1 phase \
			FREQUENCY 	3		1 frequency \
	-fields		"mode  0=sine; 1=square; 2=triangle; 3=constant" \
			"amplitude dc_offset phase frequency" \
	-description	"function generator produces periodic output" \
			"with a waveform set by the mode field"

object  peristim  peristim_type  PeriStimulusDistribution  device  \
	-author     "E. De Schutter Caltech 8/91" \
	-actions    RESET PROCESS CHECK \
	-messages   INPUT   0       1 voltage \ // trigger_mode = FREE_RUN
				TRIGGER 1       1 trigger \ // trigger_mode = TRIGGERED
				SPIKE   2       1 time \ // trigger_mode = SPIKES
	-fields     "output: is the current bin" \
				"threshold  binwidth  num_bins: determine ps distribution" \
				"trigger_mode: free running (0) or triggered (1)" \
				"reset_mode: if 1 then bins will be emptied upon RESET," \
				"            if 2 then new table will be made upon RESET" \
	-description "generates on line a peristimulus spike histogram, will loop" \
				"through all the bins and then start again in the first" \
				"bin if the simulation continues (FREE_RUN) or unless " \
				"triggered. SPIKES-mode is used to generate under script" \
				"control (clock is NOT used)."

object  interspike  interspike_type  InterSpikeInterval  device  \
	-author     "E. De Schutter Caltech 8/91" \
	-actions    RESET PROCESS CHECK \
	-messages   INPUT   0       1 voltage \ // trigger_mode = FREE_RUN
				TRIGGER 1       1 trigger \ // trigger_mode = TRIGGERED
				SPIKE   2       1 time \ // trigger_mode = SPIKES
	-fields     "output: is the last isi" \
				"threshold  binwidth  num_bins: determine distribution" \
				"reset_mode: if 1 then bins will be emptied upon RESET" \
	-description "generates on line a interspike interval histogram. The" \
				"last bin contains also all values larger than the bin-range."

/*
** GENESIS complains about an invalid data type. [DHB]

object  clock   clock_output_type   ClockOutput     output  \
    -author     "D.Bilitch Caltech 10/91" \
    -actions    CREATE DELETE PROCESS RESET \
    -fields     x y w h \
    -description    "displays an X11 window with current simulation time"
*/

/*
** The NewFrequency function is not found in the symbol table. [DHB]

object  frequency  new_frequency_type  NewFrequency  device  \
	-author     "E. De Schutter Caltech 11/91" \
	-actions    RESET PROCESS CHECK \
	-messages   INPUT   0       1 voltage \
	-fields     "frequency: is the output" \
				"threshold: detects spike" \
				"num_spikes: number of spikes over which freq. is averaged" \
	-description "generates continuous firing frequency measurement." 
*/
