static char rcsid[] = "$Id: taupump.c,v 1.1 1992/12/11 19:02:42 dhb Exp $";

/*
** $Log: taupump.c,v $
** Revision 1.1  1992/12/11  19:02:42  dhb
** Initial revision
**
*/

#include "conc_ext.h"

/* Implementation of a simple pump with a variable time constant 
**  of removal.  Should be coupled to a difpool, were the changes 
**  in concentration is computed. */

/* 1/91 Erik De Schutter */
/* 5/92 EDS, added T_C field: a constant offset for tau */

TauPump(pump,action)
register struct taupump_type *pump;
Action		*action;
{
double	tau,dt;
MsgIn 	*msg;
int		nv = 0;

    if(debug > 1){
	ActionHeader("TauPump",pump,action);
    }

    SELECT_ACTION(action){
    case INIT:
	break;

    case PROCESS:
	dt = Clockrate(pump);
	
	/* Read the msgs to get the membrane voltage */
	/* Tau = T_A * exp ((v-T_V)/T_B) + T_C 
	** kP = 1/Tau */
	MSGLOOP(pump,msg){
		case 0:		/* voltage, or any other parameter to compute tau*/
					/* 0 = Vm */
		tau = pump->T_A*exp((MSGVALUE(msg,0)-pump->T_V)/pump->T_B)+pump->T_C;
		break;
	}
	pump->kP = 1.0/tau;
	break;

    case RESET:
	/* backward compatibility: if T_C is not set, use T_A as default value
	** for tau */
	if (pump->T_C < 1e-20) {
		tau = pump->T_A;
	} else {
		tau = pump->T_C;
	}
	/* check all the messages to the pump and calculate tau */
	MSGLOOP(pump,msg){
		case 1:		/* voltage, or any other parameter to compute tau*/
					/* 0 = Vm */
		tau = pump->T_A*exp((MSGVALUE(msg,0)-pump->T_V)/pump->T_B)+pump->T_C;
		break;
	}
	pump->kP = 1.0/tau;
	break;
    
	case CHECK:
	if(pump->Ceq < 0.0)
	    ErrorMessage("TauPump", "Invalid Ceq.", pump);
	if(pump->T_A <= 0.0)
	    ErrorMessage("TauPump", "Invalid T_A.", pump);
	MSGLOOP(pump,msg){
		case 1:		/* only one voltage signal allowed! */
		nv += 1;
		break;
	}
	if(nv > 1)
	    ErrorMessage("TauPump", "Too many VOLTAGE msg.", pump);
	if((nv==1)&&(pump->T_B == 0.0))
	    ErrorMessage("TauPump", "Invalid T_B.", pump);
	break;
    }
}

