static char rcsid[] = "$Id: poolbuf.c,v 1.1 1992/12/11 19:02:41 dhb Exp $";

/*
** $Log: poolbuf.c,v $
** Revision 1.1  1992/12/11  19:02:41  dhb
** Initial revision
**
*/

#include "conc_ext.h"

/* Implementation of a first-order buffer system.  Should be 
**	coupled to a difpool, were theange in the [buffered ion]
**  is computed. */

/* 1/91 Erik De Schutter */

PoolBuffer(buffer,action)
register struct poolbuffer_type *buffer;
Action		*action;
{
double	A,B;		/* integrate dBfree/dt = A - B*Bfree */
double	BfNew;
double	dt;
MsgIn 	*msg;
double	savedata[2];
int		nc = 0;

    if(debug > 1){
	ActionHeader("PoolBuffer",buffer,action);
    }

    SELECT_ACTION(action){
    case INIT:
	buffer->previous_state = buffer->Bfree;
	break;

    case PROCESS:
	dt = Clockrate(buffer);

	/* Read the msgs to get the difpool concentration */
	MSGLOOP(buffer,msg){
		case 0:		/* concentration */
				/* 0 = Co */
		buffer->activation = MSGVALUE(msg,0); /* Co */
		break;
	}
	/* dBfree/dt = -kBf.Co.Bfree + kBb(Btot - Bfree) 
	** A  = kBb * Btot
	** B = kBf * Co + kBb */
	A = buffer->kBb * buffer->Btot;
	B = buffer->kBf * buffer->activation + buffer->kBb;
	buffer->Bfree = IntegrateMethod(buffer->object->method,buffer,
				buffer->Bfree,A,B,dt,"Bfree");
	break;

    case RESET:
	/* check all the messages to the pump */
	MSGLOOP(buffer,msg){
		case 0:		/* concentration */
				/* 0 = Co */
		buffer->activation = MSGVALUE(msg,0); /* Co */
		break;
	}
	/* calculate the steady state of the free buffer */
	buffer->Bfree = buffer->Btot / (1.0 + buffer->activation *
					(buffer->kBf / buffer->kBb));
	break;
    
	case CHECK:
	if(buffer->Btot <= 0.0)
	    ErrorMessage("PoolBuffer", "Invalid Btot.", buffer);
	if(buffer->kBf <= 0.0)
	    ErrorMessage("PoolBuffer", "Invalid kBf.", buffer);
	if(buffer->kBb <= 0.0)
	    ErrorMessage("PoolBuffer", "Invalid kBb.", buffer);
	MSGLOOP(buffer,msg){
		case 0:	/* only one concentration signal allowed! */
		nc += 1;
		break;
	}
	if(nc > 1)
	    ErrorMessage("PoolBuffer", "Too many CONCEN msg.", buffer);
	break;
    
	case SAVE2:
	savedata[0] = buffer->Bfree;
	savedata[1] = buffer->previous_state;
	/* action->data contains the file pointer */
	fwrite(savedata,sizeof(double),2,action->data);
	break;

    case RESTORE2:
	/* action->data contains the file pointer */
	fread(savedata,sizeof(double),2,action->data);
	buffer->Bfree = savedata[0];
	buffer->previous_state = savedata[1];
	break;
	}
}

