//genesis
//
// $Id: conclib.g,v 1.1 1992/12/11 19:02:46 dhb Exp $
// $Log: conclib.g,v $
// Revision 1.1  1992/12/11  19:02:46  dhb
// Initial revision
//

// genesis

/*
************************************************************************
**                    CONCENTRATION  SHELL COMMANDS                    **
************************************************************************
*/

/*
*************************************************************************
**                              OBJECT TABLE                           **
*************************************************************************
*/

//==========================================================================
//	name		data            function	class	
//==========================================================================

object	difpool	difpool_type	DifPool		segment	concentration \
	-author	  "E. De Schutter Caltech 11/90" \
	-actions  INIT PROCESS RESET CHECK SAVE2 RESTORE2 \
	-messages FLOW	  0  1	dCo \	/* type 0: constant flow */
		  INJECT  1  2	Zk Ik \/* type 1: charge, current in A*/
		  DIFFUSE 2  3	Len Vol Co \ /* type 2: diffusion*/
		  BUFFER  3  4	kBf kBb Btot Bfree \ /* type 3: buffer*/
		  PUMP    4  2  kP  Ceq \ /* type 4: pump */
	-fields	"Co = concentration (integrated) in mM" \
		"Cmin = minimum concentration in mM" \
		"D = diffusion constant in m^2/s" \
		"Len = length of pool in m" \
		"Vol = volume of pool in m^3" \
	-description "Concentration pool.  Has constant flow, ionic" \
		"current flow, one-dimensional diffusion, first order" \
		"buffering and pumps." \
		"The INJECT message assumes SI units for the Faraday " \
		"constant (mM, m, m^3, A), if not scale Zk.  It assumes" \
		"that Ik has the correct sign (positive for an increase)," \
		"else change the sign of Zk." \
		"The Len field is along the axis of diffusion.  difpool" \
		"makes assumptions about the shape of the pool: Vol has" \
		"to be a linear function of Len."

object	taupump	taupump_type	TauPump		segment	concentration \
	-author	  "E. De Schutter Caltech 11/90" \
	-actions   INIT PROCESS RESET CHECK \
	-messages  VOLTAGE 0  1	 Vm \	/* type 0: voltage */
	-fields	"kP = pump rate=inverse of tau in s" \
		"Ceq = equilibrium concentration in mM" \
		"T_A = factor for Tau" \
		"T_B = exp factor for Tau" \
		"T_C = constant offset for Tau" \
		"T_V = half-voltage for Tau" \
	-description "Pump with variable time constant, tau is" \
		"fixed to T_C (or to T_A if T_C==0) if no VOLTAGE msg is sent." 
	
object	poolbuffer poolbuffer_type  PoolBuffer	segment	concentration \
	-author	  "E. De Schutter Caltech 11/90" \
	-actions  INIT PROCESS RESET CHECK SAVE2 RESTORE2 \
	-messages CONCEN  0  1	Co  \   /* type 0: [buffered ion] */
	-fields	"Bfree = free buffer concentration (integrated) in mM" \
		"Btot = total buffer concentration (free+bound) in mM" \
		"kBf = forward rate constant in 1/mM.s" \
		"kBb = backward rate constant in 1/s" \
	-description "First order buffer."
