static char rcsid[] = "$Id: statebuf.c,v 1.1 1992/10/28 22:29:41 dhb Exp $";

/*
** $Log: statebuf.c,v $
 * Revision 1.1  1992/10/28  22:29:41  dhb
 * Initial revision
 *
*/

#include "buf_ext.h"

int	DEBUG_StateEvent = 0;

/* 
** StateEvent
** 
** place the state into the buffer
*/

/* 6/88 Matt Wilson */
StateEvent(buffer,action)
register struct state_type 	*buffer;
Action			*action;
{

    if(Debug(DEBUG_StateEvent) > 1){
	ActionHeader("StateEvent",buffer,action);
    }
    SELECT_ACTION(action){
    case RESET:
	ClearBuffer(buffer);
	break;
    case PROCESS:
	/*
	** just use the buffer state as its output
	*/
	if(buffer->msg_in){
	    buffer->state = MsgValue(buffer->msg_in,double,0);
	}
	PutEvent(buffer, buffer->state, NULL, WRAP);
	break;
    case CHECK:
	if(!buffer->msg_in){
	    ErrorMessage("StateEvent","Input is required.",buffer);
	}
	break;
    case CREATE:
	buffer->event_size = sizeof(struct event_type);
	return(1);
	break;
    case COPY:
	BufferCopy(buffer,action);
	break;
    default:
	InvalidAction("StateEvent",buffer,action);
	break;
    }
}

