static char rcsid[] = "$Id: nodelay.c,v 1.1 1992/12/11 19:02:27 dhb Exp $";

/*
** $Log: nodelay.c,v $
** Revision 1.1  1992/12/11  19:02:27  dhb
** Initial revision
**
*/

#include "axon_ext.h"

int	DEBUG_NoDelayConnection = 0;

/*
** performs event distribution along absolute connections with
** no latency, no delay, and single clock duration
*/
NoDelayConnection(projection,action)
Projection	*projection;
Action		*action;
{
register Connection		*connection;
Buffer		*buffer;
Event		*event;
PFI		connection_func;
MsgIn		*msg;

    if(Debug(DEBUG_NoDelayConnection) > 1){
	ActionHeader("NoDelayConnection",projection,action);
    }

    SELECT_ACTION(action){
    case RESET:
    case RECALC:
	buffer = NULL;
	MSGLOOP(projection,msg){
	    case 0:			/* buffer */
		buffer = (Buffer *)MSGPTR(msg,0);
		break;
	}
#ifdef FLOATTIME
	if(buffer){
	    /*
	    ** if the duration is 0 then use dt instead
	    */
	    if(buffer->tmin < Clockrate(projection)){
		buffer->tmin = Clockrate(projection);
	    }
	}
#endif
	break;
    case PROCESS:
	if(projection->connection == NULL) return;
	/*
	** get the buffer to be used from the msg
	*/
	MSGLOOP(projection,msg){
	    case 0:			/* buffer */
		buffer = (Buffer *)MSGPTR(msg,0);
		break;
	}
	/*
	** check to see if there is anything in the buffer
	*/
	if(!buffer || (buffer->current == buffer->start)){
	    /*
	    ** there isnt so return
	    */
	    return;
	}

	/*
	** get the connection function
	** and check its validity
	*/
	if((connection_func = projection->connection_object->function) == NULL){
	    Error();
	    printf("no connection func for '%s'.\n",
	    Pathname(projection));
	    return;
	}

	/*
	** get the buffer event
	*/
	event = buffer->event + buffer->current;
	/*
	** loop through all the connections
	*/
	for(connection=projection->connection;connection;
	connection=connection->next){
	    /*
	    ** call the connection function
	    */
#ifdef FLOATTIME
	    connection_func(
		connection,
		action,
		projection,
		event,
		0.0);
#else
	    connection_func(projection,connection,PROCESS,0,event);
#endif
	}
	break;
    default:
	InvalidAction("NoDelayConnection",projection,action);
	break;
    }
}

