
// genesis
// tut_forms.g
// Forms for SQUID Tutorial help display, using  the ximage widget for
// display of GIF files and the xtext widget for scrolling of text files
//
// This also creates additional widgets which are not in squid_forms.g
//
str XREV
//XREV = "R3"	
// global variable for setting width of text display from X11 revision #
// "R4" will be assumed if it is not explicitly set to "R3"
//
/* NOTE: 
The version of the function "textwindow" provided in the March 1991 GENESIS
distribution xtools.g creates a form 490 pixels wide and 336 pixels high at
x,y to display the specified text file with scrolling and paging.  The
actual text window is 484 x 316 pixels.  Using the default font for X11R3,
this provides room for 24 lines with 78 characters per line and a one
character right and left margin.  (The left margin is provided
automatically.)  X11R4 uses a larger font for both the xtext widget and the
xlabel widget, however.  In addition, it provides a scroll bar with the
xtext widget.  Thus, in order to accomodate the same number of charaters, a
form width of 580 pixels should be used.  The following replacement for
"textwindow" uses an optional argument "XREV" to determine the proper width
and also allows the size of the text window to be resized along with the
parent form.  If this argument is not specified, the larger width
appropriate to X11R4 is used.  When displaying X11R4 windows on a DECstation
with its large fonts, an even wider width of 810 should be used.  This can
either be changed below, or the window may be rescaled after it appears.
*/

//=====================================================================
// textwindow(formpath,x,y,textfile,[XREV])
// creates a form 490 pixels wide and 336 pixels high at x,y to display
// the specified text file with scrolling and paging
//=====================================================================
function textwindow(formpath,x,y,textfile)
   str formpath,textfile,XREV
   int x,y, width, height
   height = 336
   XREV   = "R4"
   width  = 580  // the default width will be the large one for X11 R4 fonts
   if (argc > 4) // look for a 5th argument
	XREV = $5
   end
// if not explicitly R3, play it safe and use larger R4 width
   if ({XREV} == "R3")
	width  = 490 // for X11R3 fonts
   end
   create xform {formpath} [{x},{y},{width},{height}] -nolabel
   push {formpath}
   create xlabel textbar [40,0,{100*(width-40)/width}%,20] -title \
       "b/f - back/forward by page | j/k - by line | a/z - begin/end"
   create xbutton DONE [0,0,40,20] -script "xhide "{formpath}
   create xtext text [0%,20,100%,94%] -file {textfile}
   pop
end

//=====================================================================
// makegif(formpath,x,y,image_width,image_height,gif_file,title)
// Creates a form to display a GIF file with label and "DONE" button
// The form will have width=image_width+10 and height=image_height+25
//=====================================================================
function makegif(formpath,x,y,image_width,image_height,gif_file,title)
   str formpath,gif_file,title
   int x,y,image_width,image_height
   create xform {formpath} [{x},{y},{image_width+10},{image_height+25}] \
       -nolabel
   create xlabel {formpath}"/titlebar" [5,0,{image_width},20] \
       -title {title}
   create xbutton {formpath}"/DONE" [15,3,80,15] -script "xhide "{formpath}
   create ximage {formpath}"/image" [5,20,{image_width},{image_height}]
   set ^ wx {image_width} wy {image_height} filename {gif_file}
end
//-------------------------------------------------------------------------

// toggle the display of phase plot
function phasetoggle
  if (get(/forms/popups/phasetoggle,state) == 1)
      xshow_on_top /output/phase_plot
  else
      xhide /output/phase_plot
  end
end

//===================================================================
//  Toggle blocking (disabling) of a channel by setting value of gbar
//===================================================================
function blocking_toggle(compartment,channel,widget)
    str compartment,channel,widget
    float length = {get(-env,{compartment},length)}
    float diameter = {get(-env,{compartment},diameter)}
    float area = 1e-8*length*PI*diameter        // cm^2
    if(get({widget},state) == 1)
        set {compartment}/{channel} gbar 0
        echo {channel}" channel blocked"
    else		// reset gbar to the proper value
	if ({channel}=="Na")
	    set {compartment}/{channel} gbar {GNa_squid*area}
	else		// assume it is the K channel
            set {compartment}/{channel} gbar {GK_squid*area}
	end
	echo {channel}" channel unblocked"
    end
    squid_reset
end

function add_squid_popups
   str screens="/forms/helpscreens"
   create neutral {screens}
   textwindow({screens}/running,55,225,squid.text)
   create xform /forms/popups [100,580,275,145] -nolabel
   push /forms/popups
   create xbutton running [5,5,265,30] -title "HELP" \
        -script "xshow_on_top "{screens}"/running"
   create xtoggle phasetoggle [5,40,265,30] -title "" \
	-script phasetoggle
   set phasetoggle label0 "Phase Plot Hidden"
   set phasetoggle label1 "Phase Plot Visible" state 0

   create xtoggle Na_block [5,75,265,30] -title "" \
           -script "blocking_toggle /axon Na <widget>"
   set Na_block label0 "Na channel unblocked" label1 "Na channel blocked"
   set Na_block state 0

   create xtoggle K_block [5,110,265,30] -title "" \
           -script "blocking_toggle /axon K <widget>"
   set K_block label0 "K channel unblocked" label1 "K channel blocked" state 0

   pop
   xshow /forms/popups
end
