// genesis

function add_squid_forms
    push

    //-------------------------
    // SIMULATION CONTROL FORM
    //-------------------------

    create neutral /forms
    disable /forms
    ce /forms

    create xform /forms/control [400,580,275,200] \
	-title "Simulation control"
    ce /forms/control

    create xbutton reset [ 10, 45, 60, 25] \
	-title "RESET" -script "squid_reset"
    create xbutton run [ 75, 45, 60, 25] \
	-title "RUN" -script "squid_step"
    create xbutton stop [ 140, 45, 60, 25] \
	-title "STOP" -script "stop"
    create xbutton quit  [205, 45, 60, 25] \
	-title "QUIT" -script "quit"

    create xdialog tstep [ 10, 80,255, 25] -value 15.0 \
	-title "time (msec)" -script "set_step" 
    create xdialog dt    [ 10,110,255, 25] -value 0.020\
	-title "dt (msec)" -script "set_dt"
    create xbutton clamp_mode [10,140,255,25] \
	-title "Toggle Vclamp/Iclamp Mode" \
	-script "toggle_clamp_mode"
    create xtoggle overlay [10,170,255,25] -title "" \
	-script "toggle_overlay "<widget>
    set overlay label0 "Overlay OFF" label1 "Overlay ON" state 0

// The iclamp form now has a "Base Current Level" and
// the vclamp form has a Pre-pulse level and time
    //-------------------------
    // CURRENT CLAMP FORM
    //-------------------------

    create xform /forms/iclamp [700,580,275,190] \
    	-title "Current Clamp Mode"
    ce /forms/iclamp

    create xdialog baselevel [ 10, 40, 255, 25] -value 0.0 \
	-title "Base Current Level (uA)" \
	-script "dset /pulsegen baselevel "<widget>
    create xdialog level [ 10, 70, 255, 25] -value 0.1 \
	-title "Pulsed Current Level (uA)" \
	-script "dset /pulsegen level1 "<widget>
    create xdialog delay [ 10, 100, 255, 25] -value 5 \
	-title "Onset Delay (msec)" \
	-script "dset /pulsegen delay1 "<widget>
    create xdialog width [ 10, 130, 255, 25] -value 40 \
	-title "Pulse Width (msec)" \
	-script "dset /pulsegen width1 "<widget>
    create xdialog interval [ 10, 160, 255, 25] -value 50 \
	-title "Pulse Interval (msec)" \
	-script "set_pulse_interval /pulsegen "<widget>

    //-------------------------
    // VOLTAGE CLAMP FORM
    //-------------------------

    create xform /forms/vclamp [700,580,275,220] \
    	-title "Voltage Clamp Mode"
    ce /forms/vclamp

    create xdialog vhold [ 10, 40, 255, 25] -value 0.0 \
	-title "Holding Voltage (mV)" \
	-script "dset /pulsegen baselevel "<widget>
    create xdialog thold [ 10, 70, 255, 25] -value 2 \
	-title "Holding Time (msec)" \
	-script "dset /pulsegen delay1 "<widget> 

    create xdialog vpre [ 10, 100, 255, 25] -value 0.0 \
	-title "Pre-pulse Voltage (mV)" \
	-script "dset /pulsegen level1 "<widget> 
    create xdialog tpre [ 10, 130, 255, 25] -value 0.0 \
	-title "Pre-pulse Time (msec)" \
	-script "set_tpre /pulsegen "<widget> 

    create xdialog vclamp [ 10, 160, 255, 25] -value 50 \
	-title "Clamp Voltage (mV)" \
	-script "dset /pulsegen level2 "<widget> 
    create xdialog tclamp [ 10, 190, 255, 25] -value 20 \
	-title "Clamp Time (msec)" \
	-script "set_tclamp /pulsegen "<widget> 

    //-------------------------
    // GRAPH SCALE FORM
    //-------------------------

    create xform /forms/gscale [300,100,220,220] \
	-title "Graph Scale"
    ce /forms/gscale

    create xdialog xmin [10,  45, 200, 25] -value "???" \
	-script "gset xmin "<widget>
    create xdialog xmax [10,  80, 200, 25] -value "???" \
	-script "gset xmax "<widget>
    create xdialog ymin [10, 115, 200, 25] -value "???" \
	-script "gset ymin "<widget>
    create xdialog ymax [10, 150, 200, 25] -value "???" \
	-script "gset ymax "<widget>
    create xdialog overlay [10,185, 200, 25] -value "???" \
	-script "gset overlay "<widget>
    create xbutton DONE [10, 10, 50, 15] \
	-script "xhide /forms/gscale"

    //----------------------------------------
    // INITIALIZE SOME ENVIRONMENT VARIABLES
    //----------------------------------------

    set -env /forms/gscale gpath "???"
    set -env /forms/control clamp_mode "vclamp"

    pop
end

function set_step
    float  tstep
    tstep = get(/forms/control/tstep, value)
    echo next step will be for {tstep} msec
end

function set_dt
    float dt
    dt = get(/forms/control/dt,value)
    echo dt = {dt} msec
    setclock 0 {dt}
end

function squid_step
    int nstep
    float dt, tstep
    xsendevent /forms/control/tstep click1
    tstep = get(/forms/control/tstep,value)
    xsendevent /forms/control/dt click1
    dt = get(/forms/control/dt,value)
    nstep = tstep/dt
    if(nstep > 100000)
	echo I don't think you really want to do {nstep} steps
    else
	step {nstep}
    end
end

function squid_reset
    // temporary solution (hack) to 
    // accomplish reset scheduling

    reset 

    call /axon RESET
    set /axon Vm 0

    call /axon/Na/m RESET
    call /axon/Na/h RESET
    call /axon/Na   RESET

    call /axon/K/n  RESET
    call /axon/K    RESET
    // additional code added by D. Beeman to adjust Vleak when channels
    // are disabled
    float IK = {get(/axon/K,Ik)}
    float INa = {get(/axon/Na,Ik)}
    float Rm = {get(/axon,Rm)}
    set /axon Em {-1.0*Rm*(IK + INa)}
end


function toggle_clamp_mode
    str mode, dbut, graph
    mode = get(-env,/forms/control,clamp_mode)
    if(mode == "iclamp")
	// toggle to voltage clamp
	xhide /forms/iclamp
	xshow /forms/vclamp
	set -env /forms/control clamp_mode "vclamp"

        set /forms/control/tstep value 15 
	set /forms/control/dt    value 0.01
	foreach graph ({EL(/axon/##[TYPE=xgraph])})
	    set {graph} xmax 15
	end

	// injection current graph needs to be rescaled
	set /axon/graphs/inj ymin -10 ymax 10


	//set-up electronics for voltage clamp
	set /Iclamp gain 0
	set /Vclamp gain 1
	set /PID gain    0.5 
	foreach dbut ({EL(/forms/vclamp/#)})
	    xsendevent {dbut} click1
	end
    else
	// toggle to current clamp
	xhide /forms/vclamp
	xshow /forms/iclamp
	set -env /forms/control clamp_mode "iclamp"

        set /forms/control/tstep value 50
	set /forms/control/dt    value 0.1
	foreach graph ({EL(/axon/##[TYPE=xgraph])})
	    set {graph} xmax 50
	end

	// injection current graph needs to be rescaled
	set /axon/graphs/inj ymin -0.5 ymax 0.5


	//set-up electronics for current clamp
	set /Iclamp gain 1
	set /Vclamp gain 0
	set /PID    gain 0
	// restore pulsgen fields set in vclamp mode
	set /pulsegen width2 0.0
	set /pulsegen level2 0.0
	foreach dbut ({EL(/forms/iclamp/#)})
	    xsendevent {dbut} click1
	end
    end
end

function dset(path, field, dialog)
    float val
    val = get({dialog}, value)
    echo Setting {path} {field} {val}
    set {path} {field} {val}
end

function gset(field, dialog)
    str path
    float val
    path = get(-env,/forms/gscale,gpath)
    val = get({dialog}, value)
    echo Setting {path} {field} {val}
    set {path} {field} {val}
end

function set_pulse_interval(path,dialog)
    float interval, delay1,delay2
    interval = get({dialog}, value)
    delay1 = get({path},delay1)
    delay2 = interval - delay1
    echo Setting {path} delay2 {delay2}
    set {path} delay2 {delay2}
end

function set_tpre(path,dialog)
    float width1
    width1 = get({dialog}, value)  // Pre-pulse time
    echo Setting delay2 {width1}
    echo Setting {path} width1 {width1}
    set {path} delay2 {width1}
    set {path} width1 {width1}
end

function set_tclamp(path,dialog)
    float width1, width2
    width2 = get({dialog}, value)
    width1 = get({path},width1)
    echo Setting delay2 {width1}
    echo Setting {path} width2 {width2}
    set {path} delay2 {width1}
    set {path} width2 {width2}
end

function toggle_overlay(widget)
    str overlay = {get({widget},state)}
    set /##[TYPE=xgraph] overlay {overlay}
end
