// genesis
function add_squid_electronics
    //
    // Electronics for voltage and current clamp 
    //
    create pulsegen /pulsegen
    set ^ level1 25.0 \
	  width1 50.0 \
	  delay1  2.0 \
	  delay2 999.0

// changed time constant from 0.1 msec to 0.03 msec for sharper Vclamp pulse
    create RC /lowpass
    set ^ R 1.0 C 0.03

    create diffamp /Iclamp
    set ^ saturation 999.0 \
	  gain 0.0

    create diffamp /Vclamp
    set ^ saturation 999.0 \
	  gain 0.0

    create PID /PID
    set ^ gain  0.50  \
	  tau_i 0.02 \
	  tau_d 0.005 \
	  saturation 999.0
end


function connect_squid_electronics(path)
    str path
    //
    // hook up current clamp circuitry
    //
    sendmsg /pulsegen	/Iclamp		PLUS	output
    sendmsg /Iclamp	{path}		INJECT	output

    //
    // hook up voltage clamp circuitry
    //
    sendmsg /pulsegen	/lowpass	INJECT	output
    sendmsg /lowpass	/Vclamp	PLUS	state
    sendmsg /Vclamp	/PID		CMD	output
    sendmsg {path}	/PID		SNS	Vm
    sendmsg /PID	{path}		INJECT  output
end
