//genesis - phsplot.g - Adds phase plots to the SQUID tutorial

//==============================================================
// functions to determine what will be plotted and set the scales
//==============================================================
function testvar(plotvar)
    int testvar
    str plotvar
    if (({plotvar}=="n")||({plotvar}=="m")||({plotvar}=="h")||({plotvar}=="V"))
        return 1
    else
        echo "Unrecognized variable for phase plot: "{plotvar}
        return 0
    end
end

function new_plot
    push /output/phase_plot
    str xvar = substring({get(xplot,value)},0,0)
    str yvar = substring({get(yplot,value)},0,0)
    if ({xvar}=="v")	//  also allow lower case for "V"
	xvar = "V"
    end
    if ({yvar}=="v")
        yvar = "V"
    end
    if (({testvar({xvar})}&{testvar({yvar})})==0)  //test for valid variables
        pop
        return	// with error message if variables are invalid
    end
    deletemsg(phase_grf,IN,1)
    deletemsg(phase_grf,IN,0)
    if ({yvar}=="V")		// First message plots y-axis
      set phase_grf ymin -20 ymax 120 YUnits "Vm (mV)"
      sendmsg /axon /output/phase_plot/phase_grf PLOT Vm *phase *black
    else
      set phase_grf ymin 0 ymax 1 YUnits {yvar}
      if ({yvar}=="n")
        sendmsg /axon/K/n /output/phase_plot/phase_grf PLOT m *phase *black
      else
        sendmsg /axon/Na/{yvar} /output/phase_plot/phase_grf PLOT m *phase *black
      end
    end
    if ({xvar}=="V")		// Second message plots x-axis
      set phase_grf xmin -20 xmax 120 XUnits "Vm (mV)"
      sendmsg /axon /output/phase_plot/phase_grf PLOT Vm *plot *black
    else
      set phase_grf xmin 0 xmax 1 XUnits {xvar}
      if ({xvar}=="n")
        sendmsg /axon/K/n /output/phase_plot/phase_grf PLOT m *plot *black
      else
        sendmsg /axon/Na/{xvar} /output/phase_plot/phase_grf PLOT m *plot *black
      end
    end
    pop
    squid_reset
end

//==============================================================
// function to create the form and initial graph for phase plots
//==============================================================
function add_squid_phaseplot
    create xform /output/phase_plot [555,10,480,550] -nolabel
    push /output/phase_plot
    create xgraph phase_grf [0,0,480,300] \
    	-title "Phase Plot"
    set phase_grf xmin -20 xmax 120 ymin 0 ymax 1 phase_plot 1
    set phase_grf XUnits "Vm (mV)" YUnits "n"
    useclock phase_grf 1 // change this?

    create xlabel allowed_vars [3,305,474,25] \
      -title "Allowed variables for plotting are n, m, h, V"
    create xdialog xplot [3,330,235,25] -title "x-axis:" -value "V" \
    	-script new_plot
    create xdialog yplot [242,330,235,25] -title "y-axis:" -value "n" \
    	-script new_plot
// also put in a graph for activation parameters vs time
    create xgraph act_grf [0,360,480,190] \
	-title "H-H activation parameters vs time"
    set act_grf xmax 50 ymax 1 XUnits "t (msec)" YUnits ""
    useclock act_grf 1
// should later add scale button and rescale x-axis for voltage clamp
    pop

    sendmsg /axon/K/n /output/phase_plot/phase_grf PLOT m *phase *black
    sendmsg /axon /output/phase_plot/phase_grf PLOT Vm *plot *black
    sendmsg /axon/Na/m /output/phase_plot/act_grf PLOT m *m *black
    sendmsg /axon/Na/h /output/phase_plot/act_grf PLOT m *h *red
    sendmsg /axon/K/n /output/phase_plot/act_grf PLOT m *n *blue
    squid_reset
end
