// genesis

int y = -1
float y_f = 0.0


function mode
	
	if({get(/menu/draw/mode,state)}==1)
		if({exists(/playback)} == 0)
			create neutral /playback
		end
		deactivate
	else
		delete /playback
		y_f = 0.0
		y = -1
		create neutral /playback
		activate
	end
end

create neutral /playback

str directory = ""


function cont_sim
	setclock 0 {get(/x_interface/simulate/step_size,value)}
	setclock 1 {get(/x_interface/simulate/out_step,value)}
	echo START TIME:
	echo | date
	step -t {get(/x_interface/simulate/sim_dur,value)}	
	echo END TIME:
	echo | date
end


function start_sim
str el, file, parm_path
	
	if({get(/menu/draw/mode,state)}!=1)
		if(directory != {get(/x_interface/simulate/directory,value)})
			directory = {get(/x_interface/simulate/directory,value)}
			mkdir {directory}
			push /output
			set soma_Vm filename {directory}/soma_Vm
			set Ia_Vm filename {directory}/Ia_Vm
			set supIb_Vm filename {directory}/supIb_Vm
			set deepIb_Vm filename {directory}/deepIb_Vm
			set III_Vm filename {directory}/III_Vm
			set fb_Vm filename {directory}/fb_Vm
			set ff_Vm filename {directory}/ff_Vm
			set pyr_gAff filename {directory}/pyr_gAff
			set pyr_gRA filename {directory}/pyr_gRA
			set pyr_gCA filename {directory}/pyr_gCA
			set pyr_gLocal filename {directory}/pyr_gLocal
			set pyr_gFB filename {directory}/pyr_gFB
			set pyr_gFF filename {directory}/pyr_gFF
			set soma_Im filename {directory}/soma_Im
			set Ia_Im filename {directory}/Ia_Im
			set supIb_Im filename {directory}/supIb_Im
			set deepIb_Im filename {directory}/deepIb_Im
			set III_Im filename {directory}/III_Im
			set efield_Ia_Na filename {directory}/efield_Ia_Na
			set efield_Ia_K filename {directory}/efield_Ia_K
			set efield_supIb filename {directory}/efield_supIb
			set efield_deepIb filename {directory}/efield_deepIb
			set efield_soma filename {directory}/efield_soma
			set efield_III filename {directory}/efield_III
			set efield_total filename {directory}/efield_total
			pop 
			parm_path = {directory} + "/parms"
			openfile {parm_path} w
			push /x_interface
			writefile {parm_path} {get(Aff_syn/wt_bulb_Ia,value)}
			writefile {parm_path} {get(Aff_syn/Na,value)}
			writefile {parm_path} {get(ff_syn/wt_ff_Ia,value)}
			writefile {parm_path} {get(ff_syn/K,value)}
			writefile {parm_path} {get(CA_syn/wt_CA_pyr,value)}
			writefile {parm_path} {get(CA_syn/Na,value)}
			writefile {parm_path} {get(RA_syn/wt_pyr_RA,value)}
			writefile {parm_path} {get(RA_syn/Na,value)}
			writefile {parm_path} {get(fb_syn/wt_fb_pyr,value)}
			writefile {parm_path} {get(fb_syn/Cl,value)}
			writefile {parm_path} {get(LOCAL_syn/wt_pyr_local,value)}
			writefile {parm_path} {get(LOCAL_syn/Na,value)}
			writefile {parm_path} {get(Aff_ff_syn/wt_Aff_ff,value)}
			writefile {parm_path} {get(fb_ff_syn/wt_pyr_ff,value)}
			writefile {parm_path} {get(pyr_fb_syn/wt_pyr_fb,value)}
			writefile {parm_path} {get(Aff_fb_syn/wt_Aff_fb,value)}
			closefile {parm_path}
			cont_sim
		else
			echo "Directory" {directory} "already exists."
		end
	else
		xshow /x_interface/not_sim
		echo "NOT IN SIMULATE MODE"
	end
end

int flag = 0
function sim_stat

	if(flag)
		delete /x_interface/sim_stat/steps
	else
		create xform /x_interface/sim_stat [18,230,205,145]
		create xdialog /x_interface/sim_stat/num_steps \ 
			-title "number of steps" -value \
			{get(/x_interface/simulate/sim_dur,value)}
	
		create xbutton /x_interface/sim_stat/cancel [5,110,190,30] \
			-title "cancel" -script "xhide /x_interface/sim_stat"
	end
	create xdialog /x_interface/sim_stat/steps [5,73,190,30] \ 
			-title "steps completed" \ 
			-value {status(-time) + .1}
	xshow /x_interface/sim_stat
	flag = 1

end


function set_parameters
str el

	foreach el ({EL(/pyr/pyramidal[]/soma/Cl_channel)})
		set {el} tau2 {get(/x_interface/fb_syn/Cl,value)}
	end
	foreach el ({EL(/pyr/pyramidal[]/soma/Ia_dend/Aff_Na_channel)})
		set {el} tau2 {get(/x_interface/Aff_syn/Na,value)}
	end
	foreach el ({EL(/pyr/pyramidal[]/soma/supIb_dend/CA_Na_channel)})
		set {el} tau2 {get(/x_interface/CA_syn/Na,value)}
	end
	foreach el ({EL(/pyr/pyramidal[]/soma/deepIb_dend/RA_Na_channel)})
		set {el} tau2 {get(/x_interface/RA_syn/Na,value)}
	end
	foreach el ({EL(/pyr/pyramidal[]/soma/Ia_dend/K_channel)})
		set {el} tau2 {get(/x_interface/ff_syn/K,value)}
	end
	foreach el ({EL(/pyr/pyramidal[]/soma/III_dend/Local_Na_channel)})
		set {el} tau2 {get(/x_interface/LOCAL_syn/Na,value)}
	end
	echo Channel Open Times Adjusted
	
	adjust_wts {get(/x_interface/RA_syn/wt_pyr_RA,value)}  \
	  	{get(/x_interface/CA_syn/wt_CA_pyr,value)}  \
	  	{get(/x_interface/fb_syn/wt_fb_pyr,value)}  \
	  	0.0 \
	  	{get(/x_interface/ff_syn/wt_ff_Ia,value)} \
	  	{get(/x_interface/Aff_syn/wt_bulb_Ia,value)} \
	  	{get(/x_interface/Aff_ff_syn/wt_Aff_ff,value)} \
	  	{get(/x_interface/Aff_fb_syn/wt_Aff_fb,value)} \	
	  	{get(/x_interface/pyr_fb_syn/wt_pyr_fb,value)} \
	  	{get(/x_interface/fb_ff_syn/wt_pyr_ff,value)} \
      		{get(/x_interface/LOCAL_syn/wt_pyr_local,value)}  
			
end	

function run_playback
str file

	if({get(/menu/draw/mode,state)}==1)
		file = {get(/x_interface/playback/dir,value)} + "/parms"
		openfile {file} r
		set /x_interface/Aff_syn/wt_bulb_Ia value {readfile({file})}
		set /x_interface/Aff_syn/Na value {readfile({file})}
		set /x_interface/ff_syn/wt_ff_Ia value {readfile({file})}
		set /x_interface/ff_syn/K value {readfile({file})}
		set /x_interface/CA_syn/wt_CA_pyr value {readfile({file})}
		set /x_interface/CA_syn/Na value {readfile({file})}
		set /x_interface/RA_syn/wt_pyr_RA value {readfile({file})}
		set /x_interface/RA_syn/Na value {readfile({file})}
		set /x_interface/fb_syn/wt_fb_pyr value {readfile({file})}
		set /x_interface/fb_syn/Cl value {readfile({file})}
		set /x_interface/LOCAL_syn/wt_pyr_local value {readfile({file})}
		set /x_interface/LOCAL_syn/Na value {readfile({file})}
		set /x_interface/Aff_ff_syn/wt_Aff_ff value {readfile({file})}
		set /x_interface/fb_ff_syn/wt_pyr_ff value {readfile({file})}
		set /x_interface/pyr_fb_syn/wt_pyr_fb value {readfile({file})}
		set /x_interface/Aff_fb_syn/wt_Aff_fb value {readfile({file})}
		closefile {file}
		setclock 0 {get(/x_interface/playback/step_size,value)}
		step -t {get(/x_interface/playback/step_num,value)}
	else
		xshow /x_interface/not_play
		echo "NOT IN PLAYBACK MODE"
	end
end

create compartment /library/comp


function not_exists(path)

	if(!{exists({path})})
		return 1
	else
		echo {path} already exists
		return 0
	end
end


function map (parameter,pyr_ny)

	createmap /library/comp map_{parameter} {PYR_NX} {pyr_ny} {PYR_DX} {PYR_DY}
end

function position
	if(y == 3)
		y = 0
	else
		y = y + 1
	end
end

function dk_in(filename)
	str filename
	str directory

	directory = {get(/x_interface/playback/dir,value)}
	create disk_in dk_{filename}.{directory}
       	enable	^  
        set ^    \
		filename        {directory}/{filename}	\
               	fileformat      1    	\
                leave_open      1       	
	reset
end


function create_xview(parameter,segment,offset,increment)
float offset, increment
     	create xview net_{parameter}/draw/{segment} -path \
		map_{segment}/comp[]  \
		-field Em -autoscale TRUE \
		-vmin -90 -vmax 100  -ox -4.6 -oy {offset + increment}
end


function create_xform(parameter,y_scale)
int pos_x, pos_y
float scale,scaled
str directory

	pos_x	= 885
	pos_y	= y * 195 
	create xform net_{parameter} [{pos_x},{pos_y},280,170]
	create xdraw net_{parameter}/draw [2%,35,96%,98%]  -wx 11 -wy {y_scale}
	scaled = {(-2.6 * y_scale) / 10}
	create xshape net_{parameter}/draw/rostral -tx -3.7 -ty {scaled} -text "rostral"
	create xshape net_{parameter}/draw/caudal -tx 3.7 -ty {scaled} -text "caudal" 
	create xbutton net_{parameter}/cancel [80%,20%,20%,10%] \
		-title "cancel"	\
		-script "delete "/playback/net_{parameter}

end


function net_view(flag,parameter)
	str el, parameter, el_name
	int flag, k

	el_name = {parameter} + "." + {get(/x_interface/playback/dir,value)}
	if(!flag)
		delete /playback/{el_name}
	else
		if({not_exists(/playback/net_{el_name})})
			create neutral /playback/net_{el_name}
			ce ^
			dk_in {parameter}
			k = 0
			map {el_name} {PYR_NY} 
			foreach el ({EL(map_{el_name}/comp[])})
				sendmsg dk_{el_name}   {el} EREST val[0][{k}]
				k = k + 1
			end  
			position
			create_xform {el_name} 10
			create_xview {el_name} {el_name} -1.75 0
	     		xshow net_{el_name}
		end
	end
end


function side_play(el,i) 
int row, k
str comp_el

	directory = {get(/x_interface/playback/dir,value)}
	row = {get(/x_interface/full_cell_view/row,value)}	
	k = {row*15}
	dk_in {el}
	map {el} 1 
	foreach comp_el ({EL(map_{el}/comp[])})
		sendmsg dk_{el}.{directory} {comp_el} EREST val[0][{k}]
		k = k + 1
	end
end


function side_view(flag)
	str directory, el, parameter, comp_el
	int flag, k, i, row

	parameter = {get(/x_interface/full_cell_view/parameter,value)}
	directory = {get(/x_interface/playback/dir,value)}
	row = {get(/x_interface/full_cell_view/row,value)}
	if((row > 0) && (row < 10))
		if(!flag)
			delete /playback/side_{parameter}_{row}.{directory}
		else
			if({not_exists(/playback/side_{parameter}_{row}.{directory})})
				create neutral /playback/net_side_{parameter}_{row}.{directory}
				ce ^
				position
				create_xform side_{parameter}_{row}.{directory} 6.1
				i = 0
				if({parameter}=="Vm")
					foreach el (III_Vm soma_Vm deepIb_Vm \
							supIb_Vm Ia_Vm)
						i = i + 1
						side_play {el} {i}
						create_xview side_{parameter}_{row}.{directory} \
						 		{el} -1.6 {i*.69} 
								
					end
				end
				if({parameter}=="Im")
					foreach el (III_Im soma_Im deepIb_Vm \
							supIb_Vm Ia_Vm)
						i = i + 1
						side_play {el} {i}
						create_xview side_{parameter}_{row}.{directory} \
								 {el} -1.6 {i*.69}
					end
				end
				if({parameter}=="Gk")
					foreach el (pyr_gLocal pyr_gFB pyr_gCA \
							pyr_gRA pyr_gFF pyr_gAff) 
						i = i + 1
						side_play {el} {i}
						create_xview side_{parameter}_{row}.{directory} \
								 {el} -1.6 {i*.69}
					end
				end
			end
		end
	else
		echo "INVALID ROW NUMBER, VALID ROW NUMBERS: 1-9"
	end
	xshow net_side_{parameter}_{row}.{directory}
end


function layer(path,plot_name,filename)
str path, plot_name, filename, directory

str el
int k

	directory = {get(/x_interface/playback/dir,value)}
	dk_in {filename}
	k = 0
	foreach el ({EL({path})})
		sendmsg dk_{filename}.{directory} pseudo_{plot_name} CURRENT val[0][{k}] 0.0
		k = k + 1
	end
end


function scale_graph(path)
str path
	
	set {path} \
		xmin {get({path}/scale/xmin,value)}	\
		xmax {get({path}/scale/xmax,value)}	\	
		ymin {get({path}/scale/ymin,value)}	\
		ymax {get({path}/scale/ymax,value)}
end



function make_xplot(plot_name,xmin,xmax,ymin,ymax,y_unit)
str plot_name, y_unit
float xmin, xmax, ymin, ymax

float y_pos

	y_pos = y_f * 195  
	y_f = y_f + 1.0
	if(y_f == 4)
		y_f = 0
	end

	create xform form [518,{y_pos},367,170]
	create xgraph form/graph -title {plot_name} [0,35,500,230]
		set ^	x 0 y 0 width 109% height 100% 	\
			xmin 0 ymin {ymin} \
			xmax {get(/x_interface/playback/step_num,value)}  \ 
			ymax {ymax} XUnits msec YUnits {y_unit}

// If the next two lines puzzle you, don't worry.  This is a hack done to
// insure that the xgraph's size corresponds to the xform.  As XODUS is
// improved these hacks will no longer be necessary.

	set form width 375 height 170
	set form/graph xmax {xmax}

	push form/graph

		create xform scale [518,{y_pos},100,170]
		create xdialog scale/xmin -title "xmin" -value {xmin} 
		create xdialog scale/xmax -title "xmax" -value {xmax}
		create xdialog scale/ymin -title "ymin" -value {ymin}
		create xdialog scale/ymax -title "ymax" -value {ymax}
		create xbutton scale/apply -title "apply" -script \
		   "scale_graph "/playback/{plot_name}/form/graph" " <widget>
		create xbutton scale/cancel -title "cancel" -script \
		   "xhide "/playback/{plot_name}/form/graph/scale" " <widget>

	pop

	create xbutton form/scale_on [0%,0%,10%,10%] -title "scale" -script \
		"xshow "/playback/{plot_name}/form/graph/scale" " <widget>
	create xbutton form/cancel [90%,0%,10%,10%] -title "cancel" -script \
		"delete "/playback/{plot_name}" " <widget>
	xshow form

	sendmsg pseudo_{plot_name} form/graph PLOT field *curvename *black

end


function pseudo_field(plot_name,avg)
str plot_name
float avg

	create efield pseudo_{plot_name}	
		set ^	\
			x  1 y 0 z 0	\
			scale	{avg}

end


function field_view(flag)
	str el, plot_name, short_x, directory
	int flag
	float avg, y_pos, k

	
	directory = {get(/x_interface/playback/dir,value)}
	plot_name = "field"
	short_x = "/x_interface/field_pot"
	foreach el ({EL({short_x}/#[TYPE=xtoggle])})
		if({get({el},state)}==1)
			plot_name = {plot_name} + "_" + {get({el},title)} 
		end
	end
	plot_name = {plot_name} + "_" + {directory}

	if(flag == 2)
		plot_name = "field_eeg" + "_" + {directory}
	end
	if(!flag)
		delete /playback/{plot_name}
	else
		if({not_exists(/playback/{plot_name})})
			create neutral /playback/{plot_name}
			ce /playback/{plot_name}
			k = 0.0
			foreach el ({EL(/field/efield_soma[])})
				k = k + 1.0
			end 		
			avg = 1.0/{k}
			pseudo_field {plot_name} {avg}

			if(flag == 2)
				layer /field/efield_total[] {plot_name}  \
					efield_total
			else
				if({get({short_x}/Ia_Na,state)}==1)
					layer /field/efield_Ia_Na[] {plot_name} efield_Ia_Na 
				end
				if({get({short_x}/Ia_K,state)}==1)
					layer /field/efield_Ia_K[] {plot_name} efield_Ia_K 
				end
				if({get({short_x}/supIb,state)}==1)
					layer /field/efield_supIb[] {plot_name} \
						efield_supIb 
				end
				if({get({short_x}/deepIb,state)}==1)
					layer /field/efield_deepIb[] {plot_name} \
						efield_deepIb 
				end
				if({get({short_x}/soma,state)}==1)
					layer /field/efield_soma[] {plot_name} \
						efield_soma 
				end
				if({get({short_x}/III,state)}==1)
					layer /field/efield_III[] {plot_name} \
						efield_III 
				end
			end

			make_xplot {plot_name} 0 1000 -500 100 mV	
		end
	end
end


function conduct_view(flag,short_chan)
int flag
str short_chan

str el, chan, short_x, plot_name, directory
float avg, k

	directory = {get(/x_interface/playback/dir,value)}
	plot_name = "conductance_" + {short_chan} + "." + {directory}
	short_x = "/x_interface/conduct"

	if(!flag)
		delete /playback/{plot_name}
	else
		if({not_exists(/playback/{plot_name})})
			create neutral /playback/{plot_name}
			ce ^
	
			if(short_chan == "pyr_gAff")
				chan = "Ia_dend/Aff_Na_channel"
			end
			if(short_chan == "pyr_gFF")
				chan = "Ia_dend/K_channel"
			end
			if(short_chan == "pyr_gCA")
				chan = "supIb_dend/CA_Na_channel"
			end
			if(short_chan == "pyr_gRA")
				chan = "deepIb_dend/RA_Na_channel"
			end
			if(short_chan == "pyr_gFB")
				chan = "Cl_channel"
			end
			if(short_chan == "pyr_gLocal")
				chan = "III_dend/Local_Na_channel"
			end

			k = 0.0 
			foreach el ({EL(/pyr/pyramidal[]/soma/{chan})})
				k = k + 1.0
			end
			avg = 1.0/{k}

			pseudo_field {plot_name} {avg}

 			layer /pyr/pyramidal[]/soma/{chan} {plot_name} \
				{short_chan} 
			make_xplot {plot_name} 0 500 -1.0e-03  1.0e-03 mS
		end
	end
end


function spike_view(flag,cell)
int flag
str cell

str el, cell, plot_name, short_x, file, directory
int k
float avg

	directory = {get(/x_interface/playback/dir,value)}
	plot_name = "spike_activity_" + {cell} + "_" + {directory}
	short_x = "/x_interface/playback/spike"

	if(!flag)
		delete /playback/{plot_name}
	else
		if({not_exists(/playback/{plot_name})})
			create neutral /playback/{plot_name}
			ce ^
			if(cell == "pyr")
				file = "soma_Vm"
			end
			if(cell == "fb")
				file = "fb_Vm"
			end
			if(cell == "ff")
				file = "ff_Vm"
			end
			
			k = 0
			foreach el ({EL(/pyr/pyramidal[])})
				copy /library/spike pseudo_spike[{k}]	
				set pseudo_spike[{k}] output_amp 1
				k = k + 1
			end
			avg = 1.0/{k}
		
			pseudo_field {plot_name} 1.0
	
			dk_in {file}
			k = 0
			foreach el ({EL(/pyr/pyramidal[])})
				sendmsg dk_{file}.{directory} pseudo_spike[{k}] INPUT \
						val[0][{k}]
				sendmsg pseudo_spike[{k}] pseudo_{plot_name} \
						CURRENT state 0.0
				k = k + 1
			end
			make_xplot {plot_name} 0 500 0.0  135  spike/cell
		end		
	end
end

	
function time
        set /x_interface/playback/clock  value  {status(-time) + .1}
end

function get_current_time
        create script_out   /x_interface/playback/clock/script_clock
        set ^ command    "time"
end
