// genesis

echo "******Setting up XODUS Interface******"

create neutral /x_interface

ce ^
create xform not_sim [200,250,200,20] -title "NOT IN SIMULATE MODE"
create xbutton not_sim/cancel -title "cancel" -script "xhide /x_interface/not_sim"
create xform not_play [200,250,200,20] -title "NOT IN PLAYBACK MODE"
create xbutton not_play/cancel -title "cancel" -script "xhide /x_interface/not_play"


// Make xform containing info about running simulation

create xform /x_interface/simulate [30,577,300,20]
ce ^
create xdialog step_size -title "step size (msec)" -value "0.1"
create xdialog sim_dur -title "simulation duration (msec)" -value "500"
create xdialog directory -title "data directory name" -value "data"
create xdialog out_step -title "output rate (msec)" -value "1.0"
create xbutton reset -title "reset" -script "reset"
create xbutton run -title "start simulation" -script start_sim
create xbutton continue -title "continue simulation" -script cont_sim
create xbutton stop -title "stop" -script "stop"
create xbutton sim_stat -title "simulation status" -script sim_stat
create xbutton cancel -title "cancel" -script "xhide /x_interface/simulate"


// Make xform containing info about simulation parameters

create xform /x_interface/parameters [147,50,300,20]
ce ^
create xlabel weights -title "weights"
create xdialog wt_bulb_Ia -title "bulb_Ia" -value "1.0"
create xdialog wt_ff_Ia -title "ff_Ia" -value "1.0"
create xdialog wt_fb_soma -title "fb_soma" -value "1.0"
create xdialog wt_fb_fb -title "fb_fb" -value "1.0"
create xdialog wt_pyr_ff -title "pyr_ff" -value "1.0"
create xdialog wt_pyr_fb -title "pyr_fb" -value "1.0"
create xdialog wt_pyr_RA -title "pyr_RA" -value "1.0"
create xdialog wt_pyr_CA -title "pyr_CA" -value "1.0"
create xdialog wt_pyr_local -title "pyr_LOCAL" -value "1.0"
create xlabel channels -title "synaptic channel open times (msec)"
create xdialog chan_Aff_Na -title "Aff_Na" -value "3.0"
create xdialog chan_RA_Na -title "RA_Na" -value "3.0"
create xdialog chan_CA_Na -title "CA_Na" -value "3.0"
create xdialog chan_K -title "K" -value "100.00"
create xdialog chan_Cl -title "Cl" -value "7.0"
create xlabel label -title "" 
create xbutton apply -title "apply" -script "set_parameters"
create xbutton cancel -title "cancel" -script "xhide /x_interface/parameters"


// forms associated with setting synaptic parameters

create xform /x_interface/Aff_syn [122,103,260,10] -title "bulb to pyr synapse"
ce ^
create xlabel weights -title "synaptic weight"
create xdialog wt_bulb_Ia -title "bulb_Ia" -value "1.0"
create xlabel open_times -title "synaptic channel open times (msec)"
create xdialog Na -title "Na" -value "3.0"
create xbutton apply -title "apply" -script "set_parameters" 
create xbutton cancel -title "cancel" -script "xhide /x_interface/Aff_syn"

create xform /x_interface/ff_syn [122,150,260,10] -title "ff to pyr synapse"
ce ^
create xlabel weights -title "synaptic weight"
create xdialog wt_ff_Ia -title "ff_Ia" -value "1.0"
create xlabel open_times -title "synaptic channel open times (msec)"
create xdialog K -title "K" -value "100.0"
create xbutton apply -title "apply" -script "set_parameters" 
create xbutton cancel -title "cancel" -script "xhide /x_interface/ff_syn"

create xform /x_interface/CA_syn [122,203,260,10] -title "rostral pyr to caudal pyr synapse"
ce ^
create xlabel weights -title "weight"
create xdialog wt_CA_pyr -title "from rostral pyr" -value "1.0"
create xlabel open_times -title "synaptic channel open times (msec)"
create xdialog Na -title "Na" -value "3.0"
create xbutton apply -title "apply" -script "set_parameters"
create xbutton cancel -title "cancel" -script "xhide /x_interface/CA_syn"

create xform /x_interface/RA_syn [213,282,260,10] -title "caudal pyr to rostral pyr synapse"
ce ^
create xlabel weights -title "weight"
create xdialog wt_pyr_RA -title "from caudal pyr" -value "1.0"
create xlabel open_times -title "synaptic channel open times (msec)"
create xdialog Na -title "Na" -value "3.0"
create xbutton apply -title "apply" -script "set_parameters"
create xbutton cancel -title "cancel" -script "xhide /x_interface/RA_syn"

create xform /x_interface/fb_syn [222,348,260,10] -title "fb to pyr synapse"
ce ^
create xlabel weights -title "weight"
create xdialog wt_fb_pyr -title "fb_pyr" -value "1.0"
create xlabel open_times -title "synaptic channel open times (msec)"
create xdialog Cl -title "Cl" -value "7.0"
create xbutton apply -title "apply" -script "set_parameters"
create xbutton cancel -title "cancel" -script "xhide /x_interface/fb_syn"

create xform /x_interface/LOCAL_syn [72,437,260,10] -title "local pyr to pyr synapse"
ce ^
create xlabel weights -title "weight"
create xdialog wt_pyr_local -title "from local pyr" -value "1.0"
create xlabel open_times -title "synaptic channel open times (msec)"
create xdialog Na -title "Na" -value "3.0"
create xbutton apply -title "apply" -script "set_parameters"
create xbutton cancel -title "cancel" -script "xhide /x_interface/LOCAL_syn"

create xform /x_interface/Aff_ff_syn [0,95,260,10] -title "bulb to ff synapse"
ce ^
create xlabel weights -title "weight"
create xdialog wt_Aff_ff -title "Aff_to_ff" -value "1.0"
create xbutton apply -title "apply" -script "set_parameters"
create xbutton cancel -title "cancel" -script "xhide /x_interface/Aff_ff_syn"

create xform /x_interface/fb_ff_syn [0,120,260,10] -title "pyr to ff synapse"
ce ^
create xlabel weights -title "weight"
create xdialog wt_pyr_ff -title "pyr_to_ff" -value "1.0"
create xbutton apply -title "apply" -script "set_parameters"
create xbutton cancel -title "cancel" -script "xhide /x_interface/fb_ff_syn"

create xform /x_interface/pyr_fb_syn [345,445,260,10] -title "pyr to fb synapse"
ce ^
create xlabel weights -title "weight"
create xdialog wt_pyr_fb -title "pyr_to_fb" -value "1.0"
create xbutton apply -title "apply" -script "set_parameters"
create xbutton cancel -title "cancel" -script "xhide /x_interface/pyr_fb_syn"

create xform /x_interface/Aff_fb_syn [325,415,260,10] -title "bulb to fb synapse"
ce ^
create xlabel weights -title "weight"
create xdialog wt_Aff_fb -title "Aff_to_fb" -value "1.0"
create xbutton apply -title "apply" -script "set_parameters"
create xbutton cancel -title "cancel" -script "xhide /x_interface/Aff_fb_syn"


// Make forms associated with network viewing along z-axis

// Form associated with layer Ia

create xform /x_interface/Ia_network [320,220,165,10]
ce ^
create xbutton Vm -title "Vm" -script "net_view 1 Ia_Vm"
create xbutton Im -title "Im" -script "net_view 1 Ia_Im"
create xbutton gNa -title "synaptic conductance (Na)" -script "net_view 1 pyr_gAff"
create xbutton gK -title "synaptic conductance (K)" -script "net_view 1 pyr_gFF"
create xbutton quit -title "cancel" -script "xhide /x_interface/Ia_network"

// Forms associated with supIb, deepIb, III

create xform /x_interface/supIb_network [320,295,165,10]
ce ^ 
create xbutton Vm -title "Vm" -script "net_view 1 supIb_Vm"
create xbutton Im -title "Im" -script "net_view 1 supIb_Im"
create xbutton gchan -title "synaptic conductance (Na)" -script "net_view 1 pyr_gCA"
create xbutton quit -title "cancel" -script "xhide /x_interface/supIb_network"

create xform /x_interface/deepIb_network [320,369,165,10]
ce ^ 
create xbutton Vm -title "Vm" -script "net_view 1 deepIb_Vm"
create xbutton Im -title "Im" -script "net_view 1 deepIb_Im"
create xbutton gchan -title "synaptic conductance (Na)" -script "net_view 1 pyr_gRA"
create xbutton quit -title "cancel" -script "xhide /x_interface/deepIb_network"

create xform /x_interface/III_network [320,520,165,10]
ce ^ 
create xbutton Vm -title "Vm" -script "net_view 1 III_Vm"
create xbutton Im -title "Im" -script "net_view 1 III_Im"
create xbutton gchan -title "synaptic conductance (Na)" -script "net_view 1 pyr_gLocal"
create xbutton quit -title "cancel" -script "xhide /x_interface/III_network"

// Form associated with soma 

create xform /x_interface/soma_network [320,443,165,10]
ce ^ 
create xbutton Vm -title "Vm" -script "net_view 1 soma_Vm"
create xbutton Im -title "Im" -script "net_view 1 soma_Im"
create xbutton gchan -title "synaptic conductance (Cl)" -script "net_view 1 pyr_gFB"
create xbutton quit -title "cancel" -script "xhide /x_interface/soma_network"

// Make form associated with network viewing along y-axis

create xform /x_interface/full_cell_view [230,174,300,20]
ce ^
create xdialog parameter -title "parameter (Vm,Im,Gk)" -value "Vm"
create xdialog row -title "row" -value "5"
create xbutton display -title "display" -script "side_view 1"
create xbutton quit -title "cancel" -script "xhide /x_interface/full_cell_view"

// Forms associated with diffreent layer options

create xform /x_interface/Ia_options [200,125,200,10]
ce ^
create xbutton network_view -title "network view"  \
	-script "xshow /x_interface/Ia_network"
create xbutton conductance_Na -title "synaptic conductance (Na)" 	\
	-script "conduct_view 1 pyr_gAff"
create xbutton conductance_K -title "synaptic conductance (K)" 	\
	-script "conduct_view 1 pyr_gFF"
create xbutton quit -title "cancel" -script "xhide /x_interface/Ia_options"

create xform /x_interface/supIb_options [200,200,200,10]
ce ^
create xbutton network_view -title "network view" \ 
	-script "xshow /x_interface/supIb_network"
create xbutton Na_conductance -title "synaptic conductance (Na)" 	\
	-script "conduct_view 1 pyr_gCA"
create xbutton quit -title "cancel" -script "xhide /x_interface/supIb_options"

create xform /x_interface/deepIb_options [200,275,200,10]
ce ^
create xbutton network_view -title "network view" \ 
	-script "xshow /x_interface/deepIb_network"
create xbutton Na_conductance -title "synaptic conductance (Na)"     \ 	
	-script "conduct_view 1 pyr_gRA"
create xbutton quit -title "cancel" -script "xhide /x_interface/deepIb_options"

create xform /x_interface/soma_options [200,350,200,10]
ce ^
create xbutton network_view -title "network view" \ 
	-script "xshow /x_interface/soma_network"
create xbutton Cl_conductance -title "synaptic conductance (Cl)" 	\
	-script "conduct_view 1 pyr_gFB"
create xbutton quit -title "cancel" -script "xhide /x_interface/soma_options"

create xform /x_interface/III_options [200,425,200,10]
ce ^
create xbutton network_view -title "network view" \ 
	-script "xshow /x_interface/III_network"
create xbutton Na_conductance -title "synaptic conductance (Na)" 	\
	-script "conduct_view 1 pyr_gLocal"
create xbutton quit -title "cancel" -script "xhide /x_interface/III_options"


// Make form associated with field potential viewing

create xform /x_interface/field_pot [230,125,300,20] -title "field potentials"
ce ^
create xlabel synaptic -title "fp's generated by synaptic currents"
create xtoggle Ia_Na -title "Ia_Na"
create xtoggle Ia_K -title "Ia_K"
create xtoggle supIb -title "supIb" 
create xtoggle deepIb -title "deepIb" 
create xtoggle soma -title "soma" 
create xtoggle III -title "III"
create xbutton display -title "display" -script "field_view 1"
create xlabel eeg -title "eeg display"
create xbutton full_eeg -title "eeg" -script "field_view 2" 
create xbutton quit -title "cancel" -script "xhide /x_interface/field_pot"


// Make form containing info about spike count accross network

create xform /x_interface/spike [230,150,300,20]
ce ^
create xlabel cell_type -title "cell type"
create xbutton pyr -title "pyramidal" -script "spike_view 1 pyr"
create xbutton fb -title "feedback inhibitory" -script "spike_view 1 fb"
create xbutton ff -title "feedforward inhibitory" -script "spike_view 1 ff"
create xbutton cancel -title "cancel" -script "xhide /x_interface/spike"


// Make form containing info about playback viewing

create xform /x_interface/playback [150,600,300,20]
ce ^
create xdialog clock -title "clock (msec)" \
	-value {status(-time) + .1}
get_current_time
disable /x_interface/playback/clock
create xdialog step_size -title "playback step size (msec)" -value 2.0
create xdialog step_num -title "playback duration (msec)" -value "500" 
create xdialog dir -title "data directory" -value "data"
create xbutton reset -title "reset" -script "reset"
create xbutton run -title "run" -script run_playback
create xbutton step -title "step" -script "step"
create xbutton stop -title "stop" -script "stop"
create xbutton cancel -title "cancel" -script "xhide /x_interface/playback"


// Make form containing help window

create xform /x_interface/help [540,50,600,830]
ce ^
create xlabel label1 [1%,0%,98%,3%] -title "help"
create xlabel label2 [1%,3%,98%,3%] -title "Left and right buttons move up and down; double clicks move a page at a time"
create xtext text [1%,55,98%,85%] -file README
create xbutton legend -title "legend" -script "xshow /menu/legend"
create xbutton cancel -title "cancel" -script "xhide /x_interface/help"


// Make form containing quit options

create xform /x_interface/quit [400,600,300,20] -title "Do you wish to quit?"
ce ^
create xbutton yes -title "yes" -script "quit"
create xbutton no -title "no" -script "xhide /x_interface/quit"
