//genesis
create neutral /library 
disable /library

//========================================================================
//                              CHANNELS   
//========================================================================
create		channelC2	/library/Na_channel
    set	        /library/Na_channel \
	Ek		{EKA} \
	tau1		{1.0*SCALE}       \       // { 2.0 * SCALE } \	// msec
	tau2		{3.0*SCALE}       //{ 2.0 * SCALE } 	// msec
create		channelC2	/library/K_channel
    set	        /library/K_channel \
	Ek		{ EK } \
	tau1		{10.0*SCALE}      \ //{ 2.0 * SCALE } \	// msec
	tau2		{ 100.0 * SCALE }       //{ 100.0 * SCALE } 	// msec
create		channelC2	/library/Cl_channel
    set	        /library/Cl_channel \
	Ek		{ECL} \
	tau1		{1.0*SCALE}       \       //{ 2.0 * SCALE } \	// msec
	tau2		{7.0*SCALE}       //{ 18.0 * SCALE } 	// msec

//========================================================================
//                        ACTIVE NA CHANNEL
//========================================================================
create		hh_channel	/library/HH_Na_channel
set /library/HH_Na_channel \
	Ek 		{ENA} \			// mV
	Gbar		{ 120.0e-8 * PYR_SOMA_A } \	// mS
	Xpower		3.0 \
	Ypower		1.0 \   
	X_alpha_FORM	{LINOID} \
	X_alpha_A	-0.1 \				// 1/mV-msec
	X_alpha_B	-10.0 \				// mV
	X_alpha_V0	{ 25.0 + PYR_EREST_ABS } \	// mV
	X_beta_FORM	{EXPONENTIAL} \
	X_beta_A	4.0 \				// 1/msec
	X_beta_B	-18.0 \				// mV
	X_beta_V0	{ 0.0 + PYR_EREST_ABS } \	// mV
	Y_alpha_FORM	{EXPONENTIAL} \
	Y_alpha_A	0.07 \				// 1/msec
	Y_alpha_B	-20.0 \				// mV
	Y_alpha_V0	{ 0.0 + PYR_EREST_ABS } \	// mV
	Y_beta_FORM	{SIGMOID} \
	Y_beta_A	1.0 \				// 1/msec
	Y_beta_B	-10.0 \				// mV
	Y_beta_V0	{ 30.0 + PYR_EREST_ABS } 	// mV

//========================================================================
//                        ACTIVE K CHANNEL
//========================================================================
create		hh_channel	/library/HH_K_channel
    set /library/HH_K_channel \
	Ek 		{EK} \			// mV
	Gbar		{36.0e-8*PYR_SOMA_A} \		// mS
	Xpower		4.0 \
	Ypower		0.0 \   
	X_alpha_FORM	{LINOID} \
	X_alpha_A	-0.01 \				// 1/mV-msec
	X_alpha_B	-10.0 \				// mV
	X_alpha_V0	{10.0+PYR_EREST_ABS} \		// mV
	X_beta_FORM	{EXPONENTIAL} \
	X_beta_A	0.125 \				// 1/msec
	X_beta_B	-80.0 \				// mV
	X_beta_V0	{0.0+PYR_EREST_ABS}  		// mV

//========================================================================
//                        SPIKE DETECTOR
//========================================================================
create 		spike		/library/spike
    set /library/spike \
	thresh		-40 \ 				// mV
	abs_refract	{ 10 * SCALE } \ 		// msec
	output_amp		1

