// genesis

create xform /menu [0,0,600,600]
create xdraw /menu/draw [0,0,100%,100%]
ce /menu/draw

function select_options
	if({get(/menu/draw,pixchoose)} == "Aff_ff_syn")
		xshow /x_interface/Aff_ff_syn
	end
	if({get(/menu/draw,pixchoose)} == "Aff_fb_syn")
		xshow /x_interface/Aff_fb_syn
	end
	if({get(/menu/draw,pixchoose)} == "fb_ff_syn")
		xshow /x_interface/fb_ff_syn
	end
	if({get(/menu/draw,pixchoose)} == "Aff_syn")
		xshow /x_interface/Aff_syn
	end
	if({get(/menu/draw,pixchoose)} == "ff_syn")
		xshow /x_interface/ff_syn
	end
	if({get(/menu/draw,pixchoose)} == "CA_syn")
		xshow /x_interface/CA_syn
	end
	if({get(/menu/draw,pixchoose)} == "LOCAL_syn")
		xshow /x_interface/LOCAL_syn
	end
	if({get(/menu/draw,pixchoose)} == "RA_syn")
		xshow /x_interface/RA_syn
	end
	if({get(/menu/draw,pixchoose)} == "fb_syn")
		xshow /x_interface/fb_syn
	end
	if({get(/menu/draw,pixchoose)} == "pyr_fb_syn")
		xshow /x_interface/pyr_fb_syn
	end
end

when /menu/draw click1 do select_options

// pyramidal cell minus axons

create xshape Ia -coords [-40,62.5,0] [40,62.5,0] \
[-40,62.5,0] [-40,-62.5,0] [-40,-62.5,0] [40,-62.5,0] [40,-62.5,0] [40,65,0] \
	-tx 0 -ty 332.5 -textcolor brown \
	-linewidth 5 -hlhistmode none -hldispmode none -pixcolor black
create xshape supIb -coords [-40,66,0] [-40,-66,0] \
[-40,-66,0] [40,-66,0] [40,-66,0] [40,66,0] \
	-tx 0 -ty 199.5 -textcolor brown \
	-linewidth 5 -hlhistmode none -hldispmode none -pixcolor black
create xshape deepIb -coords [-40,66,0] [-40,-63,0] \
[-40,-63,0] [40,-63,0] [40,-63,0] [40,66,0] \
	-tx 0 -ty 63 -textcolor brown \
	-linewidth 5 -hlhistmode none -hldispmode none -pixcolor black
create xshape soma -coords [-20,-50,0] [-80,-50,0]	\
[-80,-50,0] [-40,50,0] [40,50,0] [80,-50,0] [80,-50,0] [20,-50,0] \
	-tx 0 -ty -50 -textcolor brown \
	-linewidth 5 -hlhistmode none -hldispmode none -pixcolor black
create xshape III -coords [-80,85,0] [-180,-85,0] \
[-180,-85,0] [-110,-85,0] [-110,-85,0] [-20,77,0] \
[-20,77,0] [0,40,0] [0,40,0] [20,77,0] [20,77,0] [110,-85,0] \
[110,-85,0] [180,-85,0] [180,-85,0] [80,85,0] \
	-tx 0 -ty -185 -textcolor brown  \
	-linewidth 5 -hlhistmode none -hldispmode none -pixcolor black

// inhibitory cells minus axons

create xshape inhib.icon -coords \
	[0.000000,40.000000,0.000000]  \
	[3.920686,39.807389,0.000000]  \
	[7.803613,39.231411,0.000000]  \
	[11.611387,38.277613,0.000000]  \
	[15.307338,36.955181,0.000000]  \
	[18.855870,35.276850,0.000000]  \
	[22.222810,33.258784,0.000000]  \
	[25.375732,30.920418,0.000000]  \
	[28.284272,28.284271,0.000000]  \
	[30.920419,25.375731,0.000000]  \
	[33.258785,22.222808,0.000000]  \
	[35.276851,18.855868,0.000000]  \
	[36.955182,15.307336,0.000000]  \
	[38.277614,11.611386,0.000000]  \
	[39.231412,7.803611,0.000000]  \
	[39.807389,3.920684,0.000000]  \
	[40.000000,-0.000002,0.000000]  \
	[39.807389,-3.920687,0.000000]  \
	[39.231411,-7.803615,0.000000]  \
	[38.277613,-11.611389,0.000000]  \
	[36.955180,-15.307339,0.000000]  \
	[35.276849,-18.855871,0.000000]  \
	[33.258783,-22.222811,0.000000]  \
	[30.920417,-25.375733,0.000000]  \
	[28.284269,-28.284273,0.000000]  \
	[25.375729,-30.920420,0.000000]  \
	[22.222807,-33.258786,0.000000]  \
	[18.855867,-35.276852,0.000000]  \
	[15.307334,-36.955182,0.000000]  \
	[11.611384,-38.277614,0.000000]  \
	[7.803610,-39.231412,0.000000]  \
	[3.920682,-39.807389,0.000000]  \
	[-0.000003,-40.000000,0.000000]  \
	[-3.920689,-39.807389,0.000000]  \
	[-7.803617,-39.231410,0.000000]  \
	[-11.611391,-38.277612,0.000000]  \
	[-15.307341,-36.955180,0.000000]  \
	[-18.855873,-35.276849,0.000000]  \
	[-22.222813,-33.258782,0.000000]  \
	[-25.375735,-30.920415,0.000000]  \
	[-28.284274,-28.284268,0.000000]  \
	[-30.920421,-25.375728,0.000000]  \
	[-33.258787,-22.222806,0.000000]  \
	[-35.276853,-18.855865,0.000000]  \
	[-36.955183,-15.307333,0.000000]  \
	[-38.277615,-11.611382,0.000000]  \
	[-39.231412,-7.803608,0.000000]  \
	[-39.807390,-3.920681,0.000000]  \
	[-40.000000,0.000005,0.000000]  \
	[-39.807389,3.920691,0.000000]  \
	[-39.231410,7.803618,0.000000]  \
	[-38.277612,11.611392,0.000000]  \
	[-36.955179,15.307343,0.000000]  \
	[-35.276848,18.855875,0.000000]  \
	[-33.258781,22.222814,0.000000]  \
	[-30.920414,25.375736,0.000000]  \
	[-28.284267,28.284276,0.000000]  \
	[-25.375727,30.920422,0.000000]  \
	[-22.222804,33.258788,0.000000]  \
	[-18.855864,35.276854,0.000000]  \
	[-15.307331,36.955184,0.000000]  \
	[-11.611381,38.277615,0.000000]  \
	[-7.803606,39.231413,0.000000]  \
	[-3.920679,39.807390,0.000000]  \
	[0.000007,40.000000,0.000000]  \
	-drawmode DrawLines -hlhistmode none \
	-linewidth 3 -hldispmode none -pixcolor black 
create xshape ff -tx -220 -ty 360 -text ff  \
	-iconname inhib.icon -value inhib.icon
create xshape fb -tx 250 -ty -200 -text fb  \
	-iconname inhib.icon -value inhib.icon

// axons emanating from pyramidal cell

create xshape pyr_axon1 -coords [0,-150,0] [0,-350,0] [-50,-230,0] \
	[50,-230,0] [0,-350,0] [-351,-350,0] [-350,-350,0] [-350,-200,0] \
	[0,-350,0] [352,-350,0] [350,-350,0] [350,-320,0] \
        -tx 0 -ty 0 -linewidth 3 -drawmode DrawSegs -hlhistmode none \
        -hldispmode none -pixcolor black
create xshape pyr_axon_left1 -coords [-350,-180,0] [-350,190,0] \
	[-350,70,0] [-400,70,0] \
        -tx 0 -ty 0 -linewidth 3 -drawmode DrawSegs -hlhistmode none \
        -hldispmode none -pixcolor black
create xshape pyr_axon_left2 -coords [-350,210,0] [-350,290,0] \
        -tx 0 -ty 0 -linewidth 3 -drawmode DrawSegs -hlhistmode none \
        -hldispmode none -pixcolor black
create xshape pyr_axon_left3 -coords [-350,310,0] [-350,340,0] \
	[-351,340,0] [-295,340,0] \
        -tx 0 -ty 0 -linewidth 3 -drawmode DrawSegs -hlhistmode none \
        -hldispmode none -pixcolor black
create xshape pyr_axon_right1 -coords [350,-300,0] [350,60,0] \
	[350,-200,0] [330,-200,0] \
        -tx 0 -ty 0 -linewidth 3 -drawmode DrawSegs -hlhistmode none \
        -hldispmode none -pixcolor black
create xshape pyr_axon_right2 -coords [350,80,0] [350,190,0] \
	[349,190,0] [400,190,0] \
        -tx 0 -ty 0 -linewidth 3 -drawmode DrawSegs -hlhistmode none \
        -hldispmode none -pixcolor black

// afferent axons

create xshape Aff -coords [-400,450,0] [400,450,0] \
	[-350,450,0] [-350,380,0] [-351,380,0] [-295,380,0] \
	[-130,450,0] [-130,370,0] [-131,370,0] [-80,370,0] \
	[250,450,0] [250,110,0] [250,30,0] [250,-124,0] \
	-tx 0 -ty 0 -linewidth 3 -drawmode DrawSegs -hlhistmode none \
	-hldispmode none -pixcolor black

// association axons

create xshape CA_axon -coords [-180,-30,0] [140,-30,0] \
        -tx -220 -ty 230 -linewidth 3 -drawmode DrawSegs -hlhistmode none \
        -hldispmode none -pixcolor black 
create xshape RA_axon -coords [-170,-30,0] [140,-30,0] \
        -tx 255 -ty 100 -linewidth 3 -drawmode DrawSegs -hlhistmode none \
        -hldispmode none -pixcolor black 
create xshape LOCAL_axon -coords [-180,0,0] [32,0,0] \	
        -tx -220 -ty -190 -linewidth 3 -drawmode DrawSegs -hlhistmode none \
        -hldispmode none -pixcolor black

// axons emanating from inhibitory cells 

create xshape fb_axon -coords [0,0,0] [0,-70,0] [-180,-70,0] [140,-70,0] \
	[-55,-70,0] [-55,200,0] [-51,200,0] [-147,200,0] \
        -tx 252 -ty -240 -linewidth 3 -drawmode DrawSegs -hlhistmode none \
        -hldispmode none -pixcolor black
create xshape ff_axon -coords [0,0,0] [0,-20,0] [-180,-20,0] [140,-20,0] \
        -tx -220 -ty 320 -linewidth 3 -drawmode DrawSegs -hlhistmode none \
        -hldispmode none -pixcolor black 

// excitatory synapses (left side)

create xshape left_synapse.icon -coords \
	[0,0,0] [35,23,0] [35,-23,0] \
	-drawmode FillPoly  \
	-linewidth 3  -pixcolor red
create xshape Aff_syn -tx -82 -ty 370 -textmode draw \
	-iconname left_synapse.icon -value left_synapse.icon \
	-hldispmode star
create xshape Aff_ff_syn -tx -298 -ty 380 -textmode draw \
	-iconname left_synapse.icon -value left_synapse.icon
create xshape fb_ff_syn -tx -298 -ty 340 -textmode draw \
	-iconname left_synapse.icon -value left_synapse.icon 
create xshape CA_syn -tx -82 -ty 200 -textmode draw \
	-iconname left_synapse.icon -value left_synapse.icon

create xshape LOCAL_syn -tx -190 -ty -190 -textmode draw \
	-iconname left_synapse.icon -value left_synapse.icon

// excitatory synapses (right side)

create xshape right_synapse.icon -coords \
	[0,0,0] [-35,23,0] [-35,-23,0] \
	-drawmode FillPoly   \
	-linewidth 3 -pixcolor red
create xshape RA_syn -tx 85 -ty 70 -textmode draw  \
	-iconname right_synapse.icon -value right_synapse.icon
create xshape pyr_fb_syn -tx 330 -ty -200 -textmode draw \
	-iconname right_synapse.icon -value right_synapse.icon

// excitatory feedforward synapse onto fb

create xshape Aff_fb_syn -coords [0,0,0] [-23,-35,0] [23,-35,0] \
	-drawmode FillPoly  -tx 250 -ty -121 \
	-linewidth 3 -pixcolor red

// inhibitory synapses (both sides)

create xshape ff_syn -coords \
	[0,0,0] [35,23,0] [35,-23,0] \
	-drawmode FillPoly \
	-linewidth 3 -pixcolor blue -tx -82 -ty 300
create xshape fb_syn -coords \
	[0,0,0] [-35,23,0] [-35,-23,0] \
	-drawmode FillPoly  \
	-tx 110 -ty -40 -linewidth 3 -pixcolor blue

// single arrows pointed towards the right

create xshape one_right_arrow.icon -coords [0,0,0] [-10,10,0] [-10,-10,0] \
	-drawmode FillPoly -hlhistmode none \
	-linewidth 1 -hldispmode none -pixcolor black	 
create xshape ff_arrow1 -tx -85 -ty 300 \
	iconname one_right_arrow.icon -value one_right_arrow.icon
create xshape pyr_ff_arrow -tx -305 -ty 340 \
	iconname one_right_arrow.icon -value one_right_arrow.icon
create xshape LOCAL_arrow1 -tx -195 -ty -190 \
	iconname one_right_arrow.icon -value one_right_arrow.icon
create xshape LOCAL_arrow2 -tx -390 -ty -190 \
	iconname one_right_arrow.icon -value one_right_arrow.icon
create xshape LOCAL_pyr_arrow1 -tx 53 -ty -230 \
	iconname one_right_arrow.icon -value one_right_arrow.icon
create xshape fb_arrow -tx 400 -ty -310 \
	iconname one_right_arrow.icon -value one_right_arrow.icon

// single arrows pointed towards the left

create xshape one_left_arrow.icon -coords [0,0,0] [10,10,0] [10,-10,0] \
	-drawmode FillPoly -hlhistmode none \
	-linewidth 1 -hldispmode none -pixcolor black	 	
create xshape ff_arrow2 -tx -405 -ty 300 \
	iconname one_left_arrow.icon -value one_left_arrow.icon
create xshape LOCAL_pyr_arrow2 -tx -53 -ty -230 \
 	iconname one_left_arrow.icon -value one_left_arrow.icon
create xshape fb_left_arrow1 -tx 67 -ty -310 \
 	iconname one_left_arrow.icon -value one_left_arrow.icon
create xshape fb_left_arrow2 -tx 115 -ty -40 \
 	iconname one_left_arrow.icon -value one_left_arrow.icon
create xshape pyr_fb_arrow -tx 334 -ty -200 \
	iconname one_left_arrow.icon -value one_left_arrow.icon

// double arrows pointed towards the right

create xshape two_right_arrow.icon -coords [-20,10,0] [-20,-10,0] [-10,0,0] \ 
	[-10,-10,0] [0,0,0] [-10,10,0] [-10,0,0] \
	-drawmode FillPoly -hlhistmode none \
	-linewidth 1 -hldispmode none -pixcolor black	 
create xshape Aff_right -tx 403 -ty 450  \
	-iconname two_right_arrow.icon -value two_right_arrow.icon
create xshape Aff_left  -tx -380 -ty 450  \
	-iconname two_right_arrow.icon -value two_right_arrow.icon
create xshape Aff_ff -tx -305 -ty 380  \
	-iconname two_right_arrow.icon -value two_right_arrow.icon
create xshape Aff_Ia -tx -85 -ty 370  \
	-iconname two_right_arrow.icon -value two_right_arrow.icon
create xshape CA1 -tx -380 -ty 200  \
	-iconname two_right_arrow.icon -value two_right_arrow.icon
create xshape CA2 -tx -85 -ty 200  \
	-iconname two_right_arrow.icon -value two_right_arrow.icon
create xshape pyr_right2_arrow -tx 403 -ty 190  \
	-iconname two_right_arrow.icon -value two_right_arrow.icon

// double arrows pointed towards the left

create xshape two_left_arrows.icon -coords [20,10,0] [20,-10,0] [10,0,0] \ 
	[10,-10,0] [0,0,0] [10,10,0] [10,0,0] \
	-drawmode FillPoly -hlhistmode none \
	-linewidth 1 -hldispmode none -pixcolor black	 
create xshape RA1_arrows -tx 94 -ty 70 \
	iconname two_left_arrows.icon -value two_left_arrows.icon
create xshape RA2_arrows -tx 380 -ty 70 \
	iconname two_left_arrows.icon -value two_left_arrows.icon
create xshape pyr_RA_arrows -tx -403 -ty 70 \
	iconname two_left_arrows.icon -value two_left_arrows.icon

// double arrows pointed down

create xshape two_down_arrows.icon -coords [10,20,0] [-10,20,0] [0,10,0] \
	[-10,10,0] [0,0,0] [10,10,0] [0,10,0] \
	-drawmode FillPoly -hlhistmode none \
	-linewidth 1 -hldispmode none -pixcolor black 
create xshape Aff_fb_arrows1 -tx 251 -ty 251 \
	iconname two_down_arrows.icon -value two_down_arrows.icon
create xshape Aff_fb_arrows2 -tx 251 -ty -115 \
	iconname two_down_arrows.icon -value two_down_arrows.icon

// labels for varoius components of circuit 

create xshape Aff_label -tx 0 -ty 470 -text "afferent LOT"
create xshape CA_label1 -tx -230 -ty 220 -text "caudally directed"
create xshape CA_label2 -tx -230 -ty 180 -text "association fibers"
create xshape LOCAL_label1 -tx -280 -ty -170 -text "local"
create xshape LOCAL_label2 -tx -270 -ty -210 -text "association"
create xshape RA_pyr_label -tx -200 -ty -375 -text "rostrally directed assoc."
create xshape CA_pyr_label -tx 200 -ty -375 -text "caudally directed assoc."
create xshape pyr_LOCAL_label -tx 0 -ty -250 -text "local   assoc."
create xshape RA_label1 -tx 220 -ty 90 -text "rostrally directed"
create xshape RA_label2 -tx 220 -ty 50 -text "association fibers"

// xbuttons

create xtoggle mode [1%,96%,18%,3%] -script "mode"
	set ^ label0 "SIMULATE" label1 "PLAYBACK"
create xbutton simulate [21%,96%,18%,3%] -title "simulate" -script "xshow /x_interface/simulate"
create xbutton playback [41%,96%,18%,3%] -title "playback" -script "xshow /x_interface/playback"
create xbutton help [61%,96%,18%,3%] -title "help" -script "xshow /x_interface/help"  
create xbutton quit [81%,96%,18%,3%] -title "quit" -script "xshow /x_interface/quit"

create xbutton field_potential [57%,16%,15%,3%] -title "field potential" \
	-script "xshow /x_interface/field_pot"
create xbutton spike_count [57%,20%,15%,3%] -title "spike count" 	\
	-script "xshow /x_interface/spike"
create xbutton side_view [57%,24%,15%,3%] -title "full cell view" 	\
	-script "xshow /x_interface/full_cell_view"

create xbutton Ia_menu [47%,15%,6%,3%] -title "Ia" \
	-script "xshow /x_interface/Ia_options"
create xbutton supIb_menu [47%,28%,6%,3%] -title "supIb" \
	-script "xshow /x_interface/supIb_options"
create xbutton deepIb_menu [47%,41%,6%,3%] -title "deepIb" \ 
	-script "xshow /x_interface/deepIb_options"
create xbutton soma_menu [45%,54%,10%,3%] -title "soma (II)" \
	-script "xshow /x_interface/soma_options"
create xbutton III_menu [47%,67%,6%,3%] -title "III" \
	-script "xshow /x_interface/III_options"

create xform /menu/legend [540,50,600,333.3] 
create xdraw /menu/legend/draw [0,0,100%,100%] -wx 1000 -wy 600
ce /menu/legend/draw
create xlabel /menu/legend/label -title "LEGEND" [0,0,100%,10%]
create xshape ex_synapse -coords \
        [0,0,0] [35,23,0] [35,-23,0] \
        -drawmode FillPoly  -tx -17 -ty 125 \
        -linewidth 3  -pixcolor red
create xshape excitatory_synapse -tx 0 -ty 75 -text "excitatory synapse"
create xshape inhib_synapse -coords \
        [0,0,0] [35,23,0] [35,-23,0] \
        -drawmode FillPoly  -tx -17 -ty -75 \
        -linewidth 3  -pixcolor blue
create xshape inhibitory_synapse -tx 0 -ty -125 -text "inhibitory synapse"
create xshape one_right_arrow -coords [0,0,0] [-10,10,0] [-10,-10,0] \
	-drawmode FillPoly -hlhistmode none -tx 300 -ty 125 \
	-linewidth 1 -hldispmode none -pixcolor black	
create xshape local_fiber -tx 300 -ty 75 -text "local fibers"
create xshape two_right_arrow -coords [-20,10,0] [-20,-10,0] [-10,0,0] \ 
	[-10,-10,0] [0,0,0] [-10,10,0] [-10,0,0] \
	-drawmode FillPoly -hlhistmode none -tx 300 -ty -75 \
	-linewidth 1 -hldispmode none -pixcolor black	   
create xshape distant_fiber -tx 300 -ty -125 -text "distant fibers"
create xshape inhib_cell -coords \
	[0.000000,40.000000,0.000000]  \
	[3.920686,39.807389,0.000000]  \
	[7.803613,39.231411,0.000000]  \
	[11.611387,38.277613,0.000000]  \
	[15.307338,36.955181,0.000000]  \
	[18.855870,35.276850,0.000000]  \
	[22.222810,33.258784,0.000000]  \
	[25.375732,30.920418,0.000000]  \
	[28.284272,28.284271,0.000000]  \
	[30.920419,25.375731,0.000000]  \
	[33.258785,22.222808,0.000000]  \
	[35.276851,18.855868,0.000000]  \
	[36.955182,15.307336,0.000000]  \
	[38.277614,11.611386,0.000000]  \
	[39.231412,7.803611,0.000000]  \
	[39.807389,3.920684,0.000000]  \
	[40.000000,-0.000002,0.000000]  \
	[39.807389,-3.920687,0.000000]  \
	[39.231411,-7.803615,0.000000]  \
	[38.277613,-11.611389,0.000000]  \
	[36.955180,-15.307339,0.000000]  \
	[35.276849,-18.855871,0.000000]  \
	[33.258783,-22.222811,0.000000]  \
	[30.920417,-25.375733,0.000000]  \
	[28.284269,-28.284273,0.000000]  \
	[25.375729,-30.920420,0.000000]  \
	[22.222807,-33.258786,0.000000]  \
	[18.855867,-35.276852,0.000000]  \
	[15.307334,-36.955182,0.000000]  \
	[11.611384,-38.277614,0.000000]  \
	[7.803610,-39.231412,0.000000]  \
	[3.920682,-39.807389,0.000000]  \
	[-0.000003,-40.000000,0.000000]  \
	[-3.920689,-39.807389,0.000000]  \
	[-7.803617,-39.231410,0.000000]  \
	[-11.611391,-38.277612,0.000000]  \
	[-15.307341,-36.955180,0.000000]  \
	[-18.855873,-35.276849,0.000000]  \
	[-22.222813,-33.258782,0.000000]  \
	[-25.375735,-30.920415,0.000000]  \
	[-28.284274,-28.284268,0.000000]  \
	[-30.920421,-25.375728,0.000000]  \
	[-33.258787,-22.222806,0.000000]  \
	[-35.276853,-18.855865,0.000000]  \
	[-36.955183,-15.307333,0.000000]  \
	[-38.277615,-11.611382,0.000000]  \
	[-39.231412,-7.803608,0.000000]  \
	[-39.807390,-3.920681,0.000000]  \
	[-40.000000,0.000005,0.000000]  \
	[-39.807389,3.920691,0.000000]  \
	[-39.231410,7.803618,0.000000]  \
	[-38.277612,11.611392,0.000000]  \
	[-36.955179,15.307343,0.000000]  \
	[-35.276848,18.855875,0.000000]  \
	[-33.258781,22.222814,0.000000]  \
	[-30.920414,25.375736,0.000000]  \
	[-28.284267,28.284276,0.000000]  \
	[-25.375727,30.920422,0.000000]  \
	[-22.222804,33.258788,0.000000]  \
	[-18.855864,35.276854,0.000000]  \
	[-15.307331,36.955184,0.000000]  \
	[-11.611381,38.277615,0.000000]  \
	[-7.803606,39.231413,0.000000]  \
	[-3.920679,39.807390,0.000000]  \
	[0.000007,40.000000,0.000000]  \
	-drawmode DrawLines -hlhistmode none  -tx -300 -ty 140 \
	-linewidth 3 -hldispmode none -pixcolor black 
create xshape inhibitory_cell -tx -300 -ty 75 -text "inhibitory cell" 
create xshape pyramidal -coords [-5,60,0] [5,60,0] [5,0,0] [30,-30,0] \
	[20,-30,0] [0,-10,0] [-20,-30,0] [-30,-30,0] [-5,0,0] \
	[-5,60,0] -tx -300 -ty -65
create xshape pyramidal_cell -tx -300 -ty -125 -text "pyramidal cell"
create xbutton cancel -title "cancel" -script "xhide /menu/legend"

xshow /menu

