//genesis

// =================================
//      link in a new compartment
// =================================
function link_compartment
    sendmsg  $1  $2  	RAXIAL  	Ra previous_state
    sendmsg   $2  $1  	AXIAL  		previous_state
end

// =================================
//      link in a new channel
// =================================
function link_channel(chan,comp)
    sendmsg   {chan}  {comp}  	CHANNEL 	Gk Ek 
    sendmsg   {comp}  {chan}  	VOLTAGE 	Vm 
end

function singlelink_channel(chan,comp)
    sendmsg   {chan}  {comp}  	CHANNEL 	Gk Ek 
end

function link_hhchannel(chan,comp)
    sendmsg   {chan}  {comp}  	CHANNEL 	Gk Ek 
    sendmsg   {comp}  {chan}  	VOLTAGE 	Vm 
    sendmsg   {comp}  {chan}  	EREST 		Erest 
end

// =================================
//   somatic current injection (uA)
// =================================
function inject(neuron,value) 
str neuron
float value
    set {neuron}/soma inject value
end

// =================================
//   modify spike output based on 
//   integration step to give constant 
//   impulse area
// =================================
function adjustspike
    set /##[TYPE=spike] output_amp {1.0/getclock(0)}
end

// =================================
//   sets baseline LOT input rates
// =================================
function baseline(min,max,rate)
    float min,max,rate
    str path

    path  = "/bulb/mitral[]/input"
    set {path} min_amp {min} max_amp {max} rate {rate}
end

// =================================
//   simulate shock to the LOT
// =================================
function shock(value)
str path
float value
float oldrate,oldmin,oldmax
    baseline {value} {value} 1000	// shock
    step 
    // baseline 0.05 0.1 0.4		// 400 Hz noise
    baseline 0 0 0
end

