//genesis

str string

//========================================================================
//                        PYRAMIDAL CELL
//========================================================================
/*
** this function constructs a pyramidal cell according to the arguments
** passed to it
*/
function pyramidal_cell(pathname,active,multi,spike,connect, \
soma_d,soma_l,dend_d,dend_l)

str	pathname
int	active
int	multi
int	spike
int	connect
float	soma_d		// um
float	soma_l		// um
float	dend_d		// um
float	dend_l		// um

    float soma_a	=	PI*soma_d*soma_l 	// um^2
    float soma_xa	=	PI*soma_d*soma_d/4 	// um^2
    float dend_a	=	PI*dend_d*dend_l 	// um^2
    float dend_xa	=	PI*dend_d*dend_d/4 	// um^2

    create 	neutral 	{pathname}
    ce 	{pathname}
    if(active)
	// add the Hodgkin-Huxley compartment

//	copy 	/library/HHcompartment	soma

	// add two voltage dependent conductances

	copy 	/library/HH_Na_channel HH_Na_channel
	copy 	/library/HH_K_channel HH_K_channel
	link_hhchannel 	HH_Na_channel 	soma 
	link_hhchannel  HH_K_channel 	soma 
    else
	// passive soma

	create compartment soma
	set soma \
	    Em		{PYR_EREST} \ 				// mV
	    Rm		{ RM/soma_a } \  	 		// Kohm
	    Cm		{ CM*soma_a*SCALE } \ 			// uF
	    Ra		{ RA*soma_l/soma_xa }  			// Kohm 
    end

    /*
    ** add a buffer for generating thresholded spike events 
    */
    copy 	/library/spike .
    set spike abs_refract 10
    if(active)
	set spike thresh	0  				// mV
    else
	set spike thresh	-40				// mV
    end
    /*
    ** use the soma potential (or state) to drive the thresholded
    ** spike generation buffer
    */
    sendmsg  soma 	spike 		INPUT Vm 

    /*
    ** axons
    */
    foreach string (RA CA LRA LCA FF FB )
	create axon	{string}axon 
	set {string}axon latency {SYNDELAY}
	sendmsg 	spike 	{string}axon	BUFFER name
    end

    if(multi)
	push soma
	/*
	** add a passive dendritic compartments
	*/
	create compartment III_dend
	    set		III_dend \
		Em	{PYR_EREST} \ 				// mV
		Rm	{RM/ dend_a} \  	 		// Kohms
		Cm	{CM * dend_a*SCALE} \ 			// uF
		Ra	{RA * dend_l/dend_xa}  			// Kohm

	copy III_dend 	deepIb_dend
	copy III_dend 	supIb_dend
	copy III_dend 	Ia_dend

	/*
	** and link them 
	*/
	link_compartment	III_dend		.
	link_compartment	deepIb_dend		.
	link_compartment	supIb_dend		deepIb_dend
	link_compartment	Ia_dend			supIb_dend
	pop
    end

    if(spike)
	/*
	** add spike producing channels
	*/
	create channelC		SNa_channel 
	    set SNa_channel \
		Ek	{ENA} \				// mV
		tau1	{ 0.2  * SCALE } \		// msec
		tau2	{ 0.2  * SCALE } \		// msec
		gmax	{SGMAX_NA*fAC*soma_a}		// mS
	create 	channelC	SK_channel 
	    set SK_channel \
		Ek	{EK} \				// mV
		tau1	{ 1 * SCALE } \			// msec
		tau2	{ 1 * SCALE } \			// msec
		gmax	{SGMAX_K*fAC*soma_a}		// mS
	/*
	** use the spike output as activation for the channels
	*/
	sendmsg  spike SNa_channel 		ACTIVATION state 
	sendmsg  spike SK_channel 		ACTIVATION state 
	singlelink_channel 		SNa_channel 	soma
	singlelink_channel 		SK_channel 	soma
    end

    if(connect)
	/*
	** add synaptically activated channels
	*/
	if(multi)
	    push soma/Ia_dend
	    copy 	/library/Na_channel 	Aff_Na_channel
	    set	Aff_Na_channel		gmax	{DISTAL_GMAX_NA} // mS/synapse
	    link_channel Aff_Na_channel 	.
	    if(EXTRA)
		copy 	/library/Cl_channel 	Cl_channel
		set	Cl_channel		gmax	{GMAX_CL}
		link_channel 	Cl_channel 	.
	    end
	    pop

	    push soma/supIb_dend
	    copy 	/library/Na_channel 	CA_Na_channel
	    set	CA_Na_channel		gmax	{DISTAL_GMAX_NA}
	    link_channel 	CA_Na_channel 	.
	    pop

	    push soma/deepIb_dend
	    copy 	/library/Na_channel 	RA_Na_channel
	    set	RA_Na_channel		gmax	{DISTAL_GMAX_NA}
	    link_channel 	RA_Na_channel 	.
	    pop

	    push soma/III_dend
	    copy 	/library/Na_channel 	Local_Na_channel
	    set	Local_Na_channel	gmax	{LOCAL_GMAX_NA}
	    link_channel 	Local_Na_channel .
	    pop

	    push soma/Ia_dend
	    copy 	/library/K_channel 	K_channel
	    set	K_channel		gmax	{GMAX_K}
	    link_channel 	K_channel 	.
	    pop

	    push soma
	    copy 	/library/Cl_channel 	Cl_channel
	    set	Cl_channel		gmax	{GMAX_CL}
	    link_channel 	Cl_channel 	.
	    pop
	else
	    push soma
	    copy 	/library/Na_channel 	Aff_Na_channel
	    set	Aff_Na_channel		gmax	{DISTAL_GMAX_NA}
	    link_channel 	Aff_Na_channel 		.

	    copy 	/library/Na_channel 	CA_Na_channel
	    set	CA_Na_channel		gmax	{DISTAL_GMAX_NA}
	    link_channel 	CA_Na_channel 		.

	    copy 	/library/Na_channel 	RA_Na_channel
	    set	RA_Na_channel		gmax	{DISTAL_GMAX_NA}
	    link_channel 	RA_Na_channel 		.

	    copy 	/library/Na_channel 	Local_Na_channel
	    set	Local_Na_channel	gmax	{LOCAL_GMAX_NA}
	    link_channel 	Local_Na_channel 	.

	    copy 	/library/K_channel 	K_channel
	    set	K_channel		gmax	{GMAX_K}
	    link_channel 	K_channel 		.

	    copy 		/library/Cl_channel 	Cl_channel
	    set	Cl_channel		gmax	{GMAX_CL}
	    link_channel 	Cl_channel 		.
	    pop
	end	// multi
    end	    // connect
    if(multi)
	push soma
	/*
	** set dendritic positions relative to the soma
	*/
	position III_dend 	I I R120e-3	// 100um deep to the soma
	position deepIb_dend 	I I R-190e-3	// 100um super to the soma
	position supIb_dend 	I I R-310e-3	// 200um super to the soma
	position Ia_dend 	I I R-430e-3	// 300um super to the soma
	pop
    end     // multi
end	// pyramidal_cell

//========================================================================
//                        INTERNEURON
//========================================================================
function interneuron(pathname,soma_d,soma_l,Cl,multaxon)
str     pathname
float   soma_d          // um
float   soma_l          // um
int     Cl              // flag for incorporating a Cl channel
int     multaxon        // flag for additional axon

    float soma_a        =       PI*soma_d*soma_l        // um^2
    float soma_xa       =       PI*soma_d*soma_d/4      // um^2

    create      neutral {pathname}
    ce  {pathname}

    /*
    ** soma
    */
    create compartment  soma
    set soma \
        Em              {I_EREST} \                             // mV
        Rm              {I_RM / soma_a} \                       // Kohms
        Cm              {I_CM * soma_a * SCALE} \               // uF
        Ra              {I_RA * soma_l / soma_xa}               // Kohm
    /*
    ** channels
    */
    copy        /library/Na_channel     soma
    set soma/Na_channel         gmax            {I_GMAX_NA}
    link_channel                soma/Na_channel         soma

    if(Cl)
        copy    /library/Cl_channel     soma
        set     soma/Cl_channel         gmax            {I_GMAX_CL}
        link_channel            soma/Cl_channel         soma
    end

    /*
    ** add spike producing channels
    */
    create channelC SNa_channel
    set SNa_channel \
        Ek              {ENA} \                         // mV
        tau1            { 0.2 * SCALE } \               // msec
        tau2            { 0.2 * SCALE }\                // msec
        gmax            {SGMAX_NA*fAC*soma_a}           // mS
    create channelC SK_channel
    set SK_channel \
        Ek              {EK} \                          // mV
        tau1            { 1 * SCALE } \                 // msec
        tau2            { 1  * SCALE } \                // msec
        gmax            {SGMAX_K*fAC*soma_a}            // mS
    /*
    ** use the spike output as activation for the channels
    */
    singlelink_channel          SNa_channel     soma
    singlelink_channel          SK_channel      soma

    copy        /library/spike  .
    set spike thresh -40
    set spike abs_refract 10
    sendmsg  soma       spike           INPUT Vm
    sendmsg  spike SNa_channel          ACTIVATION state
    sendmsg  spike SK_channel           ACTIVATION state

    create      axon        axon
    set axon latency {SYNDELAY}
    sendmsg     spike   axon    BUFFER name
    if(multaxon)
        create  axon        fbaxon
        set axon latency {SYNDELAY}
        sendmsg         spike   fbaxon  BUFFER name
    end
end     // interneuron

//========================================================================
//                        BULBAR INPUT
//========================================================================
function bulb(path)
str path

    create 		neutral {path}
    ce ^
    create random input
    set input min_amp 3
    set input max_amp 6
    set input rate .2 		// spikes/msec
    create axon axon
    sendmsg 	input 	axon	BUFFER name
    create axon axon2
    sendmsg 	input 	axon2	BUFFER name
    create axon axon3
    sendmsg 	input 	axon3	BUFFER name
end

