//genesis
create xform /xout [360,0,800,400]
ce /xout

/*
** Creating a view to look at the input pattern
** Note that because of a peculiarity with the 'input' compartment,
** the state field does not get reset to 0 after it fires. This means
** that the display is actually of the summed activity since the last
** time the state was set to 0.
*/
create xlabel /xout/"Input Pattern" [2%,10%,45%,20] 
create xdraw /xout/draw2 [2%,15%,45%,250] \
     -wx {1.2 * (REC_SEPX * REC_NX)} -wy {1.2 * (REC_SEPY * REC_NY)} 

create xview /xout/draw2/inputs -path /retina/recplane/rec[]/input \
	-field state -autoscale FALSE -vmin -1 -vmax 2 

/* 
** Creating a pair of views in the same draw to look at the lgn cells
*/
create xlabel /xout/"Activity Pattern" [52%,10%,45%,20]
create xdraw /xout/draw3 [52%,15%,45%,250]  \
     -wx {2.5 * (LGN_SEPX * LGN_NX)} -wy {2.5 * (LGN_SEPY * LGN_NY)} \
	 -vz 300 -transform ortho3d 
when /xout/draw3 click1 do "plotviewgraph <widget>"

/* creating the horiz cells to the left of the vert cells */

create xview /xout/draw3/horiz -path /lgn/horiz/soma[] \
	-ox {-0.6 * LGN_SEPX * LGN_NX}  -oz {5 * LGN_SEPZ} \
	-field Vm -autoscale FALSE -vmin -0.09 -vmax 0.05

create xview /xout/draw3/vert -path /lgn/vert/soma[] \
	-ox {0.6 * LGN_SEPX * LGN_NX}  -oz {-5 * LGN_SEPZ} \
	-field Vm -autoscale FALSE -vmin -0.09 -vmax 0.05

/* Creating a set of toggles to choose the lgn cell compartment to be
** displayed in the Activity view.  */
ce /xout
create xtoggle /xout/soma -script "set_soma <widget>" \
	[10,5,18%,25] -widgets [NULL,draw2.bottom,NULL,NULL]
create xtoggle /xout/hhNa -script "set_hhNa <widget>" \
	[10,5,18%,25] -widgets [soma.right,draw2.bottom,NULL,NULL]
create xtoggle /xout/hhK -script "set_hhK <widget>" \
	[10,5,18%,25] -widgets [hhNa.right,draw2.bottom,NULL,NULL]
create xtoggle /xout/exc_syn -script "set_exc_syn <widget>" \
	[10,5,18%,25] -widgets [hhK.right,draw2.bottom,NULL,NULL]
create xtoggle /xout/axon -script "set_axon <widget>" \
	[10,5,18%,25] -widgets [exc_syn.right,draw2.bottom,NULL,NULL]

function set_path_toggles(widget)
	str widget
	ce /xout
	set soma state 0 
	set hhNa state 0 
	set hhK state 0 
	set exc_syn state 0 
	set axon state 0 
	set {widget} state 1
end

function set_soma
	set /xout/draw3/horiz path /lgn/horiz/soma[]
	set /xout/draw3/vert path /lgn/vert/soma[]
	set_path_toggles soma
end

function set_hhNa
	set /xout/draw3/horiz path /lgn/horiz/soma[]/HH_Na_channel
	set /xout/draw3/vert path /lgn/vert/soma[]/HH_Na_channel
	set_path_toggles hhNa
end

function set_hhK
	set /xout/draw3/horiz path /lgn/horiz/soma[]/HH_K_channel
	set /xout/draw3/vert path /lgn/vert/soma[]/HH_K_channel
	set_path_toggles hhK
end

function set_exc_syn
	set /xout/draw3/horiz path /lgn/horiz/soma[]/exc_syn
	set /xout/draw3/vert path /lgn/vert/soma[]/exc_syn
	set_path_toggles exc_syn
end

function set_axon
	set /xout/draw3/horiz path /lgn/horiz/soma[]/axon
	set /xout/draw3/vert path /lgn/vert/soma[]/axon
	set_path_toggles axon
end

/* Creating a dialog to set the field being displayed by the widget */
create xdialog /xout/field -value Vm -script "set_field <widget>" 

function set_field(widget)
str widget
	set /xout/draw3/horiz field {get({widget},value)}
	set /xout/draw3/vert field {get({widget},value)}
end

/* Creating an autoscale toggle for the views */
create xtoggle /xout/autoscale -script "autoscale_toggle <widget>" 

function autoscale_toggle(widget)
str widget
	if ({get({widget},state)} == 1)
		set /xout/draw3/horiz autoscale TRUE
		set /xout/draw3/vert autoscale TRUE
	else
		set /xout/draw3/horiz autoscale FALSE
		set /xout/draw3/vert autoscale FALSE
	end
end

xshow /xout
