//genesis
// myxtools.g, slightly modified from /usr/genesis/startup/xtools.g
/*
** user functions available in xtools
**
** function		arguments
** ======================================================
** xrange 		path xmin xmax  (not used in Neuron)
** yrange 		path ymin ymax  (not used in Neuron)
** graphclock		path clock      (not used in Neuron)
** overlay		path value
** overlaytoggle	widget // was in buttons.g
** showgraphics		path      (not used in Neuron)
** hidegraphics		path      (not used in Neuron)
** makeconfirm		path title yes_script no_script x y
** setgraphscale	graph
** showgraphscale	graph
** makegraphscale	graph
** quitbutton		widget
** cancelquit		widget
** fieldbutton		path field widget
** setstepsize		widget
** stepbutton		widget
** formtoggle		widget form0 form1  // replaces celltoggle
**
*/

function xrange(name,xmin,xmax)
    if(argc < 3)
	echo usage: xrange name xmin xmax
	return
    end
    str name
    float xmin,xmax
    if(strcmp({get({name},object->name)},xgraph) == 0)
	set {name} xmin {xmin} xmax {xmax}
    else
	set {name}/##[TYPE=xgraph] xmin {xmin} xmax {xmax}
    end
end

function yrange(name,ymin,ymax)
    if(argc < 3)
	echo usage: xrange name xmin xmax
	return
    end
    str name
    float ymin,ymax
    if(strcmp({get({name},object->name)},xgraph) == 0)
	set {name} ymin {ymin} ymax {ymax}
    else
	set {name}/##[TYPE=xgraph] ymin {ymin} ymax {ymax}
    end
end

function graphclock(path,clock)
str path
int clock
str num
    useclock {path}/##[TYPE=xgraph] {clock}
end

function overlay(path,value)
str path
    set {path}/##[TYPE=xgraph] overlay {value}
    echo -n "overlay "
    if(value == 0)
	echo OFF 
    else
	echo ON
    end
end

// ==============================================
// toggles the overlaying of graph outputs 
// ==============================================
function overlaytoggle(widget)
    overlay / {get({widget},state)}
end

function showgraphics(path)
    if(argc < 1)
	echo usage: showgraphics path
	return
    end
    str path
    str name
    foreach name ({EL({path}/##[TYPE=xform])})
	xshow {name}
    end
end

function hidegraphics(path)
    if(argc < 1)
	echo usage: showgraphics path
	return
    end
    str path
    str name
    foreach name ({EL({path}/##[TYPE=xform])})
	xhide {name}
    end
end


function makeconfirm(path,title,yes_script,no_script,x,y)
    if(argc < 6)
	echo usage: makeconfirm path title yes_script no_script x y
	return
    end
    str path,title,yes_script,no_script
    float x,y
    create xform	{path}/confirm [{x},{y},200,80] -nolabel
    create xlabel	{path}/confirm/label  [0,0,200,30] \
				    -title {title}
    create xbutton	{path}/confirm/yes  [10,40,80,30]\
				    -script {yes_script}
    create xbutton	{path}/confirm/no  [100,40,80,30] \
				    -script {no_script}
    disable {path}/confirm
end

function setgraphscale(graph)
    str graph
    str form = graph + "/scaleform"
    str xmin = get({form}/xmin,value)
    str xmax = get({form}/xmax,value)
    str ymin = get({form}/ymin,value)
    str ymax = get({form}/ymax,value)
    set {graph} xmin {xmin}  xmax {xmax} ymin {ymin} ymax {ymax}
    xhide {form}
end

function showgraphscale(form)
    str form
    float x,y,dx,dy
    // find the parent form
    str parent = EL({form}/..)
    while(get({parent},object->name) != "xform")
	parent = EL({parent}/..)
    end
    x = get({parent},x)
    y = get({parent},y)
    // find the parent graph
    str parent = EL({form}/..)
    while(get({parent},object->name) != "xgraph")
	parent = EL({parent}/..)
    end
    dx = get({parent},x)            // original version had an upwards offset
    dy = get({parent},y)            //- 155
    set {form} x {x +dx} y {y +dy}
    xshow {form}
end

function makegraphscale(graph)
    if(argc < 1)
	echo usage: makegraphscale graph
	return
    end
    str graph
    float x,y
    str form = graph + "/scaleform"
    x = get({graph},x)
    y = get({graph},y)

    create xbutton {graph}/scalebutton [0,0,50,15] \
	-widgets [{graph}.left,{graph}.top,NULL,NULL] \
	-title scale \
	-script "showgraphscale "{form}
    create xform {form} [{x},{y},180,170] \
	-nolabel

    disable {form}
    push {form}
    create xbutton DONE [10,10,50,15] -script "setgraphscale "{graph}
    create xbutton CANCEL [70,10,50,15] -script "xhide "{form}
    create xdialog xmin [10,35,160,25] -value {get({graph},xmin)}
    create xdialog xmax [10,65,160,25] -value {get({graph},xmax)}
    create xdialog ymin [10,95,160,25] -value {get({graph},ymin)}
    create xdialog ymax [10,125,160,25] -value {get({graph},ymax)}
    pop
end

// ==============================================
// sets the field of the specified element
// ==============================================
function fieldbutton(path,field,widget)
    str path,field,widget

    set {path} {field} {get({widget},value)}
    echo {path} {field} = {get({widget},value)}
end

function quitbutton(widget)
    str widget
    // display the confirmation widget
    xshow_on_top {widget}/confirm
end

function cancelquit(widget)
    str widget
    // hide the confirmation widget
    xhide {widget}/..
end

// ==============================================
// sets the global simulation clock
// ==============================================
function setstepsize(widget)
    str widget
    float dt  = {get({widget},value)}
    setclock 0 {dt}
    echo dt = {dt}
    adjustspike
end

// ==============================================
// advances the simulation by the amount of time given in the dialog
// ==============================================
function stepbutton(widget)
    str widget
    echo step -t {get({widget},value)}
    step -t {get({widget},value)}
end

// ==============================================
//       toggles the display of two forms
// ==============================================
function formtoggle(widget,form0,form1)
    if(get({widget},state) == 1)
	xshow {form1}
	xhide {form0}
    else
        xshow {form0}
	xhide {form1}
    end
end

