//genesis
/*   inputs.g
---------------------------------------------------------------------------
makeinputs
     used in Neuron.g to provide pulsed current injection to soma and
     pulsed spike trains to the dendrite excitatory and inhibitory synapses

setspikes(source,delay,width,interval)
     used in makeinputs and forms.g to set the spike train parameters
     for a pulsegen object

setinjection(delay,width)
     used in makeinputs and forms.g to set the injection parameters
---------------------------------------------------------------------------
*/

function setspikes(source,delay,width,interval)
    str source
    str pulser = "/input/" + {source}
    str spiker = {pulser} + "/spiketrain"
    float delay, width, interval
    set {pulser} level1 1.0 width1 {width}  delay1 {delay} \
		 baselevel 0.0 trig_mode 0 delay2 100000
// free run mode with very long delay for 2nd pulse (non-repetitive)
    set {spiker} abs_refract {interval} output_amp 1 thresh 0.5
end

function setinjection(delay,width)
    float delay, width
    set /input/injectpulse level1 1.0 width1 {width}  delay1 {delay} \
		 baselevel 0.0 trig_mode 0 delay2 100000
// free run mode with very long delay for 2nd pulse (non-repetitive)
end

function makeinputs

// Default values of parameters - dialog boxes in forms.g should be consistent
float injwidth	=   40	// msec
float injdelay	=   20
float somacurrent	= 2e-4	// uA (200 nA)
float dend1current	= 0
float dend2current	= 0

float Adelay	=  10
float Awidth	=  50
float Ainterval	=  10	// msec

float Bdelay	=  20
float Bwidth	=  50
float Binterval	=  10	// msec

create neutral /input
//==================================================
// Make a periodic injection current step
//==================================================
create pulsegen /input/injectpulse
setinjection({injdelay},{injwidth})
// set the amplitude (current) with the gain of a differential amplifier
create diffamp /input/injectpulse/somacurr
create diffamp /input/injectpulse/dend1curr
create diffamp /input/injectpulse/dend2curr
set /input/injectpulse/somacurr saturation 1 gain {somacurrent}
set /input/injectpulse/dend1curr saturation 1 gain {dend1current}
set /input/injectpulse/dend2curr saturation 1 gain {dend2current}
sendmsg /input/injectpulse /input/injectpulse/somacurr PLUS output
sendmsg /input/injectpulse /input/injectpulse/dend1curr PLUS output
sendmsg /input/injectpulse /input/injectpulse/dend2curr PLUS output
sendmsg /input/injectpulse/somacurr /cell/soma INJECT output
sendmsg /input/injectpulse/dend1curr /cell/dend1 INJECT output
sendmsg /input/injectpulse/dend2curr /cell/dend2 INJECT output

//==================================================
// spike trains for synaptic input
//==================================================
// pulse to gate spike train A
create pulsegen /input/Apulse
// Use pulse as input to a spike object
create spike /input/Apulse/spiketrain
setspikes(Apulse,{Adelay},{Awidth},{Ainterval})
sendmsg  /input/Apulse  /input/Apulse/spiketrain INPUT output
// Now feed these spike trains to an "axon" to allow synaptic weights
create axon /input/Apulse/axon
sendmsg /input/Apulse/spiketrain /input/Apulse/axon BUFFER name

// pulse to gate spike train B
create pulsegen /input/Bpulse
// Use pulse as input to a spike object
create spike /input/Bpulse/spiketrain
setspikes(Bpulse,{Bdelay},{Bwidth},{Binterval})
sendmsg  /input/Bpulse  /input/Bpulse/spiketrain INPUT output
// Now feed these spike trains to an "axon" to allow synaptic weights
create axon /input/Bpulse/axon
sendmsg /input/Bpulse/spiketrain /input/Bpulse/axon BUFFER name

// Lastly, makeconnection to chemically activated dendrite channels
connect /input/Apulse/axon  /cell/dend2/Inh_channel with synapse
connect /input/Apulse/axon  /cell/dend2/Ex_channel with synapse
connect /input/Apulse/axon  /cell/dend1/Inh_channel with synapse
connect /input/Apulse/axon  /cell/dend1/Ex_channel with synapse
connect /input/Bpulse/axon  /cell/dend2/Inh_channel with synapse
connect /input/Bpulse/axon  /cell/dend2/Ex_channel with synapse
connect /input/Bpulse/axon  /cell/dend1/Inh_channel with synapse
connect /input/Bpulse/axon  /cell/dend1/Ex_channel with synapse
// Note on syntax: Refer to  axon:0, axon:1, etc. AFTER making connections
// Also note the backwards order - axon:0 is the dend1/Ex_channel connection
// Therefore it is better to refer to axon:@/cell/dend1/Ex_channel
set /input/Apulse/axon:# delay 0 weight 0  // no delay, initial weights 0
set /input/Bpulse/axon:# delay 0 weight 0  // no delay, initial weights 0
end  // makeinputs
