//genesis
// forms.g for Neuron tutorial

include myxtools.g  // modified /usr/genesis/startup/xtools.g
include helpforms.g

// =================================================
//   Functions used for setting dendrite inputs
// =================================================
function togglesource(channel, widget)
// toggles channel input between source A/B
    str channel, widget
    str	Aaxonconn	= "/input/Apulse/axon:@/cell/"
    str	Baxonconn	= "/input/Bpulse/axon:@/cell/"
    if(get({widget},state)==1)  // source B
      set {Baxonconn + channel} weight {get({Aaxonconn + channel},weight)}
      set {Aaxonconn + channel} weight 0
    else                        // source A
      set {Aaxonconn + channel} weight {get({Baxonconn + channel},weight)}
      set {Baxonconn + channel} weight 0
    end
end

function setweight(channel,widget)
    str channel, widget
    str	Aaxonconn	= "/input/Apulse/axon:@/cell/"
    str	Baxonconn	= "/input/Bpulse/axon:@/cell/"
    if(get({widget}/source,state)==1)  // source B
      fieldbutton {Baxonconn + channel} weight {widget}
    else
      fieldbutton {Aaxonconn + channel} weight {widget}
    end
end

// =================================================
//   Functions used for popup parameter menus
// =================================================
function make_comp_menu(compartment)
    str compartment
    str formpath	= "/output/popups/" + compartment
    str comppath	= "/cell/" + compartment
    create xform {formpath} [720,50,240,440] -title {compartment}" parameters"
    disable {formpath}
    push {formpath}
    create xbutton  DONE  [0,40,78,30] \
                    -script "xhide "{formpath}
    create xbutton  Ex_button  [80,40,78,30] -title "Exc. Ch." \
           -script "xshow_on_top "{formpath}"/Ex_channel"
    create xbutton  Inh_button  [160,40,78,30] -title "Inh. Ch." \
           -script "xshow_on_top "{formpath}"/Inh_channel"
    create xdialog  Em   -title "Em (mv)"    -value {get({comppath},Em)} \
	-script "fieldbutton "{comppath}" Em "{formpath}/Em
    create xdialog  Rm   -title "Rmem (KOhm)"   -value {get({comppath},Rm)} \
	-script "set_comp_fields "{compartment}
    create xdialog  Cm   -title "Cmem (uF)"     -value {get({comppath},Cm)} \
	-script "set_comp_fields "{compartment}
    create xdialog  Ra   -title "Raxial (KOhm)" -value {get({comppath},Ra)} \
	-script "set_comp_fields "{compartment}
    create xlabel specific_rc -title "Specific Resistance/Capacitance"
    create xdialog  RM  -title "RM (Kohm*cm^2)" -value {rm} \
	-script "set_comp_params "{compartment}
    create xdialog  CM  -title "CM (uF/cm^2)"   -value {cm} \
	-script "set_comp_params "{compartment}
    create xdialog  RA  -title "RA (Kohm*cm)"   -value {ra} \
	-script "set_comp_params "{compartment}
    create xlabel sizes -title "Compartment length/diameter" \
	-script "set_comp_params "{compartment}
    create xdialog  length -title "length (cm)" -value {dend_l} \
	-script "set_comp_params "{compartment}
    create xdialog  diam -title "diam (cm)" -value {dend_d} \
	-script "set_comp_params "{compartment}
    if (compartment == "soma")
	set length value {soma_l}
	set diam value {soma_d}
    end
    pop
end

function make_channel_menu(compartment,channel)
    str compartment,channel
    str comp_and_chan = compartment + "/" + channel  // e. g. "soma/Ex_channel"
    str formpath	= "/output/popups/" + comp_and_chan
    str chanpath	= "/cell/" + comp_and_chan
    create xform {formpath} [770,90,240,215] \
           -title {comp_and_chan}" parameters"
    disable {formpath}
    push {formpath}
    create xbutton  DONE  [0,40,240,30] -script "xhide "{formpath}
    if ({compartment} == "soma")
       create xdialog  Ek    [0,75,240,30]  \
                    -title "Eequil (mV)"    -value {get({chanpath},Ek)} \
                    -script "set_ch_params "{compartment}" "{channel}
       create xdialog gbar    [0,110,240,30] \
                    -title "Gbar (mS)"   -value {get({chanpath},gbar)} \
                    -script "set_ch_params "{compartment}" "{channel}
    else
       create xdialog  Ek    [0,75,240,30]  \
                    -title "Esyn (mV)"    -value {get({chanpath},Ek)} \
                    -script "set_ch_params "{compartment}" "{channel}
       create xdialog gmax    [0,110,240,30] \
                    -title "gmax (mS)"   -value {get({chanpath},gmax)} \
                    -script "set_ch_params "{compartment}" "{channel}

       create xdialog tau1    [0,145,240,30] \
                    -title "Tau 1 (msec)"     -value {get({chanpath},tau1)} \
                    -script "set_ch_params "{compartment}" "{channel}
       create xdialog tau2    [0,180,240,30] \
                    -title "Tau 2 (msec)"     -value {get({chanpath},tau2)} \
                    -script "set_ch_params "{compartment}" "{channel}
    end
    pop
end

function set_ch_params(compartment,channel)
    str compartment,channel
    str comp_and_chan = compartment + "/" + channel  // e. g. "soma/Ex_channel"
    str formpath	= "/output/popups/" + comp_and_chan
    str chanpath	= "/cell/" + comp_and_chan
    fieldbutton {chanpath} Ek {formpath}/Ek
    if ({compartment} == "soma")
       fieldbutton {chanpath} gbar {formpath}/gbar
    else
       fieldbutton {chanpath} gmax {formpath}/gmax
       fieldbutton {chanpath} tau1 {formpath}/tau1
       fieldbutton {chanpath} tau2 {formpath}/tau2
    end
end

function set_comp_fields(compartment)
    str compartment
    str formpath	= "/output/popups/" + compartment
    str comppath	= "/cell/" + compartment
    float length, diam
    length = {get({formpath}/length, value)}
    diam = {get({formpath}/diam, value)}
    set {formpath}/RM value {get({formpath}/Rm, value)*(length*diam*PI)}
    set {formpath}/CM value {get({formpath}/Cm, value)/(length*diam*PI)}
    set {formpath}/RA value \
	{get({formpath}/Ra, value)*(diam*diam*PI)/(4*length)}
    fieldbutton {comppath} Rm {formpath}/Rm
    fieldbutton {comppath} Cm {formpath}/Cm
    fieldbutton {comppath} Ra {formpath}/Ra
end

function set_comp_params(compartment)
    str compartment
    str formpath	= "/output/popups/" + compartment
    str comppath	= "/cell/" + compartment
    float length, diam
    length = {get({formpath}/length, value)}
    diam = {get({formpath}/diam, value)}
    set {formpath}/Rm value {get({formpath}/RM, value)/(length*diam*PI)}
    set {formpath}/Cm value {get({formpath}/CM, value)*(length*diam*PI)}
    set {formpath}/Ra value \
	{get({formpath}/RA, value)*(4*length)/(diam*diam*PI)}
    fieldbutton {comppath} Rm {formpath}/Rm
    fieldbutton {comppath} Cm {formpath}/Cm
    fieldbutton {comppath} Ra {formpath}/Ra
end

function set_input_timing             // uses setspikes from inputs.g
   str dialog ="/output/popups/inputs"
   setinjection({get({dialog}/Idelay,value)}, \
              {get({dialog}/Iwidth,value)})
   setspikes(Apulse,{get({dialog}/Adelay,value)}, \
              {get({dialog}/Awidth,value)},{get({dialog}/Ainterval,value)})
   setspikes(Bpulse,{get({dialog}/Bdelay,value)}, \
              {get({dialog}/Bwidth,value)},{get({dialog}/Binterval,value)})
   adjustspike  // set spike amplitudes to 1.0/dt
end

// functions used in MAIN CONTROL PANEL
//
// change_stepsize  -  sets clock 0 and properly normalizes spike plots
//
function change_stepsize
    float dt  = {get(/output/control/stepsize,value)}
    setclock 0 {dt}
    echo dt = {dt}
    adjustspike
    push /output/dend1graphs
    deletemsg input_grf IN 2  // use new scale for plot with unit height
    deletemsg input_grf IN 1  // MSG 0 for injection pulse is left alone
    sendmsg  /input/Apulse/spiketrain  input_grf PLOTSCALE \
                              state *SourceA *black {dt} 2
    sendmsg  /input/Bpulse/spiketrain  input_grf PLOTSCALE \
                              state *SourceB *black {dt} 4
    pop
end

// =======================================================
//  The two main functions, loadgraphs and loadcontrol
//  set up the forms used for graphs and control buttons
// =======================================================
function loadgraphs
    xon				// activate XODUS
// While forms are being loaded, put up some credits
     echo " "
     echo "*************************************************"
     echo "*                                               *"
     echo "*                   NEURON                      *"
     echo "*                                               *"
     echo "*        A simulation of a simple neuron        *"
     echo "*                                               *"
     echo "*                 D. Beeman                     *"
     echo "*                                               *"
     echo "*            Harvey Mudd College                *"
     echo "*                                               *"
     echo "*************************************************"
     echo " "
    xcolorscale hot		// give it color

    // =================================================
    //                     GRAPHICS
    // =================================================
/* NOTE - Another undocumented feature: The neutral element /output is
   prexisting, so I can create a child "/output/dend1graphs" without explictly
   creating the parent. */
   
    create xform /output/dend1graphs [10,10,500,675] -nolabel
    push /output/dend1graphs
    str graphicspath = "/output/dend1graphs" //parameter to makegraphscale
    // =================================================
    //      make input_grf for Input/Output Voltages
    // =================================================
    create xgraph 	input_grf 	[5,0,490,160] \
			-title "Inputs to Cell" 
    set input_grf xmin 0 xmax 80 ymin 0 ymax 6 XUnits "t (msec)"
    useclock input_grf 0                         // spikes need fast clock
    makegraphscale {graphicspath}/input_grf

    // =================================================
    //       make dend1Gk_grf for synaptic conductances
    // =================================================
    create xgraph 	dend1Gk_grf 	[5,162,490,255] \
			-title "Dendrite #1 Gex and Ginh (mS)" 
    set dend1Gk_grf yoffset 0 YUnits "G (mS)"
    set dend1Gk_grf xmin 0 xmax 80 ymin -1e-6 ymax 5e-6 XUnits "t (msec)"
    useclock dend1Gk_grf 1
    makegraphscale {graphicspath}/dend1Gk_grf 
    // =================================================
    //      make dend1Vm_grf for intracellular potentials
    // =================================================
    create xgraph 	dend1Vm_grf 	[5,419,490,255] \
			-title "Dendrite #1 membrane potential Vm (mV)" 
    set dend1Vm_grf xmin 0 xmax 80 ymin -100 ymax 50 XUnits "t (msec)" \
                    YUnits "Vm (mV)"
    useclock dend1Vm_grf 0                     // also use fast clock for Vm
    makegraphscale {graphicspath}/dend1Vm_grf
    pop

    // =================================================
    //  make graphs for soma Vm and conductances
    // =================================================
    create xform	/output/somagraphs [510,10,500,675] -nolabel
    push /output/somagraphs
    create xgraph       activation_grf       [5,0,490,160] \
                        -title "Hodgkin-Huxley Activation Parameters"
    set activation_grf yoffset 2
    set activation_grf xmin 0 xmax 80 ymin 0 ymax 6 XUnits "t (msec)"
    useclock activation_grf 1
    makegraphscale /output/somagraphs/activation_grf

    create xgraph 	somaGk_grf 	[5,162,490,255] \
			-title "Soma GNa and GK (mS)" 
    set somaGk_grf yoffset 0 YUnits "G (mS)"
    set somaGk_grf xmin 0 xmax 80 ymin 0 ymax 1e-3 XUnits "t (msec)"
    useclock somaGk_grf 1
    makegraphscale /output/somagraphs/somaGk_grf

    create xgraph 	somaVm_grf 	[5,419,490,255] \
			-title "Soma membrane potential Vm (mV)" 
    set somaVm_grf xmin 0 xmax 80 ymin -100 ymax 50 XUnits "t (msec)" \
                   YUnits "Vm (mV)"
    useclock somaVm_grf 0
    makegraphscale /output/somagraphs/somaVm_grf
    pop

    // =================================================
    //       make dend2Gk_grf for synaptic conductances
    // =================================================
    create xform /output/dend2graphs [510,10,500,675] -nolabel
    push /output/dend2graphs
    str graphicspath = "/output/dend2graphs" //parameter to makegraphscale
    create xgraph 	dend2Gk_grf 	[5,162,490,255] \
			-title "Dendrite #2 Gex and Ginh (mS)" 
    set dend2Gk_grf yoffset 0 YUnits "G (mS)"
    set dend2Gk_grf xmin 0 xmax 80 ymin -1e-6 ymax 5e-6 XUnits "t (msec)"
    useclock dend2Gk_grf 1
    makegraphscale {graphicspath}/dend2Gk_grf 
    // =================================================
    //      make dend2Vm_grf for intracellular potentials
    // =================================================
    create xgraph 	dend2Vm_grf 	[5,419,490,255] \
			-title "Dendrite #2 membrane potential Vm (mV)" 
    set dend2Vm_grf xmin 0 xmax 80 ymin -100 ymax 50 XUnits "t (msec)" \
                    YUnits "Vm (mV)"
    useclock dend2Vm_grf 0
    makegraphscale {graphicspath}/dend2Vm_grf
    pop

    xshow /output/dend1graphs
    xshow /output/somagraphs
end     // loadgraphs

    // =================================================
    //                MAIN CONTROL PANEL
    // =================================================
function loadcontrol
    create xform 	/output/control [10,710,1000,140] -nolabel
    push /output/control
    create xbutton 	HELP	    [10,5,78,30]   \
                        -script "xshow_on_top /output/popups/helpmenu"
    create xbutton 	reset 	  [91,5,78,30]   -title RESET \
                        -script reset_kludge // in cell.g
    create xbutton 	stop 	  [172,5,78,30]  -title STOP  -script stop
    create xbutton 	quit 	  [253,5,78,30]  -title QUIT \
				    -script "quitbutton <widget>"
    makeconfirm(quit,"Quit Neuron?","quit","cancelquit <widget>",91,730)
    create xdialog	nsections    [165,75,165,30] -title "Cable Compts." \
		-value 0 -script "add_cable"   // make_cable.g
    create xtoggle 	overlay     [172,40,78,30]  -title "" \
				    -script "overlaytoggle <widget>"
    set overlay label0 "Overlay OFF" label1 "Overlay ON" state 0
    overlaytoggle /output/control/overlay
// be sure that it is in state 0 after Reset Defaults
    create xbutton	inputs	    [10,40,78,30] -title "Inputs" \
    			-script "xshow_on_top /output/popups/inputs"
    create xbutton	resetdefaults [91,40,78,30] -title "Reset Deflts" \
			-script "ResetDefaults"
    create xdialog 	step 	    [10,75,150,30] -title "STEP (msec)" \
			-script "stepbutton <widget>"  -value 80
    create xtoggle	plotsoma    [253,40,78,30]  -title "" \
           -script "formtoggle <widget> /output/somagraphs /output/dend2graphs"
    set plotsoma label0 "Plot Soma" label1 "Plot Dend2" state 0
    create xdialog 	stepsize    [10,110,330,30] -title "dt (msec)" \
			-script "change_stepsize"   -value {getclock(0)}
    create xlabel	cellparms  [835, 5,160,30] -title "Cell Parameters"
    create xbutton	somaparms  [835,40,160,30] -title "Soma" \
				   -script "xshow_on_top /output/popups/soma"
    create xbutton	dend1parms  [835,75,160,30] -title "Dendrite 1" \
				   -script "xshow_on_top /output/popups/dend1"
    create xbutton	dend2parms  [835,110,160,30] -title "Dendrite 2" \
				   -script "xshow_on_top /output/popups/dend2"
    pop
    
// dialog boxes to set dendrite connections
    str	inparms		= "/output/control/inparms"
    create xlabel {inparms} [545,5,280,25] -title "Dendrite Inputs"
    push {inparms}

// I need a more general way to do this when there are several dendrites
// The dialog boxes are initialized to 0 - check inputs.g for consistency

    create xdialog dend1_exwt [545,32,200,25]  -title "Dend #1 Exc. Wt." \
	-script "setweight dend1/Ex_channel <widget>" \
	-value 0
    create xtoggle dend1_exwt/source [748,32,77,25]  -title ""  \
    	-script "togglesource dend1/Ex_channel <widget>"
    set  dend1_exwt/source label0 "Source A" label1 "Source B" state 0

    create xdialog dend1_inhwt [545,59,200,25] -title "Dend #1 Inh. Wt." \
	-script "setweight dend1/Inh_channel <widget>" \
	-value 0
    create xtoggle dend1_inhwt/source [748,59,77,25]  -title ""  \
    	-script "togglesource dend1/Inh_channel <widget>"
    // Initialize inhibitory connections to source B
    set  dend1_inhwt/source label0 "Source A" label1 "Source B" state 1

    create xdialog dend2_exwt [545,86,200,25]  -title "Dend #2 Exc. Wt." \
	-script "setweight dend2/Ex_channel <widget>" \
	-value 0
    create xtoggle dend2_exwt/source [748,86,77,25]  -title ""  \
    	-script "togglesource dend2/Ex_channel <widget>"
    set  dend2_exwt/source label0 "Source A" label1 "Source B" state 0

    create xdialog dend2_inhwt [545,113,200,25] -title "Dend #2 Inh. Wt." \
	-script "setweight dend2/Inh_channel <widget>" \
	-value 0
    create xtoggle dend2_inhwt/source [748,113,77,25]  -title ""  \
    	-script "togglesource dend2/Inh_channel <widget>"
    // Initialize inhibitory connections to source B
    set  dend2_inhwt/source label0 "Source A" label1 "Source B" state 1

    pop

// Dialog boxes for injection currents
    
    create xlabel /output/control/injection [335,5,200,30] \
           -title "Injection Current (uA)"
    push /output/control/injection
    create xdialog soma_inj [335,40,200,30] -title "Soma Inj" \
	   -script "fieldbutton /input/injectpulse/somacurr gain <widget>" \
	   -value {get(/input/injectpulse/somacurr, gain)}

    create xdialog dend1_inj [335,75,200,30] -title "Dend 1 Inj" \
	   -script "fieldbutton /input/injectpulse/dend1curr gain <widget>" \
	   -value {get(/input/injectpulse/dend1curr, gain)}

    create xdialog dend2_inj [335,110,200,30] -title "Dend 2 Inj" \
	   -script "fieldbutton /input/injectpulse/dend2curr gain <widget>" \
	   -value {get(/input/injectpulse/dend2curr, gain)}

    pop

    // =================================================
    //                   Popup Menus
    // =================================================
// Popup Menus for Cell Parameters
    create neutral /output/popups
    make_comp_menu(soma)
    make_channel_menu(soma,Ex_channel)
    make_channel_menu(soma,Inh_channel)
    make_comp_menu(dend1)
    make_channel_menu(dend1,Ex_channel)
    make_channel_menu(dend1,Inh_channel)
    make_comp_menu(dend2)
    make_channel_menu(dend2,Ex_channel)
    make_channel_menu(dend2,Inh_channel)
// Popup Menu for Timing of Inputs
// More dependencies on inputs.g - dialog box initial values are hard-coded
    create xform /output/popups/inputs [745,10,265,370] \
		 -title "Input Timing (msec)"
    push /output/popups/inputs
    create xbutton DONE [5,40,250,30] -script "xhide /output/popups/inputs"
    create xlabel  sourceA [5,75,100,100]  -title "Source A"
    create xdialog Adelay  [110,75,150,30]  -title "Delay" -value 10 \
		 -script "set_input_timing"
    create xdialog Awidth  [110,110,150,30] -title "Width" -value 50 \
		 -script "set_input_timing"
    create xdialog Ainterval  [110,145,150,30] -title "Interval" -value 10 \
		 -script "set_input_timing"

    create xlabel  sourceB [5,185,100,100] -title "Source B"
    create xdialog Bdelay  [110,185,150,30]  -title "Delay" -value 20 \
		 -script "set_input_timing"
    create xdialog Bwidth  [110,220,150,30] -title "Width" -value 50 \
		 -script "set_input_timing"
    create xdialog Binterval  [110,255,150,30] -title "Interval" -value 10 \
		 -script "set_input_timing"

    create xlabel  injection [5,295,100,65] -title "Injection" \
		 -script "set_input_timing"
    create xdialog Idelay  [110,295,150,30] -title "Delay" -value 20 \
		 -script "set_input_timing"
    create xdialog Iwidth  [110,330,150,30] -title "Width" -value 40 \
		 -script "set_input_timing"
    pop
// popup help menu
    xshow /output/control
    loadhelp		// set up the help screens and menu (helpforms.g)
//    showintro		// show a big GIF image (in helpforms.g)
end			// loadcontrol

//kludge for fixing screwed-up graph labels
function fixdend1
  xhide /output/dend1graphs
  xshow /output/dend1graphs
end
