//genesis
// constants.g
randomseed	-new		// initialize the random # generator

float	PI		=	3.14159

// channel equilibrium potentials	mV
float	EREST_ACT	=	-70	// nominal rest potential used as a
					// reference potential for H-H channels
float	EREST		=	-70	// actual resting membrane potential

float 	ENa	=	125.0 + EREST_ACT	// +55 mV
float	EK	=	-10.0 + EREST_ACT	// -80 mV
float 	EEx	=	 60.0 + EREST_ACT	// -10 mv ( Na-K channel)
float	EInh	=	-10.0 + EREST_ACT	// -80 mV ( K channel)

//  leakage potential used in place of EREST in soma
float	Eleak		=	 11.7 + EREST_ACT   // -58.3 mV

// peak channel conductance	mS/synapse
float	GEx		=	100e-9          // Excitatory (Na-K channel)
float	GInh		=	100e-9          // Inhibitory (K channel)

// This notation should be changed to RM, CM, RA
float rm = 5.0				// Kohm-cm^2
float cm = 1.0				// uF/cm^2
float ra = 0.025				// Kohm-cm

// compartment dimensions (cm.)
float soma_l = 30e-4
float soma_d = 30e-4
float dend_l = 100e-4
float dend_d = 2e-4
