//genesis
/* compartment.g

	functions defined in this script
=============================================================================
	FUNCTION NAME		ARGUMENTS
=============================================================================
	makecompartment		(path,l,d,Erest)
=============================================================================
*/

//=================================================
//                    COMPARTMENT
//=================================================
function makecompartment(path,l,d,Erest)
    str path
    float l,d
    float Erest
    float area = l*PI*d
    float xarea = PI*d*d/4
/* global variables defined in constants.g
    float rm				// Kohm-cm^2
    float cm				// uF/cm^2
    float ra				// Kohm-cm
*/
    create 	compartment	{path}
    set		{path} \
		Em	{ Erest } \  		// mV
		Rm	{ rm/area } \  		// Kohm
		Cm	{ cm*area } \  		// uF
		Ra	{ ra*l/xarea } 		// Kohm
end
