//genesis
// cell.g
/* 
	functions defined in this script
=============================================================================
	FUNCTION NAME		ARGUMENTS
=============================================================================
	makeneuron		(path,soma_l,soma_d,dend_l,dend_d)
	reset_kludge
=============================================================================
*/

//=================================================
//                    NEURON
//=================================================
function makeneuron(path,soma_l,soma_d,dend_l,dend_d)
    str path
    float soma_l,soma_d
    float dend_l,dend_d

    float active_area = soma_l*PI*soma_d*1.0	// 100% of the soma active

    create 	neutral		{path}
    push {path}
    //=============================================
    //                   cell body
    //=============================================
    makecompartment(soma,{soma_l},{soma_d},{Eleak})
    position soma		I I R{-soma_l/2.0}

    //=============================================
    //          voltage dependent conductances
    //=============================================
    make_hhNa(soma,Ex_channel,{active_area},{ENa},{EREST_ACT})
    make_hhK(soma,Inh_channel,{active_area},{EK},{EREST_ACT})

    //=============================================
    //                   dendrites
    //=============================================
    makecompartment(dend1,{dend_l},{dend_d},{EREST})
    link_compartment		dend1		soma
    makecompartment(dend2,{dend_l},{dend_d},{EREST})
    link_compartment		dend2		dend1
    //=============================================
    //    synaptic conductances on the dendrites
    //=============================================
    makechannel(dend1,Ex_channel,{EEx},3.0,3.0,{GEx})
    makechannel(dend1,Inh_channel,{EInh},3.0,3.0,{GInh})
    makechannel(dend2,Ex_channel,{EEx},3.0,3.0,{GEx})
    makechannel(dend2,Inh_channel,{EInh},3.0,3.0,{GInh})

    pop
end

// reset_kludge is a kludge to properly initialize soma Vm to EREST on reset
function reset_kludge
   str color
   int cnum
   reset
   call /cell/soma RESET
   set /cell/soma Vm {EREST}
   call /cell/soma/Inh_channel/n RESET
   call /cell/soma/Inh_channel RESET
   call /cell/soma/Ex_channel/m RESET
   call /cell/soma/Ex_channel/h RESET
   call /cell/soma/Ex_channel RESET
   /* Also do some tricky business to allow cycling of colors with
      overlayed soma Vm plots                                      */
   push /output/somagraphs
   color = "black"
   if(get(somaVm_grf,overlay)==1)
      cnum = get(somaVm_grf,last_plot)%4
      if (cnum==0)
          color = "black"
      else
          if (cnum==1)
	     color = "red"
	  else
	     if (cnum==2)
	        color = "blue"
	     else
	        color = "green"
	     end
	  end
      end
   end
   deletemsg somaVm_grf IN #
   sendmsg  /cell/soma  somaVm_grf PLOT Vm *soma *{color}
   pop
end
